/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.artifacts.model.ContainerImageSignatureSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerImageSignatureCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="items")
    private final List<ContainerImageSignatureSummary> items;
    @JsonProperty(value="remainingItemsCount")
    private final Integer remainingItemsCount;

    @Deprecated
    @ConstructorProperties(value={"items", "remainingItemsCount"})
    public ContainerImageSignatureCollection(List<ContainerImageSignatureSummary> items, Integer remainingItemsCount) {
        this.items = items;
        this.remainingItemsCount = remainingItemsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<ContainerImageSignatureSummary> getItems() {
        return this.items;
    }

    public Integer getRemainingItemsCount() {
        return this.remainingItemsCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerImageSignatureCollection(");
        sb.append("super=").append(super.toString());
        sb.append("items=").append(String.valueOf(this.items));
        sb.append(", remainingItemsCount=").append(String.valueOf(this.remainingItemsCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerImageSignatureCollection)) {
            return false;
        }
        ContainerImageSignatureCollection other = (ContainerImageSignatureCollection)((Object)o);
        return Objects.equals(this.items, other.items) && Objects.equals(this.remainingItemsCount, other.remainingItemsCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + (this.remainingItemsCount == null ? 43 : this.remainingItemsCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="items")
        private List<ContainerImageSignatureSummary> items;
        @JsonProperty(value="remainingItemsCount")
        private Integer remainingItemsCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder items(List<ContainerImageSignatureSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public Builder remainingItemsCount(Integer remainingItemsCount) {
            this.remainingItemsCount = remainingItemsCount;
            this.__explicitlySet__.add("remainingItemsCount");
            return this;
        }

        public ContainerImageSignatureCollection build() {
            ContainerImageSignatureCollection model = new ContainerImageSignatureCollection(this.items, this.remainingItemsCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerImageSignatureCollection model) {
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            if (model.wasPropertyExplicitlySet("remainingItemsCount")) {
                this.remainingItemsCount(model.getRemainingItemsCount());
            }
            return this;
        }
    }
}

