/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes.actions;

import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.payara.common.nodes.actions.UndeployModuleCookie;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class UndeployModuleAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            return;
        }
        RequestProcessor undeployer = new RequestProcessor("pf-undeployer");
        for (Node node : nodes) {
            UndeployModuleCookie uCookie = (UndeployModuleCookie)node.getCookie(UndeployModuleCookie.class);
            if (uCookie == null) continue;
            final Future<ResultString> result = uCookie.undeploy();
            Node pNode = node.getParentNode();
            final Node gpNode = null != pNode ? pNode.getParentNode() : null;
            final Node fnode = node;
            undeployer.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.get(15000L, ServerUtilities.ACTION_TIMEOUT_UNIT);
                    }
                    catch (TimeoutException ex) {
                        Logger.getLogger("payara").log(Level.WARNING, "Undeploy action timed out for " + fnode.getDisplayName());
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Exception ex) {
                        Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    if (gpNode != null) {
                        Node[] nodes;
                        for (Node node : nodes = gpNode.getChildren().getNodes()) {
                            RefreshModulesCookie cookie = (RefreshModulesCookie)node.getCookie(RefreshModulesCookie.class);
                            if (cookie == null) continue;
                            cookie.refresh(null, fnode.getDisplayName());
                        }
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            UndeployModuleCookie cookie = (UndeployModuleCookie)node.getCookie(UndeployModuleCookie.class);
            if (cookie != null && !cookie.isRunning()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(UndeployModuleAction.class, (String)"LBL_UndeployAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

