/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.nodes.actions.OpenURLActionCookie;
import org.netbeans.modules.payara.common.nodes.actions.UndeployModuleCookie;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenURLAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        for (Node node : nodes) {
            OpenURLActionCookie oCookie = (OpenURLActionCookie)node.getCookie(OpenURLActionCookie.class);
            if (oCookie == null) continue;
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(oCookie.getWebURL()));
            }
            catch (MalformedURLException ex) {
                Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            OpenURLActionCookie oCookie = (OpenURLActionCookie)node.getCookie(OpenURLActionCookie.class);
            UndeployModuleCookie uCookie = (UndeployModuleCookie)node.getCookie(UndeployModuleCookie.class);
            if (uCookie != null && uCookie.isRunning()) {
                return false;
            }
            if (oCookie == null || oCookie.getWebURL() == null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(OpenURLAction.class, (String)"LBL_OpenInBrowserAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

