/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.modules.payara.common.BasicTask;
import org.netbeans.modules.payara.common.CommonServerSupport;
import org.netbeans.modules.payara.common.EnableComet;
import org.netbeans.modules.payara.common.LogViewMgr;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraJvmMode;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.PayaraState;
import org.netbeans.modules.payara.common.ProcessCreationException;
import org.netbeans.modules.payara.common.ui.JavaSEPlatformPanel;
import org.netbeans.modules.payara.common.utils.AdminKeyFile;
import org.netbeans.modules.payara.common.utils.JavaUtils;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.spi.Recognizer;
import org.netbeans.modules.payara.spi.VMIntrospector;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.PayaraStatus;
import org.netbeans.modules.payara.tooling.PayaraStatusListener;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.CommandStartCluster;
import org.netbeans.modules.payara.tooling.admin.CommandStartInstance;
import org.netbeans.modules.payara.tooling.admin.CommandVersion;
import org.netbeans.modules.payara.tooling.admin.ResultProcess;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraServerStatus;
import org.netbeans.modules.payara.tooling.data.StartupArgs;
import org.netbeans.modules.payara.tooling.data.StartupArgsEntity;
import org.netbeans.modules.payara.tooling.server.FetchLog;
import org.netbeans.modules.payara.tooling.server.FetchLogSimple;
import org.netbeans.modules.payara.tooling.server.ServerTasks;
import org.netbeans.modules.payara.tooling.utils.NetUtils;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class StartTask
extends BasicTask<TaskState> {
    private static final Logger LOGGER = PayaraLogger.get(StartTask.class);
    private static RequestProcessor NODE_REFRESHER = new RequestProcessor("nodes to refresh");
    private final CommonServerSupport support;
    private List<Recognizer> recognizers;
    private List<String> jvmArgs = null;
    private final VMIntrospector vmi;
    private FileObject jdkHome;

    private static String[] removeEscapes(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].replace("\\\"", "");
        }
        return args;
    }

    private static StartupExtender.StartMode getMode(String gfMode) {
        if (PayaraModule.PROFILE_MODE.equals(gfMode)) {
            return StartupExtender.StartMode.PROFILE;
        }
        if (PayaraModule.DEBUG_MODE.equals(gfMode)) {
            return StartupExtender.StartMode.DEBUG;
        }
        return StartupExtender.StartMode.NORMAL;
    }

    public StartTask(CommonServerSupport support, List<Recognizer> recognizers, VMIntrospector vmi, TaskStateListener ... stateListener) {
        this(support, recognizers, vmi, (String[])null, stateListener);
    }

    public StartTask(final CommonServerSupport support, List<Recognizer> recognizers, VMIntrospector vmi, String[] jvmArgs, TaskStateListener ... stateListener) {
        super(support.getInstance(), stateListener);
        ArrayList<TaskStateListener> listeners = new ArrayList<TaskStateListener>();
        listeners.addAll(Arrays.asList(stateListener));
        listeners.add(new TaskStateListener(){

            public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
                if (TaskState.COMPLETED.equals((Object)newState)) {
                    RequestProcessor.getDefault().post((Runnable)new EnableComet(support.getInstance()));
                }
            }
        });
        this.stateListener = listeners.toArray(new TaskStateListener[0]);
        this.support = support;
        this.recognizers = recognizers;
        this.jvmArgs = jvmArgs != null ? Arrays.asList(StartTask.removeEscapes(jvmArgs)) : null;
        this.vmi = vmi;
        this.jdkHome = null;
        LOGGER.log(Level.FINE, "VMI == {0}", vmi);
    }

    @Override
    public TaskState call() {
        LOGGER.log(Level.FINEST, "StartTask.call() called on thread \"{0}\"", Thread.currentThread().getName());
        long start = System.currentTimeMillis();
        String host = this.instance.getHost();
        int adminPort = this.instance.getAdminPort();
        BasicTask.StateChange change = this.validateAdminHostAndPort(host, adminPort);
        if (change != null) {
            return change.fireOperationStateChanged();
        }
        if (this.support.isRemote()) {
            if (PayaraState.isOnline(this.instance)) {
                if (Util.isDefaultOrServerTarget(this.instance.getProperties())) {
                    return this.restartDAS(host, adminPort, start);
                }
                return this.startClusterOrInstance(host, adminPort);
            }
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_START_SERVER_FAILED_DASDOWN", this.instanceName);
        }
        if (PayaraState.isOffline(this.instance)) {
            if (ServerUtils.isAdminPortListening((PayaraServer)this.instance, (int)2000)) {
                ResultString version;
                try {
                    version = CommandVersion.getVersion((PayaraServer)this.instance);
                }
                catch (CommandException ce) {
                    version = null;
                }
                if (version != null) {
                    if (CommandVersion.verifyResult((ResultString)version, (PayaraServer)this.instance)) {
                        this.fireOperationStateChanged(TaskState.RUNNING, TaskEvent.CMD_COMPLETED, "StartTask.call.matchVersion", version.getValue());
                        return this.startClusterOrInstance(host, adminPort);
                    }
                    if (!version.isAuth()) {
                        return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "StartTask.call.authFailed", this.instanceName, version.getValue());
                    }
                    return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "StartTask.call.anotherVersion", this.instanceName, version.getValue());
                }
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "StartTask.call.unknownVersion", this.instanceName);
            }
            return this.startDAS(host, adminPort);
        }
        return this.startClusterOrInstance(host, adminPort);
    }

    private BasicTask.StateChange validateAdminHostAndPort(String host, int adminPort) {
        if (host == null || host.length() == 0) {
            return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        if (adminPort < 0 || adminPort > 65535) {
            return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        return null;
    }

    private TaskState restartDAS(String adminHost, int adminPort, final long start) {
        TaskStateListener[] listeners = new TaskStateListener[]{new TaskStateListener(){

            public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
                if (newState == TaskState.RUNNING) {
                    StartTask.this.support.setServerState(PayaraModule.ServerState.STARTING);
                }
                if (newState == TaskState.FAILED) {
                    StartTask.this.fireOperationStateChanged(newState, event, StartTask.this.instanceName, args);
                    StartTask.this.support.setServerState(PayaraModule.ServerState.STOPPED);
                } else if (args != null && newState == TaskState.COMPLETED) {
                    for (String message : args) {
                        if (!message.matches("[sg]et\\?.*\\=configs\\..*")) continue;
                        return;
                    }
                    long startTime = System.currentTimeMillis();
                    TaskState state = TaskState.RUNNING;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException message) {
                        // empty catch block
                    }
                    while (TaskState.RUNNING == state && System.currentTimeMillis() - start < 300000L) {
                        boolean httpLive = PayaraState.isOnline(StartTask.this.instance);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!httpLive) continue;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        state = TaskState.COMPLETED;
                    }
                    if (state == TaskState.COMPLETED) {
                        StartTask.this.support.setServerState(PayaraModule.ServerState.RUNNING);
                    } else {
                        StartTask.this.support.setServerState(PayaraModule.ServerState.STOPPED);
                    }
                }
            }
        }};
        int debugPort = -1;
        if (PayaraModule.DEBUG_MODE.equals(this.instance.getProperty("jvmMode"))) {
            debugPort = this.instance.getDebugPort();
        }
        this.support.restartServer(debugPort, this.support.supportsRestartInDebug() && debugPort >= 0, listeners);
        return this.fireOperationStateChanged(TaskState.RUNNING, TaskEvent.CMD_FAILED, "StartTask.restartDAS.inProgress", this.instanceName);
    }

    private void resetPassword() {
        AdminKeyFile keyFile = new AdminKeyFile(this.instance);
        keyFile.read();
        if (keyFile.isReset()) {
            String password = AdminKeyFile.randomPassword(12);
            this.instance.setAdminPassword(password);
            keyFile.setPassword(password);
            try {
                PayaraInstance.writeInstanceToFile(this.instance);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Could not store Payara server attributes", ex);
            }
            keyFile.write();
        }
    }

    private BasicTask.StateChange initJDK() {
        try {
            if (null == this.jdkHome) {
                this.jdkHome = this.getJavaPlatformRoot();
                File jdkHomeFile = FileUtil.toFile((FileObject)this.jdkHome);
                if (!JavaUtils.isJavaPlatformSupported(this.instance, jdkHomeFile)) {
                    this.jdkHome = JavaSEPlatformPanel.selectServerSEPlatform(this.instance, jdkHomeFile);
                }
            }
            if (this.jdkHome == null) {
                return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "StartTask.initJDK.null", this.instanceName);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "StartTask.initJDK.exception", this.instanceName, ex.getLocalizedMessage());
        }
        return null;
    }

    private BasicTask.StateChange checkBeforeStart() {
        PayaraServerStatus status = PayaraState.getStatus(this.instance);
        String msgKey = null;
        switch (status.getStatus()) {
            case ONLINE: {
                TaskEvent event;
                TaskState result;
                if (PayaraModule.PROFILE_MODE.equals(this.instance.getProperty("jvmMode"))) {
                    result = TaskState.FAILED;
                    event = TaskEvent.CMD_FAILED;
                } else {
                    result = TaskState.COMPLETED;
                    event = TaskEvent.CMD_COMPLETED;
                }
                return new BasicTask.StateChange(this, result, event, "StartTask.startDAS.alreadyRunning");
            }
            case OFFLINE: {
                if (ServerUtils.isAdminPortListening((PayaraServer)this.instance, (int)2000)) {
                    msgKey = "StartTask.startDAS.adminPortOccupied";
                    break;
                }
                int httpPort = this.instance.getPort();
                if (httpPort < 0 || httpPort > 65535 || !NetUtils.isPortListeningLocal((String)this.instance.getHost(), (int)httpPort)) break;
                msgKey = "StartTask.startDAS.httpPortOccupied";
                break;
            }
            case SHUTDOWN: {
                msgKey = "StartTask.startDAS.shutdown";
                break;
            }
            case STARTUP: {
                msgKey = "StartTask.startDAS.startup";
            }
        }
        return msgKey != null ? new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, msgKey, this.instance.getDisplayName()) : null;
    }

    private BasicTask.StateChange profilingServerStatus() {
        LOGGER.log(Level.FINE, "Profiling mode status hack for {0}", new Object[]{this.instance.getName()});
        this.support.setLocalStartProcess(this.instance.getProcess());
        NODE_REFRESHER.post(new Runnable(){

            @Override
            public void run() {
                while (!PayaraState.isOnline(StartTask.this.instance)) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StartTask.this.support.refresh();
                    }
                });
            }
        });
        return new BasicTask.StateChange(this, TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskState startDAS(String adminHost, int adminPort) {
        BasicTask.StartStateListener listener;
        this.resetPassword();
        BasicTask.StateChange change = this.initJDK();
        if (change != null) {
            return change.fireOperationStateChanged();
        }
        long start = System.currentTimeMillis();
        try {
            LOGGER.log(Level.FINEST, "Checking if Payara {0} is running.", this.instance.getName());
            change = this.checkBeforeStart();
            if (change != null) {
                return change.fireOperationStateChanged();
            }
            listener = this.prepareStartMonitoring(this.instance.getJvmMode() == PayaraJvmMode.PROFILE);
            if (listener == null) {
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "StartTask.startDAS.startupMonitoring", this.instanceName);
            }
            Process process = this.createProcess();
            this.instance.setProcess(process);
            listener.setProcess(process);
        }
        catch (ProcessCreationException ex) {
            Logger.getLogger("payara").log(Level.INFO, "Could not start process for " + this.instanceName, ex);
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_PASS_THROUGH", ex.getLocalizedMessage());
        }
        this.fireOperationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, "StartTask.startDAS.inProgress", this.instanceName);
        LogViewMgr logger = LogViewMgr.getInstance(this.instance.getProperty("url"));
        logger.readInputStreams(this.recognizers, true, null, new FetchLog[]{new FetchLogSimple(this.instance.getProcess().getInputStream()), new FetchLogSimple(this.instance.getProcess().getErrorStream())});
        LOGGER.log(Level.FINER, "Waiting for server to start for {0} ms", new Object[]{Integer.toString(300000)});
        try {
            BasicTask.StartStateListener startStateListener = listener;
            synchronized (startStateListener) {
                while (!listener.isWakeUp() && System.currentTimeMillis() - start < 300000L) {
                    listener.wait(System.currentTimeMillis() - start);
                }
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, "Caught InterruptedException while waiting for {0} to start: {1}", new Object[]{this.instance.getName(), ie.getLocalizedMessage()});
        }
        finally {
            PayaraStatus.removeListener((PayaraServer)this.instance, (PayaraStatusListener)listener);
        }
        if (null != this.jvmArgs && (change = this.profilingServerStatus()) != null) {
            return change.fireOperationStateChanged();
        }
        if (!PayaraState.isOnline(this.instance)) {
            PayaraStatus.suspend((PayaraServer)this.instance);
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "StartTask.startDAS.startFailed", this.instanceName);
        }
        return this.startClusterOrInstance(adminHost, adminPort);
    }

    private TaskState startClusterOrInstance(String adminHost, int adminPort) {
        TaskState state;
        ResultString result;
        String target = Util.computeTarget(this.instance.getProperties());
        if (Util.isDefaultOrServerTarget(this.instance.getProperties())) {
            return this.fireOperationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
        }
        try {
            result = CommandStartCluster.startCluster((PayaraServer)this.instance, (String)target);
            state = result.getState();
        }
        catch (PayaraIdeException gfie) {
            state = TaskState.FAILED;
            LOGGER.log(Level.INFO, gfie.getMessage(), gfie);
        }
        if (state == TaskState.FAILED) {
            try {
                result = CommandStartInstance.startInstance((PayaraServer)this.instance, (String)target);
                state = result.getState();
            }
            catch (PayaraIdeException gfie) {
                state = TaskState.FAILED;
                LOGGER.log(Level.INFO, gfie.getMessage(), gfie);
            }
            if (state == TaskState.FAILED) {
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_START_TARGET_FAILED", this.instanceName, target);
            }
        }
        this.support.updateHttpPort();
        return this.fireOperationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "MSG_SERVER_STARTED", this.instanceName);
    }

    private FileObject getJavaPlatformRoot() throws IOException {
        FileObject retVal;
        String javaHome = this.instance.getJavaHome();
        if (null == javaHome || javaHome.trim().length() < 1) {
            File dir = new File(this.getJdkHome());
            retVal = FileUtil.createFolder((File)FileUtil.normalizeFile((File)dir));
        } else {
            File f = new File(javaHome);
            if (f.exists()) {
                retVal = FileUtil.createFolder((File)FileUtil.normalizeFile((File)f));
            } else {
                throw new FileNotFoundException(NbBundle.getMessage(StartTask.class, (String)"MSG_INVALID_JAVA", (Object)this.instanceName, (Object)javaHome));
            }
        }
        return retVal;
    }

    private String getJdkHome() {
        String result = System.getProperty("java.home");
        if (result.endsWith(File.separatorChar + "jre")) {
            result = result.substring(0, result.length() - 4);
        }
        return result;
    }

    private StartupArgs createProcessDescriptor() throws ProcessCreationException {
        ArrayList<String> payaraArgs = new ArrayList<String>(2);
        String domainDir = Util.quote(this.getDomainFolder().getAbsolutePath());
        payaraArgs.add(ServerUtils.cmdLineArgument((String)ServerUtils.PF_DOMAIN_ARG, (String)this.getDomainName()));
        payaraArgs.add(ServerUtils.cmdLineArgument((String)ServerUtils.PF_DOMAIN_DIR_ARG, (String)domainDir));
        ArrayList<String> optList = new ArrayList<String>();
        if (PayaraModule.DEBUG_MODE.equals(this.instance.getProperty("jvmMode"))) {
            this.appendDebugOptions(optList);
        }
        this.appendStartupExtenderParams(optList);
        return new StartupArgsEntity(payaraArgs, optList, (Map)null, FileUtil.toFile((FileObject)this.jdkHome).getAbsolutePath());
    }

    private void appendDebugOptions(List<String> optList) throws ProcessCreationException {
        int t;
        String debugPortString = this.instance.getProperty("debugPort");
        String debugTransport = "dt_socket";
        if ("true".equals(this.instance.getProperty("use.shared.mem"))) {
            debugTransport = "dt_shmem";
        } else if (null != debugPortString && debugPortString.trim().length() > 0 && (t = Integer.parseInt(debugPortString)) != 0 && (t < PayaraInstance.LOWEST_USER_PORT || t > 65535)) {
            throw new NumberFormatException();
        }
        if (null == debugPortString || "0".equals(debugPortString) || "".equals(debugPortString)) {
            if ("true".equals(this.instance.getProperty("use.shared.mem"))) {
                debugPortString = Integer.toString(Math.abs((this.instance.getProperty("homefolder") + this.instance.getDomainsRoot() + this.instance.getProperty("domainname")).hashCode() + 1));
            } else {
                try {
                    debugPortString = this.selectDebugPort();
                }
                catch (IOException ioe) {
                    throw new ProcessCreationException(ioe, "MSG_START_SERVER_FAILED_INVALIDPORT", this.instanceName, debugPortString);
                }
            }
        }
        this.support.setEnvironmentProperty("debugPort", debugPortString, true);
        StringBuilder opt = new StringBuilder();
        opt.append("-agentlib:jdwp=transport=");
        opt.append(debugTransport);
        opt.append(",address=");
        opt.append(debugPortString);
        opt.append(",server=y,suspend=n");
        optList.add(opt.toString());
    }

    private void appendStartupExtenderParams(List<String> optList) {
        for (StartupExtender args : StartupExtender.getExtenders((Lookup)Lookups.singleton((Object)this.support.getInstanceProvider().getInstance(this.instance.getProperty("url"))), (StartupExtender.StartMode)StartTask.getMode(this.instance.getProperty("jvmMode")))) {
            for (String arg : args.getArguments()) {
                String[] argSplitted = arg.trim().split("\\s+(?=-)");
                optList.addAll(Arrays.asList(argSplitted));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectDebugPort() throws IOException {
        int debugPort = 9009;
        ServerSocket t = null;
        try {
            t = new ServerSocket(debugPort);
            String string = Integer.toString(debugPort);
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger("payara").fine("9009 is in use... going random");
        }
        finally {
            if (null != t) {
                try {
                    t.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            t = new ServerSocket(0);
            debugPort = t.getLocalPort();
            String string = Integer.toString(debugPort);
            return string;
        }
        finally {
            if (null != t) {
                try {
                    t.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Process createProcess() throws ProcessCreationException {
        StartupArgs args = this.createProcessDescriptor();
        ResultProcess process = ServerTasks.startServer((PayaraServer)this.instance, (StartupArgs)args);
        if (process.getState() != TaskState.COMPLETED) {
            throw new ProcessCreationException(null, "MSG_START_SERVER_FAILED_PD", this.instanceName);
        }
        return process.getValue().getProcess();
    }

    private File getDomainFolder() {
        return new File(this.instance.getDomainsRoot() + File.separatorChar + this.getDomainName());
    }

    private String getDomainName() {
        return this.instance.getProperty("domainname");
    }
}

