/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.eclipse.osgi.util.ManifestElement;
import org.netbeans.modules.maven.osgi.Bundle;
import org.netbeans.modules.maven.spi.nodes.DependencyTypeIconBadge;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.osgi.framework.BundleException;

public class OSGiJarAccessibilityQueryImpl
implements AccessibilityQueryImplementation,
DependencyTypeIconBadge {
    private static final Logger LOG = Logger.getLogger(OSGiJarAccessibilityQueryImpl.class.getName());
    private static final String BADGE = "org/netbeans/modules/maven/osgi/maven_osgi_badge.png";
    private static final String toolTip = "<img src=\"" + OSGiJarAccessibilityQueryImpl.class.getClassLoader().getResource("org/netbeans/modules/maven/osgi/maven_osgi_badge.png") + "\">&nbsp;" + Bundle.Tooltip_manifest();
    private final WeakHashMap<FileObject, List<ManifestElement>> publicCache = new WeakHashMap();
    private final List<ManifestElement> NOT_OSGIJAR = new ArrayList<ManifestElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isPubliclyAccessible(FileObject pkg) {
        FileObject jarFile = FileUtil.getArchiveFile((FileObject)pkg);
        boolean notOSGi = true;
        if (jarFile != null) {
            FileObject jarRoot = FileUtil.getArchiveRoot((FileObject)jarFile);
            WeakHashMap<FileObject, List<ManifestElement>> weakHashMap = this.publicCache;
            synchronized (weakHashMap) {
                List<ManifestElement> pub = this.publicCache.get(jarRoot);
                if (pub != null) {
                    if (pub == this.NOT_OSGIJAR) {
                        return null;
                    }
                    String relPath = FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)pkg);
                    assert (relPath != null) : "null path for : " + jarRoot + ", " + pkg;
                    if (relPath == null) {
                        LOG.log(Level.WARNING, "null path for : {0}, {1}", new Object[]{jarRoot, pkg});
                        return Boolean.FALSE;
                    }
                    return this.check(pub, relPath.replace("/", "."));
                }
            }
            FileObject manifest = jarRoot.getFileObject("META-INF/MANIFEST.MF");
            if (manifest != null) {
                try {
                    Manifest mf = new Manifest(manifest.getInputStream());
                    List<ManifestElement> pub = null;
                    String exportPack = mf.getMainAttributes().getValue("Export-Package");
                    if (exportPack != null) {
                        try {
                            ManifestElement[] mans = ManifestElement.parseHeader((String)"Export-Package", (String)exportPack);
                            pub = Arrays.asList(mans);
                        }
                        catch (BundleException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (pub != null) {
                        WeakHashMap<FileObject, List<ManifestElement>> ex = this.publicCache;
                        synchronized (ex) {
                            this.publicCache.put(jarRoot, pub);
                        }
                        String relPath = FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)pkg);
                        assert (relPath != null) : "null path for : " + jarRoot + ", " + pkg;
                        if (relPath == null) {
                            LOG.log(Level.WARNING, "null path for : {0}, {1}", new Object[]{jarRoot, pkg});
                            return Boolean.FALSE;
                        }
                        return this.check(pub, relPath.replace("/", "."));
                    }
                    notOSGi = mf.getMainAttributes().getValue("Bundle-SymbolicName") == null;
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "cannot read manifest", ex);
                }
            }
            WeakHashMap<FileObject, List<ManifestElement>> weakHashMap2 = this.publicCache;
            synchronized (weakHashMap2) {
                this.publicCache.put(jarRoot, notOSGi ? this.NOT_OSGIJAR : Collections.emptyList());
            }
        }
        return notOSGi ? null : Boolean.FALSE;
    }

    private Boolean check(List<ManifestElement> pub, String packageName) {
        for (ManifestElement p : pub) {
            if (!packageName.equals(p.getValue())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getBadgeIcon(FileObject jarFile, Artifact art) {
        if (jarFile != null && FileUtil.isArchiveFile((FileObject)jarFile)) {
            FileObject jarRoot = FileUtil.getArchiveRoot((FileObject)jarFile);
            WeakHashMap<FileObject, List<ManifestElement>> weakHashMap = this.publicCache;
            synchronized (weakHashMap) {
                List<ManifestElement> pub = this.publicCache.get(jarRoot);
                if (pub != null) {
                    if (pub == this.NOT_OSGIJAR) {
                        return null;
                    }
                    return this.getIcon();
                }
            }
            FileObject manifest = jarRoot.getFileObject("META-INF/MANIFEST.MF");
            if (manifest != null) {
                try {
                    Manifest mf = new Manifest(manifest.getInputStream());
                    Object pub = null;
                    String name = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                    if (name != null) {
                        return this.getIcon();
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "cannot read manifest", ex);
                }
            }
            WeakHashMap<FileObject, List<ManifestElement>> weakHashMap2 = this.publicCache;
            synchronized (weakHashMap2) {
                this.publicCache.put(jarRoot, this.NOT_OSGIJAR);
            }
        }
        return null;
    }

    private Image getIcon() {
        return ImageUtilities.addToolTipToImage((Image)ImageUtilities.loadImage((String)BADGE), (String)toolTip);
    }
}

