/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.insane.model.HeapModel;
import org.netbeans.insane.model.Item;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlHeapModel
implements HeapModel {
    private Map<Integer, Item> items = new HashMap<Integer, Item>();
    private Map<String, Item> roots = new HashMap<String, Item>();

    public static HeapModel parse(File file) throws Exception {
        XmlHeapModel model = new XmlHeapModel(new InputSource(new FileInputStream(file)));
        return model;
    }

    @Override
    public Iterator<Item> getAllItems() {
        return Collections.unmodifiableCollection(this.items.values()).iterator();
    }

    @Override
    public Collection<Item> getObjectsOfType(String type) {
        ArrayList<Item> filter = new ArrayList<Item>();
        Iterator<Item> it = this.getAllItems();
        while (it.hasNext()) {
            Item act = it.next();
            if (!type.equals(act.getType())) continue;
            filter.add(act);
        }
        return filter;
    }

    @Override
    public Collection<String> getRoots() {
        return Collections.unmodifiableSet(this.roots.keySet());
    }

    @Override
    public Item getObjectAt(String staticRefName) {
        return this.roots.get(staticRefName);
    }

    @Override
    public Item getItem(int id) {
        Item itm = this.items.get(id);
        if (itm == null) {
            throw new IllegalArgumentException("Bad ID");
        }
        return itm;
    }

    private XmlHeapModel(InputSource is) throws Exception {
        Handler h = new Handler();
        SAXParserFactory fact = SAXParserFactory.newInstance();
        SAXParser parser = fact.newSAXParser();
        parser.getXMLReader().setContentHandler(h);
        parser.getXMLReader().parse(is);
    }

    Item createItem(int id, String type, int size, String val) {
        MemItem item = new MemItem(id, type, size, val);
        this.items.put(id, item);
        return item;
    }

    void addReference(int from, int to) {
        MemItem f = (MemItem)this.getItem(from);
        MemItem t = (MemItem)this.getItem(to);
        f.addOutgoing(t);
        t.addIncomming(f);
    }

    void addReference(String stat, int to) {
        MemItem t = (MemItem)this.getItem(to);
        t.addIncomming(stat);
    }

    int getIdFromString(String s) {
        return Integer.parseInt(s, 16);
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;

        private Handler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.depth == 0) {
                if (!"insane".equals(qName)) {
                    throw new SAXException("format");
                }
            } else {
                if (this.depth != 1) {
                    throw new SAXException("format");
                }
                if ("object".equals(qName)) {
                    String id = atts.getValue("id");
                    String type = atts.getValue("type");
                    String size = atts.getValue("size");
                    String val = atts.getValue("value");
                    XmlHeapModel.this.createItem(XmlHeapModel.this.getIdFromString(id), type, Integer.parseInt(size), val);
                } else if ("ref".equals(qName)) {
                    String from = atts.getValue("from");
                    String name = atts.getValue("name");
                    String to = atts.getValue("to");
                    if (from != null) {
                        XmlHeapModel.this.addReference(XmlHeapModel.this.getIdFromString(from), XmlHeapModel.this.getIdFromString(to));
                    } else {
                        XmlHeapModel.this.addReference(name, XmlHeapModel.this.getIdFromString(to));
                    }
                } else {
                    throw new SAXException("format");
                }
            }
            ++this.depth;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            --this.depth;
        }
    }

    static class MemItem
    implements Item {
        private Object[] incommingRefs = new Object[0];
        private Item[] outgoingRefs = new Item[0];
        private int id;
        private int size;
        private String type;
        private String value;

        MemItem(int id, String type, int size, String value) {
            this.id = id;
            this.type = type.intern();
            this.size = size;
            this.value = value;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public Enumeration<Object> incomming() {
            return new RefEnum<Object>(this.incommingRefs);
        }

        @Override
        public Enumeration<Item> outgoing() {
            return new RefEnum<Item>(this.outgoingRefs);
        }

        @Override
        public int getId() {
            return this.id;
        }

        public String toString() {
            if (this.value == null) {
                return this.type + "@" + Integer.toHexString(this.id);
            }
            return this.type + "@" + Integer.toHexString(this.id) + ": \"" + this.value + '\"';
        }

        void addIncomming(Object incomming) {
            Object[] nr = new Object[this.incommingRefs.length + 1];
            nr[0] = incomming;
            System.arraycopy(this.incommingRefs, 0, nr, 1, this.incommingRefs.length);
            this.incommingRefs = nr;
        }

        void addOutgoing(Item outgoing) {
            Item[] nr = new Item[this.outgoingRefs.length + 1];
            nr[this.outgoingRefs.length] = outgoing;
            System.arraycopy(this.outgoingRefs, 0, nr, 0, this.outgoingRefs.length);
            this.outgoingRefs = nr;
        }
    }

    private static class RefEnum<T>
    implements Enumeration<T> {
        int ptr;
        T[] items;

        RefEnum(T[] data) {
            this.items = data;
        }

        @Override
        public boolean hasMoreElements() {
            return this.ptr < this.items.length;
        }

        @Override
        public T nextElement() {
            if (this.hasMoreElements()) {
                return this.items[this.ptr++];
            }
            throw new NoSuchElementException();
        }
    }
}

