/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.branch.Bundle;
import org.netbeans.modules.git.ui.branch.CreateBranch;
import org.netbeans.modules.git.ui.checkout.SwitchBranchAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class CreateBranchAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CreateBranchAction.class.getName());
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/branch.png";

    public CreateBranchAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.createBranch(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void createBranch(File repository, String preselectedRevision) {
        final CreateBranch createBranch = new CreateBranch(repository, preselectedRevision, this.getBranches(repository));
        if (createBranch.show()) {
            if (createBranch.isCheckoutSelected()) {
                ((SwitchBranchAction)SystemAction.get(SwitchBranchAction.class)).checkoutRevision(repository, createBranch.getRevision(), createBranch.getBranchName(), Bundle.LBL_CreateBranchAction_progressName());
            } else {
                GitProgressSupport supp = new GitProgressSupport(){

                    @Override
                    protected void perform() {
                        try {
                            GitClient client = this.getClient();
                            String revision = createBranch.getRevision();
                            LOG.log(Level.FINE, "Creating a branch: {0}", revision);
                            GitBranch branch = client.createBranch(createBranch.getBranchName(), createBranch.getRevision(), this.getProgressMonitor());
                            this.log(revision, branch);
                        }
                        catch (GitException ex) {
                            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        }
                    }

                    private void log(String revision, GitBranch branch) {
                        OutputLogger logger = this.getLogger();
                        logger.outputLine(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CreateBranchAction.branchCreated", (Object[])new Object[]{branch.getName(), revision, branch.getId()}));
                    }
                };
                supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_CreateBranchAction_progressName());
            }
        }
    }

    private Map<String, GitBranch> getBranches(File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        return info.getBranches();
    }
}

