/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.doctrine2.annotations.odm.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.annotation.util.AnnotationUtils;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class TypedParametersAnnotationLineParser
implements AnnotationLineParser {
    private static final Map<String, Set<String>> ANNOTATIONS = new HashMap<String, Set<String>>();

    public AnnotationParsedLine parse(String line) {
        AnnotationParsedLine.ParsedLine result = null;
        String[] tokens = line.split("\\(");
        for (Map.Entry<String, Set<String>> entry : ANNOTATIONS.entrySet()) {
            if (tokens.length <= 0 || !AnnotationUtils.isTypeAnnotation((String)tokens[0], (String)entry.getKey())) continue;
            String annotation = tokens[0].trim();
            String description = line.substring(annotation.length()).trim();
            HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
            types.put(new OffsetRange(0, annotation.length()), annotation);
            types.putAll(AnnotationUtils.extractTypesFromParameters((String)line, entry.getValue()));
            result = new AnnotationParsedLine.ParsedLine(entry.getKey(), types, description, true);
            break;
        }
        return result;
    }

    static {
        HashSet<String> discriminatorMapRegexs = new HashSet<String>();
        discriminatorMapRegexs.add("\\\"\\s*\\w+\\s*\\\"");
        ANNOTATIONS.put("DiscriminatorMap", discriminatorMapRegexs);
        HashSet<String> embedManyRegexs = new HashSet<String>();
        embedManyRegexs.add("targetDocument");
        embedManyRegexs.add("\\\"\\s*\\w+\\s*\\\"");
        ANNOTATIONS.put("EmbedMany", embedManyRegexs);
        HashSet<String> embedOneRegexs = new HashSet<String>();
        embedOneRegexs.add("targetDocument");
        embedOneRegexs.add("\\\"\\s*\\w+\\s*\\\"");
        ANNOTATIONS.put("EmbedOne", embedOneRegexs);
        HashSet<String> referenceManyRegexs = new HashSet<String>();
        referenceManyRegexs.add("targetDocument");
        referenceManyRegexs.add("\\\"\\s*\\w+\\s*\\\"");
        ANNOTATIONS.put("ReferenceMany", referenceManyRegexs);
        HashSet<String> referenceOneRegexs = new HashSet<String>();
        referenceOneRegexs.add("targetDocument");
        referenceOneRegexs.add("\\\"\\s*\\w+\\s*\\\"");
        ANNOTATIONS.put("ReferenceOne", referenceOneRegexs);
    }
}

