/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.TextArea;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.TextComponentOperator;

public class TextAreaOperator
extends TextComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    private static final long PUSH_KEY_TIMEOUT = 0L;
    private static final long BETWEEN_KEYS_TIMEOUT = 0L;
    private static final long CHANGE_CARET_POSITION_TIMEOUT = 60000L;
    private static final long TYPE_TEXT_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;

    public TextAreaOperator(TextArea b) {
        super(b);
    }

    public TextAreaOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((TextArea)cont.waitSubComponent(new TextAreaFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public TextAreaOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public TextAreaOperator(ContainerOperator cont, String text, int index) {
        this((TextArea)TextAreaOperator.waitComponent(cont, (ComponentChooser)new TextAreaByTextFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public TextAreaOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public TextAreaOperator(ContainerOperator cont, int index) {
        this((TextArea)TextAreaOperator.waitComponent(cont, (ComponentChooser)new TextAreaFinder(), index));
        this.copyEnvironment(cont);
    }

    public TextAreaOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static TextArea findTextArea(Container cont, ComponentChooser chooser, int index) {
        return (TextArea)TextAreaOperator.findComponent(cont, new TextAreaFinder(chooser), index);
    }

    public static TextArea findTextArea(Container cont, ComponentChooser chooser) {
        return TextAreaOperator.findTextArea(cont, chooser, 0);
    }

    public static TextArea findTextArea(Container cont, String text, boolean ce, boolean ccs, int index) {
        return TextAreaOperator.findTextArea(cont, new TextAreaByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static TextArea findTextArea(Container cont, String text, boolean ce, boolean ccs) {
        return TextAreaOperator.findTextArea(cont, text, ce, ccs, 0);
    }

    public static TextArea waitTextArea(Container cont, ComponentChooser chooser, int index) {
        return (TextArea)TextAreaOperator.waitComponent(cont, (ComponentChooser)new TextAreaFinder(chooser), index);
    }

    public static TextArea waitTextArea(Container cont, ComponentChooser chooser) {
        return TextAreaOperator.waitTextArea(cont, chooser, 0);
    }

    public static TextArea waitTextArea(Container cont, String text, boolean ce, boolean ccs, int index) {
        return TextAreaOperator.waitTextArea(cont, new TextAreaByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static TextArea waitTextArea(Container cont, String text, boolean ce, boolean ccs) {
        return TextAreaOperator.waitTextArea(cont, text, ce, ccs, 0);
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(TEXT_DPROP, ((TextArea)this.getSource()).getText());
        return result;
    }

    public int getColumns() {
        return this.runMapping(new Operator.MapIntegerAction("getColumns"){

            @Override
            public int map() {
                return ((TextArea)TextAreaOperator.this.getSource()).getColumns();
            }
        });
    }

    public Dimension getMinimumSize(final int i, final int i1) {
        return (Dimension)this.runMapping(new Operator.MapAction("getMinimumSize"){

            @Override
            public Object map() {
                return ((TextArea)TextAreaOperator.this.getSource()).getMinimumSize(i, i1);
            }
        });
    }

    public Dimension getPreferredSize(final int i, final int i1) {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredSize"){

            @Override
            public Object map() {
                return ((TextArea)TextAreaOperator.this.getSource()).getPreferredSize(i, i1);
            }
        });
    }

    public int getRows() {
        return this.runMapping(new Operator.MapIntegerAction("getRows"){

            @Override
            public int map() {
                return ((TextArea)TextAreaOperator.this.getSource()).getRows();
            }
        });
    }

    public int getScrollbarVisibility() {
        return this.runMapping(new Operator.MapIntegerAction("getScrollbarVisibility"){

            @Override
            public int map() {
                return ((TextArea)TextAreaOperator.this.getSource()).getScrollbarVisibility();
            }
        });
    }

    public void replaceRange(final String string, final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("replaceRange"){

            @Override
            public void map() {
                ((TextArea)TextAreaOperator.this.getSource()).replaceRange(string, i, i1);
            }
        });
    }

    public void setColumns(final int i) {
        this.runMapping(new Operator.MapVoidAction("setColumns"){

            @Override
            public void map() {
                ((TextArea)TextAreaOperator.this.getSource()).setColumns(i);
            }
        });
    }

    public void setRows(final int i) {
        this.runMapping(new Operator.MapVoidAction("setRows"){

            @Override
            public void map() {
                ((TextArea)TextAreaOperator.this.getSource()).setRows(i);
            }
        });
    }

    static {
        Timeouts.initDefault("TextAreaOperator.PushKeyTimeout", 0L);
        Timeouts.initDefault("TextAreaOperator.BetweenKeysTimeout", 0L);
        Timeouts.initDefault("TextAreaOperator.ChangeCaretPositionTimeout", 60000L);
        Timeouts.initDefault("TextAreaOperator.TypeTextTimeout", 60000L);
    }

    public static class TextAreaFinder
    extends Operator.Finder {
        public TextAreaFinder(ComponentChooser sf) {
            super(TextArea.class, sf);
        }

        public TextAreaFinder() {
            super(TextArea.class);
        }
    }

    public static class TextAreaByTextFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public TextAreaByTextFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public TextAreaByTextFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof TextArea && ((TextArea)comp).getText() != null) {
                return this.comparator.equals(((TextArea)comp).getText(), this.label);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "TextArea with text \"" + this.label + "\"";
        }
    }
}

