/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;

public class ProjectClassPathProvider
implements ClassPathProvider {
    private static final Logger LOG = Logger.getLogger(ProjectClassPathProvider.class.getName());

    public ClassPath findClassPath(FileObject file, String type) {
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "findClassPath({0}, {1}) on project {2}", new Object[]{file, type, p});
        }
        if (p != null) {
            ClassPathProvider cpp = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
            if (cpp != null) {
                ClassPath result = cpp.findClassPath(file, type);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "findClassPath({0}, {1}) -> {2} from {3}", new Object[]{file, type, result, cpp});
                }
                return result;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "cpp.findClassPath({0}, {1}) -> null", new Object[]{file, type});
            }
            return null;
        }
        return null;
    }
}

