/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.php;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.project.api.PhpSeleniumProvider;
import org.netbeans.modules.selenium2.php.Bundle;
import org.netbeans.modules.selenium2.server.api.Selenium2Server;
import org.netbeans.modules.selenium2.spi.Selenium2SupportImpl;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public class Selenium2PhpSupportImpl
extends Selenium2SupportImpl {
    public boolean isSupportActive(Project p) {
        return this.getSeleniumProvider(p) != null;
    }

    public void configureProject(FileObject targetFolder) {
        Project p = FileOwnerQuery.getOwner((FileObject)targetFolder);
        if (p == null) {
            return;
        }
        this.getSeleniumDir(p, true);
    }

    public WizardDescriptor.Panel createTargetChooserPanel(WizardDescriptor wiz) {
        Project project = Templates.getProject((WizardDescriptor)wiz);
        SourceGroup seleniumSourceGroup = this.getSeleniumSourceGroup(project);
        return Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])new SourceGroup[]{seleniumSourceGroup}).create();
    }

    public String getTemplateID() {
        return "Templates/SeleniumTests/SeleneseTest.php";
    }

    public boolean isSupportEnabled(FileObject[] activatedFOs) {
        if (activatedFOs.length == 0) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]);
        if (p == null) {
            return false;
        }
        PhpSeleniumProvider seleniumProvider = this.getSeleniumProvider(p);
        if (seleniumProvider == null) {
            return false;
        }
        return seleniumProvider.isSupportEnabled(activatedFOs);
    }

    private PhpSeleniumProvider getSeleniumProvider(Project project) {
        return (PhpSeleniumProvider)project.getLookup().lookup(PhpSeleniumProvider.class);
    }

    private FileObject getSeleniumDir(Project project, boolean showCustomizer) {
        return this.getSeleniumProvider(project).getTestDirectory(showCustomizer);
    }

    private SourceGroup getSeleniumSourceGroup(Project project) {
        FileObject dir = this.getSeleniumDir(project, true);
        if (dir == null) {
            return ProjectUtils.getSources((Project)project).getSourceGroups("generic")[0];
        }
        String sourcesDisplayName = Bundle.sources_display_name();
        return GenericSources.group((Project)project, (FileObject)dir, (String)"SeleniumDir", (String)sourcesDisplayName, null, null);
    }

    public List<Object> getTestSourceRoots(Collection<SourceGroup> createdSourceRoots, FileObject refFileObject) {
        this.configureProject(refFileObject);
        Project p = FileOwnerQuery.getOwner((FileObject)refFileObject);
        if (p == null) {
            return Collections.emptyList();
        }
        PhpSeleniumProvider seleniumProvider = this.getSeleniumProvider(p);
        if (seleniumProvider == null) {
            return Collections.emptyList();
        }
        if (this.getSeleniumDir(p, false) == null) {
            return Collections.emptyList();
        }
        return seleniumProvider.getTestSourceRoots(createdSourceRoots, refFileObject);
    }

    public String[] getSourceAndTestClassNames(FileObject fo, boolean isTestNG, boolean isSelenium) {
        String[] result = new String[]{"", ""};
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p != null) {
            Collection providers = p.getLookup().lookupAll(ClassPathProvider.class);
            for (ClassPathProvider provider : providers) {
                ClassPath cp = provider.findClassPath(fo, "classpath/php-source");
                if (cp == null) continue;
                result[0] = cp.getResourceName(fo, '.', false);
                result[1] = result[0].concat("Test");
            }
        }
        return result;
    }

    public void runTests(FileObject[] activatedFOs, boolean isSelenium) {
        PhpSeleniumProvider seleniumProvider;
        Project p;
        if (isSelenium && (p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0])) != null && (seleniumProvider = this.getSeleniumProvider(p)) != null) {
            Selenium2Server.getInstance().startServer();
            seleniumProvider.runAllTests();
            Selenium2Server.getInstance().stopServer();
        }
    }
}

