/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.io.IOException;
import org.json.simple.JSONObject;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerContainerDetail;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.ui.node.AbstractContainerAction;
import org.netbeans.modules.docker.ui.node.Bundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ProcessListAction
extends AbstractContainerAction {
    private static final String PROCESSES_JSON_KEY = "Processes";
    private static final String TITLES_JSON_KEY = "Titles";

    public ProcessListAction() {
        super(Bundle.LBL_ProcessListAction());
    }

    @Override
    protected void performAction(DockerContainer container) throws DockerException {
        try {
            DockerAction facade = new DockerAction(container.getInstance());
            JSONObject processList = facade.getRunningProcessesList(container);
            InputOutput io = IOProvider.getDefault().getIO(Bundle.MSG_ProcessList(container.getShortId()), false);
            io.getOut().reset();
            io.getOut().println(processList.get((Object)TITLES_JSON_KEY).toString());
            io.getOut().println(processList.get((Object)PROCESSES_JSON_KEY).toString());
            io.getOut().close();
            io.getErr().close();
            io.select();
        }
        catch (IOException ex) {
            throw new DockerException((Throwable)ex);
        }
    }

    @Override
    protected String getProgressMessage(DockerContainer container) {
        return Bundle.MSG_ListingProcessesInContainer(container.getShortId());
    }

    @Override
    protected boolean isEnabled(DockerContainerDetail detail) {
        return detail.getStatus() == DockerContainer.Status.RUNNING;
    }
}

