/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Image;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.swing.Icon;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsElement;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class BreadCrumbsNodeImpl
implements BreadcrumbsElement {
    private static final String COLOR = "#707070";
    private final Lookup lookup;
    private final BreadCrumbsNodeImpl parent;
    private final TreePathHandle tph;
    private final Callable<? extends Image> iconProvider;
    private final String htmlDisplayName;
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String ERR_NAME = "<error>";
    private static final Pattern UNICODE_SEQUENCE = Pattern.compile("\\\\u([0-9a-zA-Z][0-9a-zA-Z][0-9a-zA-Z][0-9a-zA-Z])");
    private static final Image DEFAULT_ICON = BreadcrumbsController.NO_ICON;
    private final AtomicReference<List<BreadcrumbsElement>> children = new AtomicReference();

    public BreadCrumbsNodeImpl(BreadCrumbsNodeImpl parent, TreePathHandle tph, final Image icon, String htmlDisplayName, FileObject fileObject, int[] pos) {
        this(parent, tph, (Callable<? extends Image>)new Callable<Image>(){

            @Override
            @CheckForNull
            public Image call() throws Exception {
                return icon;
            }
        }, htmlDisplayName, fileObject, pos);
    }

    private BreadCrumbsNodeImpl(@NullAllowed BreadCrumbsNodeImpl parent, @NonNull TreePathHandle tph, @NonNull Callable<? extends Image> iconProvider, @NullAllowed String htmlDisplayName, @NonNull FileObject fileObject, @NonNull int[] pos) {
        this.lookup = Lookups.fixed((Object[])new Object[]{tph, pos, new OpenableImpl(fileObject, pos[0])});
        this.parent = parent;
        this.tph = tph;
        this.iconProvider = iconProvider;
        this.htmlDisplayName = htmlDisplayName;
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Image getIcon(int type) {
        try {
            return this.iconProvider.call();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public static BreadCrumbsNodeImpl createBreadcrumbs(BreadCrumbsNodeImpl parent, CompilationInfo info, TreePath path, boolean elseSection) {
        Trees trees = info.getTrees();
        SourcePositions sp = trees.getSourcePositions();
        int[] pos = new int[]{(int)sp.getStartPosition(path.getCompilationUnit(), path.getLeaf()), (int)sp.getEndPosition(path.getCompilationUnit(), path.getLeaf())};
        Tree leaf = path.getLeaf();
        switch (leaf.getKind()) {
            case COMPILATION_UNIT: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                return new BreadCrumbsNodeImpl(parent, tph, (Image)null, FileUtil.getFileDisplayName((FileObject)info.getFileObject()), info.getFileObject(), pos);
            }
            case MODULE: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), ((ModuleTree)leaf).getName().toString(), info.getFileObject(), pos);
            }
            case REQUIRES: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("requires ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((RequiresTree)leaf).getModuleName().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), sb.toString(), info.getFileObject(), pos);
            }
            case EXPORTS: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("exports ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((ExportsTree)leaf).getPackageName().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), sb.toString(), info.getFileObject(), pos);
            }
            case OPENS: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("opens ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((OpensTree)leaf).getPackageName().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), sb.toString(), info.getFileObject(), pos);
            }
            case PROVIDES: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("provides ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.simpleName(((ProvidesTree)leaf).getServiceName()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), sb.toString(), info.getFileObject(), pos);
            }
            case USES: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("uses ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.simpleName(((UsesTree)leaf).getServiceName()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), sb.toString(), info.getFileObject(), pos);
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), BreadCrumbsNodeImpl.className(path), info.getFileObject(), pos);
            }
            case METHOD: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                MethodTree mt = (MethodTree)leaf;
                Name name = mt.getName().contentEquals(CONSTRUCTOR_NAME) ? ((ClassTree)path.getParentPath().getLeaf()).getSimpleName() : mt.getName();
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), name.toString(), info.getFileObject(), pos);
            }
            case VARIABLE: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                return new BreadCrumbsNodeImpl(parent, tph, BreadCrumbsNodeImpl.iconProviderFor(info, path), ((VariableTree)leaf).getName().toString(), info.getFileObject(), pos);
            }
            case CASE: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                ExpressionTree expr = ((CaseTree)leaf).getExpression();
                StringBuilder sb = new StringBuilder(expr == null ? "default:" : "case ");
                if (expr != null) {
                    sb.append("<font color=").append(COLOR).append(">");
                    sb.append(BreadCrumbsNodeImpl.escape(((CaseTree)leaf).getExpression().toString()));
                    sb.append(":");
                    sb.append("</font>");
                }
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case CATCH: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("catch ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((CatchTree)leaf).getParameter().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case DO_WHILE_LOOP: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("do ... while ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((DoWhileLoopTree)leaf).getCondition().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case ENHANCED_FOR_LOOP: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("for ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append("(");
                sb.append(BreadCrumbsNodeImpl.escape(((EnhancedForLoopTree)leaf).getVariable().toString()));
                sb.append(" : ");
                sb.append(BreadCrumbsNodeImpl.escape(((EnhancedForLoopTree)leaf).getExpression().toString()));
                sb.append(")");
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case FOR_LOOP: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("for ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append("(");
                List<? extends StatementTree> initializer = ((ForLoopTree)leaf).getInitializer();
                if (!initializer.isEmpty() && initializer.get(0).getKind() == Tree.Kind.VARIABLE) {
                    sb.append(BreadCrumbsNodeImpl.escape(initializer.get(0).toString()));
                    for (Object currentVar : NbCollections.checkedListByCopy(initializer.subList(1, initializer.size()), VariableTree.class, (boolean)true)) {
                        sb.append(", ");
                        sb.append(BreadCrumbsNodeImpl.escape(currentVar.getName().toString()));
                        if (currentVar.getInitializer() == null) continue;
                        sb.append(" = ");
                        sb.append(BreadCrumbsNodeImpl.escape(currentVar.getInitializer().toString()));
                    }
                } else {
                    boolean first = true;
                    for (StatementTree statementTree : initializer) {
                        if (!first) {
                            sb.append(", ");
                        }
                        if (statementTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                            sb.append(((ExpressionStatementTree)statementTree).getExpression().toString());
                        } else {
                            sb.append(statementTree.toString());
                        }
                        first = false;
                    }
                }
                sb.append("; ");
                if (((ForLoopTree)leaf).getCondition() != null) {
                    sb.append(BreadCrumbsNodeImpl.escape(((ForLoopTree)leaf).getCondition().toString()));
                }
                sb.append("; ");
                boolean first = true;
                for (ExpressionStatementTree expressionStatementTree : ((ForLoopTree)leaf).getUpdate()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(expressionStatementTree.getExpression().toString());
                    first = false;
                }
                sb.append(")");
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case IF: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("");
                Tree last = leaf;
                while (path != null && path.getLeaf().getKind() == Tree.Kind.IF) {
                    StringBuilder stringBuilder = new StringBuilder("");
                    stringBuilder.append("if ");
                    stringBuilder.append("<font color=").append(COLOR).append(">");
                    stringBuilder.append(BreadCrumbsNodeImpl.escape(((IfTree)path.getLeaf()).getCondition().toString()));
                    stringBuilder.append("</font>");
                    if (((IfTree)path.getLeaf()).getElseStatement() == last || path.getLeaf() == leaf && elseSection) {
                        stringBuilder.append(" else");
                    }
                    stringBuilder.append(" ");
                    sb.insert(0, stringBuilder.toString());
                    last = path.getLeaf();
                    path = path.getParentPath();
                }
                sb.delete(sb.length() - 1, sb.length());
                IfTree ifTree = (IfTree)leaf;
                int elseStart = pos[1] + 1;
                if (ifTree.getElseStatement() != null) {
                    boolean success;
                    TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    elseStart = (int)sp.getStartPosition(path.getCompilationUnit(), ifTree.getElseStatement());
                    ts.move(elseStart);
                    while ((success = ts.movePrevious()) && ts.token().id() != JavaTokenId.ELSE) {
                    }
                    int n = elseStart = success ? Math.min(ts.offset(), elseStart) : elseStart;
                }
                if (elseSection) {
                    int endPos = (int)sp.getEndPosition(path.getCompilationUnit(), ifTree.getElseStatement());
                    if (ifTree.getElseStatement().getKind() == Tree.Kind.IF) {
                        endPos = (int)sp.getStartPosition(path.getCompilationUnit(), ifTree.getElseStatement()) - 1;
                    }
                    pos = new int[]{elseStart, endPos};
                } else {
                    pos[1] = elseStart - 1;
                }
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case SWITCH: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("switch ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((SwitchTree)leaf).getExpression().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case SYNCHRONIZED: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("synchronized ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((SynchronizedTree)leaf).getExpression().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case TRY: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("try");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case WHILE_LOOP: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                StringBuilder sb = new StringBuilder("while ");
                sb.append("<font color=").append(COLOR).append(">");
                sb.append(BreadCrumbsNodeImpl.escape(((WhileLoopTree)leaf).getCondition().toString()));
                sb.append("</font>");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
            case BLOCK: {
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) {
                    StringBuilder sb = new StringBuilder(((BlockTree)leaf).isStatic() ? "&lt;static init&gt;" : "&lt;init&gt;");
                    return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
                }
                if (path.getParentPath().getLeaf().getKind() != Tree.Kind.TRY || ((TryTree)path.getParentPath().getLeaf()).getFinallyBlock() != leaf) break;
                StringBuilder sb = new StringBuilder("finally");
                return new BreadCrumbsNodeImpl(parent, tph, DEFAULT_ICON, sb.toString(), info.getFileObject(), pos);
            }
        }
        return null;
    }

    static String escape(String s) {
        if (s != null) {
            Matcher matcher = UNICODE_SEQUENCE.matcher(s);
            if (matcher.find()) {
                StringBuilder result = new StringBuilder();
                int lastReplaceEnd = 0;
                do {
                    result.append(s.substring(lastReplaceEnd, matcher.start()));
                    int ch = Integer.parseInt(matcher.group(1), 16);
                    result.append((char)ch);
                    lastReplaceEnd = matcher.end();
                } while (matcher.find());
                result.append(s.substring(lastReplaceEnd));
                s = result.toString();
            }
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Callable<? extends Image> iconProviderFor(CompilationInfo info, TreePath path) {
        Element el = info.getTrees().getElement(path);
        final ElementKind kind = el == null ? null : el.getKind();
        final Set<Modifier> modifiers = el == null ? null : el.getModifiers();
        final ModuleElement.DirectiveKind directiveKind = BreadCrumbsNodeImpl.directiveKind(path.getLeaf().getKind());
        return new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                Icon icon = null;
                if (kind == null) {
                    if (directiveKind == null) {
                        return DEFAULT_ICON;
                    }
                    icon = ElementIcons.getModuleDirectiveIcon((ModuleElement.DirectiveKind)directiveKind);
                } else {
                    assert (modifiers != null);
                    icon = ElementIcons.getElementIcon((ElementKind)kind, (Collection)modifiers);
                }
                if (icon == null) {
                    return DEFAULT_ICON;
                }
                return ImageUtilities.icon2Image((Icon)icon);
            }
        };
    }

    private static ModuleElement.DirectiveKind directiveKind(Tree.Kind treeKind) {
        switch (treeKind) {
            case EXPORTS: {
                return ModuleElement.DirectiveKind.EXPORTS;
            }
            case PROVIDES: {
                return ModuleElement.DirectiveKind.PROVIDES;
            }
            case REQUIRES: {
                return ModuleElement.DirectiveKind.REQUIRES;
            }
            case USES: {
                return ModuleElement.DirectiveKind.USES;
            }
        }
        return null;
    }

    private static String className(TreePath path) {
        ClassTree ct = (ClassTree)path.getLeaf();
        if (path.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            NewClassTree nct = (NewClassTree)path.getParentPath().getLeaf();
            if (nct.getClassBody() == ct) {
                return BreadCrumbsNodeImpl.simpleName(nct.getIdentifier());
            }
        } else if (path.getParentPath().getLeaf() == path.getCompilationUnit()) {
            String pkgName;
            ExpressionTree pkg = path.getCompilationUnit().getPackageName();
            String string = pkgName = pkg != null ? pkg.toString() : null;
            if (pkgName != null && !pkgName.contentEquals(ERR_NAME)) {
                return pkgName + "." + ct.getSimpleName().toString();
            }
        }
        return ct.getSimpleName().toString();
    }

    private static String simpleName(Tree t) {
        switch (t.getKind()) {
            case PARAMETERIZED_TYPE: {
                return BreadCrumbsNodeImpl.simpleName(((ParameterizedTypeTree)t).getType());
            }
            case IDENTIFIER: {
                return ((IdentifierTree)t).getName().toString();
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)t).getIdentifier().toString();
            }
        }
        return "";
    }

    public List<BreadcrumbsElement> getChildren() {
        List<BreadcrumbsElement> cached = this.children.get();
        if (cached != null) {
            return cached;
        }
        final ArrayList<BreadcrumbsElement> result = new ArrayList<BreadcrumbsElement>();
        try {
            FileObject file = this.tph.getFileObject();
            if (file == null) {
                return result;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                return result;
            }
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(final CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath tp = BreadCrumbsNodeImpl.this.tph.resolve((CompilationInfo)cc);
                    if (tp == null) {
                        return;
                    }
                    tp.getLeaf().accept(new ErrorAwareTreeScanner<Void, TreePath>(){

                        public Void scan(Tree node, TreePath p) {
                            if (node == null) {
                                return null;
                            }
                            if (node.getKind() == Tree.Kind.IF) {
                                IfTree it = (IfTree)node;
                                BreadCrumbsNodeImpl n = BreadCrumbsNodeImpl.createBreadcrumbs(BreadCrumbsNodeImpl.this, (CompilationInfo)cc, new TreePath(p, node), false);
                                assert (n != null);
                                result.add(n);
                                if (it.getElseStatement() != null) {
                                    n = BreadCrumbsNodeImpl.createBreadcrumbs(BreadCrumbsNodeImpl.this, (CompilationInfo)cc, new TreePath(p, node), true);
                                    assert (n != null);
                                    result.add(n);
                                    if (it.getElseStatement().getKind() == Tree.Kind.IF) {
                                        this.scan((Tree)((IfTree)it.getElseStatement()), new TreePath(p, node));
                                    }
                                }
                                return null;
                            }
                            p = new TreePath(p, node);
                            if (cc.getTreeUtilities().isSynthetic(p)) {
                                return null;
                            }
                            BreadCrumbsNodeImpl n = BreadCrumbsNodeImpl.createBreadcrumbs(BreadCrumbsNodeImpl.this, (CompilationInfo)cc, p, false);
                            if (n == null) {
                                return (Void)super.scan(node, (Object)p);
                            }
                            result.add(n);
                            return null;
                        }

                        public Void visitMethod(MethodTree node, TreePath p) {
                            return this.scan((Tree)node.getBody(), p);
                        }
                    }, tp);
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.children.compareAndSet(null, result) ? result : this.children.get();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public BreadcrumbsElement getParent() {
        return this.parent;
    }

    private static final class OpenableImpl
    implements Openable,
    OpenCookie {
        private final FileObject file;
        private final int pos;

        public OpenableImpl(FileObject file, int pos) {
            this.file = file;
            this.pos = pos;
        }

        public void open() {
            UiUtils.open((FileObject)this.file, (int)this.pos);
        }
    }
}

