/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.SVGRenderingHints;
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.netbeans.modules.svg.BackgroundMode;
import org.netbeans.modules.svg.SVGViewerElement;
import org.netbeans.modules.svg.Utils;
import org.openide.util.NbBundle;

public class SVGPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SVGViewerElement.class.getName());
    private SVGDocument svgDocument;
    private double scale = 1.0;
    private BackgroundMode bgMode = BackgroundMode.DEFAULT;

    public void setSVGDocument(SVGDocument doc) {
        this.svgDocument = doc;
        this.repaint();
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.repaint();
    }

    public void setBackgroundMode(BackgroundMode mode) {
        this.bgMode = mode;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle visibleRect = this.getVisibleRectangle();
        switch (this.bgMode) {
            case BLACK: {
                g.setColor(Color.BLACK);
                g.fillRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
                break;
            }
            case WHITE: {
                g.setColor(Color.WHITE);
                g.fillRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
                break;
            }
            case TRANSPARENT: 
            case DARK_TRANSPARENT: {
                Utils.drawChestTilePattern(g, visibleRect, 20, this.bgMode == BackgroundMode.DARK_TRANSPARENT);
                break;
            }
            case DEFAULT: {
                g.setColor(this.getBackground());
                g.fillRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
            }
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(SVGRenderingHints.KEY_MASK_CLIP_RENDERING, SVGRenderingHints.VALUE_MASK_CLIP_RENDERING_ACCURACY);
        g2d.scale(this.scale, this.scale);
        try {
            this.svgDocument.render((JComponent)this, g2d);
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, ex.getMessage());
            this.drawErrorMessage(g);
        }
        finally {
            g2d.dispose();
        }
    }

    private Rectangle getVisibleRectangle() {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            return viewport.getViewRect();
        }
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }

    private JViewport getViewport() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JViewport)) continue;
            return (JViewport)parent;
        }
        return null;
    }

    private void drawErrorMessage(Graphics g) {
        g.setColor(Color.RED);
        FontMetrics fm = this.getFontMetrics(g.getFont());
        String errMessage = NbBundle.getMessage(SVGPanel.class, (String)"ERR_SVGDocument");
        int stringWidth = fm.stringWidth(errMessage);
        g.drawString(errMessage, (this.getWidth() - stringWidth) / 2, this.getHeight() / 2);
    }
}

