/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.project.ui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.cpplite.project.BuildConfiguration;
import org.netbeans.modules.cpplite.project.CPPLiteProject;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Build
extends JPanel {
    private JTextArea build;
    private JTextArea clean;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextField name;
    private JTextArea run;

    public Build() {
        this.initComponents();
    }

    private String toString(BuildConfiguration config, String action) {
        List<List<String>> executables = config.executablesFor(action);
        if (executables == null) {
            return "";
        }
        return executables.stream().map(commands -> commands.stream().collect(Collectors.joining(" "))).collect(Collectors.joining("\n"));
    }

    public void load(BuildConfiguration config) {
        this.name.setText(config.getName());
        this.build.setText(this.toString(config, "build"));
        this.clean.setText(this.toString(config, "clean"));
        this.run.setText(this.toString(config, "run"));
    }

    public BuildConfiguration save() {
        HashMap<String, List<List<String>>> commands = new HashMap<String, List<List<String>>>();
        commands.put("build", this.fromString(this.build.getText()));
        commands.put("clean", this.fromString(this.clean.getText()));
        commands.put("run", this.fromString(this.run.getText()));
        return new BuildConfiguration(this.name.getText(), commands);
    }

    private List<List<String>> fromString(String text) {
        return Arrays.stream(text.split("\n")).filter(l -> !l.isEmpty()).map(l -> Arrays.stream(l.split(" ")).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.name = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.build = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.clean = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.run = new JTextArea();
        this.jLabel4 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Build.class, (String)"Build.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(Build.class, (String)"Build.jLabel2.text"));
        this.name.setText(NbBundle.getMessage(Build.class, (String)"Build.name.text"));
        this.build.setColumns(20);
        this.build.setRows(3);
        this.jScrollPane1.setViewportView(this.build);
        this.clean.setColumns(20);
        this.clean.setRows(3);
        this.jScrollPane2.setViewportView(this.clean);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(Build.class, (String)"Build.jLabel3.text"));
        this.run.setColumns(20);
        this.run.setRows(3);
        this.jScrollPane3.setViewportView(this.run);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(Build.class, (String)"Build.jLabel4.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 242, Short.MAX_VALUE).addComponent(this.jScrollPane2).addComponent(this.name).addComponent(this.jScrollPane1))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.name, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, -1, -2).addComponent(this.jLabel4))));
    }

    public static ProjectCustomizer.CompositeCategoryProvider createCategoryProvider() {
        return new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup context) {
                return ProjectCustomizer.Category.create((String)"build", (String)"Build", null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                CPPLiteProject prj = (CPPLiteProject)context.lookup(CPPLiteProject.class);
                Build panel = new Build();
                panel.load(prj.getActiveBuildConfiguration());
                category.setOkButtonListener(evt -> prj.setActiveBuildConfiguration(panel.save()));
                category.setStoreListener(evt -> prj.getActiveBuildConfiguration().save(CPPLiteProject.getBuildPreferences(prj.getProjectDirectory())));
                return panel;
            }
        };
    }
}

