/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;

public class WadlSaasResource
implements Comparable<WadlSaasResource> {
    private final WadlSaas saas;
    private final WadlSaasResource parent;
    private final Resource resource;
    private List<WadlSaasMethod> methods;
    private List<WadlSaasResource> childResources;

    public WadlSaasResource(WadlSaas saas, WadlSaasResource parent, Resource resource) {
        this.saas = saas;
        this.parent = parent;
        this.resource = resource;
    }

    public WadlSaasResource getParent() {
        return this.parent;
    }

    public Resource getResource() {
        return this.resource;
    }

    public WadlSaas getSaas() {
        return this.saas;
    }

    private void initChildren() {
        this.methods = new ArrayList<WadlSaasMethod>();
        this.childResources = new ArrayList<WadlSaasResource>();
        for (Object o : this.resource.getMethodOrResource()) {
            if (o instanceof Method) {
                Method m = (Method)o;
                this.methods.add(new WadlSaasMethod(this, m));
                continue;
            }
            if (!(o instanceof Resource)) continue;
            Resource r = (Resource)o;
            this.childResources.add(new WadlSaasResource(this.saas, this, r));
        }
    }

    public List<WadlSaasMethod> getMethods() {
        if (this.methods == null) {
            this.initChildren();
        }
        return new ArrayList<WadlSaasMethod>(this.methods);
    }

    public List<WadlSaasResource> getChildResources() {
        if (this.childResources == null) {
            this.initChildren();
        }
        return new ArrayList<WadlSaasResource>(this.childResources);
    }

    public String toString() {
        return this.resource.getPath();
    }

    @Override
    public int compareTo(WadlSaasResource saasResource) {
        String thisPath = this.resource.getPath();
        String thatPath = saasResource.getResource().getPath();
        if (thisPath == null) {
            return thatPath == null ? 0 : -1;
        }
        return thatPath == null ? 1 : thisPath.compareTo(thatPath);
    }
}

