/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.autoupdate;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.netbeans.modules.bugtracking.commons.AutoupdateSupport;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.util.NbBundle;

public class BugzillaAutoupdate {
    public static final BugzillaVersion SUPPORTED_BUGZILLA_VERSION;
    static final String BUGZILLA_MODULE_CODE_NAME = "org.netbeans.modules.bugzilla";
    private static final Pattern VERSION_PATTERN;
    private static BugzillaAutoupdate instance;
    private final Set<BugzillaRepository> repos = Collections.newSetFromMap(new WeakHashMap());
    private final AutoupdateSupport support = new AutoupdateSupport((AutoupdateSupport.Callback)new AutoupdateCallback(), "org.netbeans.modules.bugzilla", NbBundle.getMessage(Bugzilla.class, (String)"LBL_ConnectorName"));

    private BugzillaAutoupdate() {
    }

    public static BugzillaAutoupdate getInstance() {
        if (instance == null) {
            instance = new BugzillaAutoupdate();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndNotify(BugzillaRepository repository) {
        Set<BugzillaRepository> set = this.repos;
        synchronized (set) {
            this.repos.add(repository);
        }
        this.support.checkAndNotify(repository.getUrl());
    }

    public boolean isSupportedVersion(BugzillaVersion version) {
        return version.compareTo(SUPPORTED_BUGZILLA_VERSION) <= 0;
    }

    public BugzillaVersion getVersion(String desc) {
        String[] lines;
        for (String l : lines = desc.split("\n")) {
            Matcher m = VERSION_PATTERN.matcher(l);
            if (!m.matches()) continue;
            return new BugzillaVersion(m.group(1));
        }
        return null;
    }

    public BugzillaVersion getServerVersion(BugzillaRepository repository) {
        BugzillaConfiguration conf = repository.getConfiguration();
        if (!conf.isValid()) {
            return null;
        }
        BugzillaVersion version = conf.getInstalledVersion();
        return version;
    }

    public AutoupdateSupport getAutoupdateSupport() {
        return this.support;
    }

    static {
        String version = System.getProperty("netbeans.t9y.bugzilla.supported.version");
        SUPPORTED_BUGZILLA_VERSION = version != null ? new BugzillaVersion(version) : BugzillaVersion.BUGZILLA_4_0;
        VERSION_PATTERN = Pattern.compile("^.*version ((\\d+?\\.\\d+?\\.\\d+?)|(\\d+?\\.\\d+?)).*$");
    }

    class AutoupdateCallback
    implements AutoupdateSupport.Callback {
        AutoupdateCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getServerVersion(String url) {
            BugzillaRepository repository = null;
            Set set = BugzillaAutoupdate.this.repos;
            synchronized (set) {
                for (BugzillaRepository r : BugzillaAutoupdate.this.repos) {
                    if (!r.getUrl().equals(url)) continue;
                    repository = r;
                }
            }
            assert (repository != null) : "no repository found for url " + url;
            if (repository == null) {
                return null;
            }
            BugzillaVersion version = BugzillaAutoupdate.this.getServerVersion(repository);
            return version != null ? version.toString() : null;
        }

        public boolean checkIfShouldDownload(String desc) {
            BugzillaVersion version = BugzillaAutoupdate.this.getVersion(desc);
            return version != null && SUPPORTED_BUGZILLA_VERSION.compareTo(version) < 0;
        }

        public boolean isSupportedVersion(String version) {
            return BugzillaAutoupdate.this.isSupportedVersion(new BugzillaVersion(version));
        }
    }
}

