/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.DDTable;
import org.netbeans.modules.web.wizards.Editable;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.TableRowDialog;
import org.netbeans.modules.web.wizards.Utilities;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

class InitParamPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String ADD = "add";
    private static final String EDIT = "edit";
    private static final String REMOVE = "remove";
    private ServletData deployData;
    private BaseWizardPanel parent;
    private JLabel jLinitparams;
    private DDTable table;
    private JButton jBnew;
    private JButton jBedit;
    private JButton jBdelete;
    private JScrollPane scrollP;
    private TemplateWizard wizard;
    private static final long serialVersionUID = -5803905591685582710L;

    public InitParamPanel(ServletData deployData, BaseWizardPanel parent, TemplateWizard wizard) {
        this.deployData = deployData;
        this.parent = parent;
        this.wizard = wizard;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints fullRowC = new GridBagConstraints();
        fullRowC.gridx = 0;
        fullRowC.gridy = 0;
        fullRowC.gridwidth = 2;
        fullRowC.anchor = 17;
        fullRowC.fill = 2;
        fullRowC.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints bC = new GridBagConstraints();
        bC.gridx = 1;
        bC.gridy = 1;
        bC.weightx = 0.1;
        bC.fill = 2;
        bC.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints tableC = new GridBagConstraints();
        tableC.gridx = 0;
        tableC.gridy = 1;
        tableC.gridheight = 4;
        tableC.fill = 1;
        tableC.weightx = 0.9;
        tableC.weighty = 1.0;
        tableC.anchor = 17;
        tableC.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints fillerC = new GridBagConstraints();
        fillerC.gridx = 1;
        fillerC.gridy = -1;
        fillerC.fill = 1;
        fillerC.weighty = 1.0;
        fillerC.insets = new Insets(4, 0, 4, 0);
        this.jLinitparams = new JLabel(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_initparamsL"));
        this.jLinitparams.setDisplayedMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_initparams_mnemonic").charAt(0));
        this.add((Component)this.jLinitparams, fullRowC);
        String[] headers = new String[]{"paramname", "paramvalue"};
        this.table = new DDTable(headers, "LBL_initparams", Editable.BOTH);
        this.jLinitparams.setLabelFor(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparams_desc"));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparams"));
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                InitParamPanel.this.updateInitParams();
            }
        });
        this.scrollP = new JScrollPane(this.table);
        this.add((Component)this.scrollP, tableC);
        this.jBnew = new JButton();
        this.jBnew.setText(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_new"));
        this.jBnew.setMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_new_mnemonic").charAt(0));
        this.jBnew.addActionListener(this);
        this.jBnew.setActionCommand(ADD);
        this.jBnew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparam_new"));
        this.add((Component)this.jBnew, bC);
        ++bC.gridy;
        this.jBedit = new JButton();
        this.jBedit.setText(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_edit"));
        this.jBedit.setMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_edit_mnemonic").charAt(0));
        this.jBedit.addActionListener(this);
        this.jBedit.setActionCommand(EDIT);
        this.jBedit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparam_edit"));
        this.jBedit.setEnabled(false);
        this.add((Component)this.jBedit, bC);
        ++bC.gridy;
        this.jBdelete = new JButton();
        this.jBdelete.setText(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_delete"));
        this.jBdelete.setMnemonic(NbBundle.getMessage(InitParamPanel.class, (String)"LBL_delete_mnemonic").charAt(0));
        this.jBdelete.addActionListener(this);
        this.jBdelete.setActionCommand(REMOVE);
        this.jBdelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InitParamPanel.class, (String)"ACSD_initparam_delete"));
        this.jBdelete.setEnabled(false);
        this.add((Component)this.jBdelete, bC);
        this.add((Component)new JPanel(), fillerC);
    }

    public void setEnabled() {
        boolean enable = this.deployData.makeEntry() || Utilities.isJavaEE6Plus(this.wizard);
        this.jLinitparams.setEnabled(enable);
        this.jBnew.setEnabled(enable);
        if (enable) {
            ListSelectionModel lsm = this.table.getSelectionModel();
            if (lsm.isSelectionEmpty()) {
                this.jBdelete.setEnabled(false);
                this.jBedit.setEnabled(false);
            } else {
                this.jBdelete.setEnabled(true);
                this.jBedit.setEnabled(true);
            }
        } else {
            this.jBdelete.setEnabled(false);
            this.jBedit.setEnabled(false);
        }
        this.table.setEditable(enable ? Editable.BOTH : Editable.NEITHER);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int row = -1;
        if (evt.getSource() instanceof JButton) {
            if (evt.getActionCommand() == ADD) {
                String[] values = new String[]{NbBundle.getMessage(InitParamPanel.class, (String)"LBL_paramname"), NbBundle.getMessage(InitParamPanel.class, (String)"LBL_paramvalue")};
                row = this.table.addRow(values);
                this.table.setRowSelectionInterval(row, row);
            } else if (evt.getActionCommand() == REMOVE) {
                row = this.table.getSelectedRow();
                this.table.removeRow(row);
                this.setEnabled();
            } else if (evt.getActionCommand() == EDIT) {
                row = this.table.getSelectedRow();
                String name = (String)this.table.getValueAt(row, 0);
                String value = (String)this.table.getValueAt(row, 1);
                String title = NbBundle.getMessage(DDTable.class, (String)"LBL_initparams_edit");
                TableRowDialog d = new TableRowDialog(name, value, Editable.BOTH, TableRowDialog.Condition.NONE, title);
                d.showDialog();
                if (d.getDialogOK()) {
                    this.table.setData(d.getName(), d.getValue(), row);
                } else {
                    this.table.setData(name, value, row);
                }
            }
            this.scrollP.revalidate();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setEnabled();
        this.updateInitParams();
    }

    private void updateInitParams() {
        if (this.deployData.makeEntry() || Utilities.isJavaEE6Plus(this.wizard)) {
            int numInitParams = this.table.getRowCount();
            String[][] param = new String[numInitParams][2];
            boolean isOK = true;
            for (int i = 0; i < numInitParams; ++i) {
                param[i][0] = (String)this.table.getModel().getValueAt(i, 0);
                if (param[i][0].length() == 0) {
                    isOK = false;
                }
                param[i][1] = (String)this.table.getModel().getValueAt(i, 1);
            }
            String duplicitParam = null;
            int maxi = param.length;
            block1: for (int i = 0; i < maxi; ++i) {
                String param1name = param[i][0];
                for (int j = i + 1; j < maxi; ++j) {
                    if (!param1name.equals(param[j][0])) continue;
                    duplicitParam = param1name;
                    continue block1;
                }
            }
            this.deployData.setInitParams(param, isOK, duplicitParam);
            this.parent.fireChangeEvent();
        }
    }
}

