/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import org.netbeans.modules.maven.indexer.Bundle;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.spi.impl.IndexingNotificationProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;

public class IndexingNotificationProviderImpl
implements IndexingNotificationProvider {
    private static final Map<String, Notification> indexDownloadNotifications = Collections.synchronizedMap(new HashMap());

    public void notifyError(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    private static JTextPane createIndexDownloadPermissionPane(RepositoryInfo repo) {
        JTextPane pane = new JTextPane();
        pane.setContentType("text/html");
        pane.setText(Bundle.NOTIF_RequestPermissionBody(repo.getRepositoryUrl()));
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setFocusable(false);
        pane.addHyperlinkListener(e -> {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                if ("allow".equals(e.getDescription())) {
                    RepositoryPreferences.allowIndexDownloadFor((RepositoryInfo)repo);
                    Notification notification = indexDownloadNotifications.remove(repo.getRepositoryUrl());
                    if (notification != null) {
                        notification.clear();
                    }
                    RepositoryQueries.getVersionsResult((String)"group", (String)"artifact", List.of(repo));
                } else if ("deny".equals(e.getDescription())) {
                    RepositoryPreferences.denyIndexDownloadFor((RepositoryInfo)repo);
                    Notification notification = indexDownloadNotifications.remove(repo.getRepositoryUrl());
                    if (notification != null) {
                        notification.clear();
                    }
                } else if ("disable".equals(e.getDescription())) {
                    RepositoryPreferences.setIndexDownloadEnabled((boolean)false);
                    Map<String, Notification> map = indexDownloadNotifications;
                    synchronized (map) {
                        for (Notification not : indexDownloadNotifications.values()) {
                            not.clear();
                        }
                        indexDownloadNotifications.clear();
                    }
                }
            }
        });
        return pane;
    }

    public void requestPermissionsFor(RepositoryInfo repo) {
        if (!indexDownloadNotifications.containsKey(repo.getRepositoryUrl())) {
            Notification notification = NotificationDisplayer.getDefault().notify(Bundle.NOTIF_RequestPermissionTitle(repo.getName()), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/indexer/fetch.png", (boolean)false), (JComponent)IndexingNotificationProviderImpl.createIndexDownloadPermissionPane(repo), (JComponent)IndexingNotificationProviderImpl.createIndexDownloadPermissionPane(repo), NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.INFO);
            indexDownloadNotifications.put(repo.getRepositoryUrl(), notification);
        }
    }
}

