/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DriverNode
extends BaseNode {
    private static final String PREFERREDICONBASE = "org/netbeans/modules/db/resources/driverPrefered.gif";
    private static final String FOLDER = "Driver";
    private DatabaseDriver databaseDriver;

    public static DriverNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        DriverNode node = new DriverNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private DriverNode(NodeDataLookup lookup, NodeProvider provider) {
        super(lookup, FOLDER, provider);
    }

    @Override
    protected void initialize() {
        StringBuffer sb = new StringBuffer();
        JDBCDriver driver = (JDBCDriver)this.getLookup().lookup(JDBCDriver.class);
        for (int j = 0; j < driver.getURLs().length; ++j) {
            if (j != 0) {
                sb.append(", ");
            }
            String file = driver.getURLs()[j].getFile();
            if (Utilities.isWindows()) {
                file = file.substring(1);
            }
            sb.append(file);
        }
        this.databaseDriver = new DatabaseDriver(driver.getDisplayName(), driver.getClassName(), sb.toString(), driver);
    }

    public DatabaseDriver getDatabaseDriver() {
        return this.databaseDriver;
    }

    @Override
    public boolean canDestroy() {
        return true;
    }

    @Override
    public void destroy() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    JDBCDriver driver = DriverNode.this.databaseDriver.getJDBCDriver();
                    if (driver != null) {
                        JDBCDriverManager.getDefault().removeDriver(driver);
                    }
                }
                catch (DatabaseException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    @Override
    public String getName() {
        return this.databaseDriver.getName();
    }

    public String getDisplayName() {
        return this.databaseDriver.getName();
    }

    @Override
    public String getIconBase() {
        return PREFERREDICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(DriverNode.class, (String)"ND_Driver");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DriverNode.class);
    }
}

