/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.SessionStorage;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

final class ProfilerFeatures {
    private static final String FLAG_SINGLE_FEATURE = "SINGLE_FEATURE";
    private static final String FLAG_ACTIVATED_FEATURES = "ACTIVATED_FEATURES";
    private static final String FLAG_PROFILING_POINTS = "PROFILING_POINTS";
    private static final Boolean SINGLE_FEATURE_DEFAULT = Boolean.TRUE;
    private static final Boolean PROFILING_POINTS_DEFAULT = Boolean.TRUE;
    private static final Comparator<ProfilerFeature> FEATURES_COMPARATOR = new Comparator<ProfilerFeature>(){

        @Override
        public int compare(ProfilerFeature f1, ProfilerFeature f2) {
            return Integer.compare(f1.getPosition(), f2.getPosition());
        }
    };
    private final ProfilerSession session;
    private final Set<ProfilerFeature> features;
    private final Set<ProfilerFeature> activated;
    private final Set<Listener> listeners;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            ProfilerFeatures.this.fireSettingsChanged();
        }
    };
    private boolean singleFeatured;
    private boolean ppoints;
    private volatile boolean loading;

    ProfilerFeatures(ProfilerSession session) {
        this.session = session;
        SessionStorage storage = session.getStorage();
        this.singleFeatured = Boolean.parseBoolean(storage.readFlag(FLAG_SINGLE_FEATURE, SINGLE_FEATURE_DEFAULT.toString()));
        this.ppoints = Boolean.parseBoolean(storage.readFlag(FLAG_PROFILING_POINTS, PROFILING_POINTS_DEFAULT.toString()));
        this.features = new TreeSet<ProfilerFeature>(FEATURES_COMPARATOR);
        this.activated = new TreeSet<ProfilerFeature>(FEATURES_COMPARATOR);
        this.listeners = new HashSet<Listener>();
        for (ProfilerFeature.Provider provider : ProfilerFeature.Registry.getProviders()) {
            ProfilerFeature feature = provider.getFeature(session);
            if (feature == null) continue;
            this.features.add(feature);
        }
        this.loadActivatedFeatures();
    }

    Set<ProfilerFeature> getAvailable() {
        return this.features;
    }

    Set<ProfilerFeature> getActivated() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.activated;
    }

    static Set<ProfilerFeature> getCompatible(Set<ProfilerFeature> f, Lookup c) {
        TreeSet<ProfilerFeature> s = new TreeSet<ProfilerFeature>(FEATURES_COMPARATOR);
        for (ProfilerFeature p : f) {
            if (!p.supportsConfiguration(c)) continue;
            s.add(p);
        }
        return s;
    }

    void activateFeature(ProfilerFeature feature) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.singleFeatured) {
            if (this.activated.size() == 1 && this.activated.contains(feature)) {
                return;
            }
            for (ProfilerFeature f : this.activated) {
                f.deactivatedInSession();
                f.removeChangeListener(this.listener);
            }
            this.activated.clear();
            this.activated.add(feature);
            feature.addChangeListener(this.listener);
            feature.activatedInSession();
            this.fireFeaturesChanged(feature);
            this.saveActivatedFeatures();
        } else if (this.activated.add(feature)) {
            ProfilingSettings ps = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
            feature.configureSettings(ps);
            Iterator<ProfilerFeature> it = this.activated.iterator();
            while (it.hasNext()) {
                ProfilerFeature f = it.next();
                if (f == feature || f.supportsSettings(ps)) continue;
                it.remove();
                f.deactivatedInSession();
                f.removeChangeListener(this.listener);
            }
            feature.addChangeListener(this.listener);
            feature.activatedInSession();
            this.fireFeaturesChanged(feature);
            this.saveActivatedFeatures();
        }
    }

    void deactivateFeature(ProfilerFeature feature) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.activated.size() == 1 && this.activated.contains(feature) && this.session.inProgress()) {
            return;
        }
        if (this.activated.remove(feature)) {
            feature.deactivatedInSession();
            feature.removeChangeListener(this.listener);
            this.fireFeaturesChanged(feature);
            this.saveActivatedFeatures();
        }
    }

    void toggleActivated(ProfilerFeature feature) {
        if (this.activated.contains(feature)) {
            this.deactivateFeature(feature);
        } else {
            this.activateFeature(feature);
        }
    }

    private void loadActivatedFeatures() {
        this.loading = true;
        final String _activated = this.session.getStorage().readFlag(FLAG_ACTIVATED_FEATURES, "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ProfilerFeature feature : ProfilerFeatures.this.features) {
                    if (!_activated.contains(ProfilerFeatures.getFeatureID(feature))) continue;
                    ProfilerFeatures.this.activateFeature(feature);
                }
                ProfilerFeatures.this.loading = false;
            }
        });
    }

    private void saveActivatedFeatures() {
        if (this.loading) {
            return;
        }
        final HashSet<ProfilerFeature> _activated = new HashSet<ProfilerFeature>(this.activated);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SessionStorage storage = ProfilerFeatures.this.session.getStorage();
                if (_activated.isEmpty()) {
                    storage.storeFlag(ProfilerFeatures.FLAG_ACTIVATED_FEATURES, null);
                } else {
                    StringBuilder b = new StringBuilder();
                    for (ProfilerFeature feature : _activated) {
                        b.append(ProfilerFeatures.getFeatureID(feature));
                    }
                    storage.storeFlag(ProfilerFeatures.FLAG_ACTIVATED_FEATURES, b.toString());
                }
            }
        });
    }

    private static String getFeatureID(ProfilerFeature feature) {
        return "#" + feature.getClass().getName() + "@";
    }

    void setSingleFeatured(boolean single) {
        assert (SwingUtilities.isEventDispatchThread());
        this.singleFeatured = single;
        if (this.singleFeatured && !this.activated.isEmpty()) {
            this.activateFeature(this.activated.iterator().next());
        }
        this.session.getStorage().storeFlag(FLAG_SINGLE_FEATURE, SINGLE_FEATURE_DEFAULT.equals(single) ? null : Boolean.toString(this.singleFeatured));
    }

    boolean isSingleFeatured() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.singleFeatured;
    }

    void setUseProfilingPoints(boolean use) {
        assert (SwingUtilities.isEventDispatchThread());
        this.ppoints = use;
        this.session.getStorage().storeFlag(FLAG_PROFILING_POINTS, PROFILING_POINTS_DEFAULT.equals(use) ? null : Boolean.toString(use));
    }

    boolean getUseProfilingPoints() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.ppoints;
    }

    boolean settingsValid() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.activated.isEmpty()) {
            return false;
        }
        for (ProfilerFeature f : this.activated) {
            if (f.currentSettingsValid()) continue;
            return false;
        }
        return true;
    }

    ProfilingSettings getSettings() {
        assert (SwingUtilities.isEventDispatchThread());
        this.session.persistStorage(false);
        if (this.activated.isEmpty()) {
            return null;
        }
        ProfilingSettings settings = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
        for (ProfilerFeature f : this.activated) {
            f.configureSettings(settings);
        }
        settings.setUseProfilingPoints(this.ppoints);
        return settings;
    }

    void sessionFinished() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ProfilerFeature activated : ProfilerFeatures.this.getActivated()) {
                    activated.deactivatedInSession();
                }
            }
        });
    }

    void addListener(Listener listener) {
        assert (SwingUtilities.isEventDispatchThread());
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        assert (SwingUtilities.isEventDispatchThread());
        this.listeners.remove(listener);
    }

    private void fireFeaturesChanged(ProfilerFeature changed) {
        boolean valid = this.settingsValid();
        for (Listener l : this.listeners) {
            l.featuresChanged(changed);
            l.settingsChanged(valid);
        }
    }

    private void fireSettingsChanged() {
        boolean valid = this.settingsValid();
        for (Listener l : this.listeners) {
            l.settingsChanged(valid);
        }
    }

    static abstract class Listener {
        Listener() {
        }

        abstract void featuresChanged(ProfilerFeature var1);

        abstract void settingsChanged(boolean var1);
    }
}

