/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.logicalview.Bundle;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.StatusDecorator;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public final class FrameworkConfigFilesNodeFactory
implements NodeFactory {
    static final Logger LOGGER = Logger.getLogger(FrameworkConfigFilesNodeFactory.class.getName());

    public NodeList<?> createNodes(Project p) {
        PhpProject project = (PhpProject)p.getLookup().lookup(PhpProject.class);
        return new ConfigFilesNodeList(project);
    }

    private static final class ConfigFilesNodeList
    implements NodeList<Node>,
    PropertyChangeListener,
    ChangeListener {
        private final PhpProject project;
        private final List<ImportantFilesImplementation> configFiles = new CopyOnWriteArrayList<ImportantFilesImplementation>();
        private final ConfigFilesChildren configFilesChildren;
        final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node configFilesNode;

        ConfigFilesNodeList(PhpProject project) {
            assert (project != null);
            this.project = project;
            this.configFilesChildren = new ConfigFilesChildren(project, this.configFiles);
        }

        public List<Node> keys() {
            if (!this.configFilesChildren.hasConfigFiles()) {
                return Collections.emptyList();
            }
            if (this.configFilesNode == null) {
                this.configFilesNode = new ConfigFilesNode((Children)this.configFilesChildren);
            }
            return Collections.singletonList(this.configFilesNode);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public Node node(Node key) {
            return key;
        }

        public void addNotify() {
            ProjectPropertiesSupport.addWeakProjectPropertyChangeListener(this.project, this);
            this.listenOnFrameworks();
        }

        public void removeNotify() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.configFilesChildren.refreshConfigFiles();
            this.fireChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("frameworks".equals(evt.getPropertyName())) {
                this.listenOnFrameworks();
                this.fireChange();
            }
        }

        private void fireChange() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    changeSupport.fireChange();
                }
            });
        }

        private void listenOnFrameworks() {
            List<PhpFrameworkProvider> frameworks = this.project.getFrameworks();
            ArrayList<ImportantFilesImplementation> newConfigFiles = new ArrayList<ImportantFilesImplementation>(frameworks.size());
            PhpModule phpModule = this.project.getPhpModule();
            for (PhpFrameworkProvider framework : frameworks) {
                ImportantFilesImplementation configurationFiles = framework.getConfigurationFiles2(phpModule);
                if (configurationFiles != null) {
                    newConfigFiles.add(configurationFiles);
                    configurationFiles.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)configurationFiles));
                    continue;
                }
                File[] files = framework.getConfigurationFiles(phpModule);
                if (files.length <= 0) continue;
                LOGGER.log(Level.INFO, "PHP framework {0} uses deprecated method, switch to PhpFrameworkProvider.getConfigurationFiles2()", framework.getIdentifier());
                ImportantFilesImplementationImpl dummyConfigFiles = new ImportantFilesImplementationImpl(this.project, framework.getIdentifier(), files);
                newConfigFiles.add(dummyConfigFiles);
            }
            this.configFiles.clear();
            this.configFiles.addAll(newConfigFiles);
        }
    }

    private static final class ImportantFilesImplementationImpl
    implements ImportantFilesImplementation {
        private final PhpVisibilityQuery phpVisibilityQuery;
        private final String frameworkIdent;
        private final List<File> files = new CopyOnWriteArrayList<File>();

        public ImportantFilesImplementationImpl(PhpProject project, String frameworkIdent, File[] files) {
            assert (project != null);
            assert (frameworkIdent != null);
            assert (files != null);
            assert (files.length > 0);
            this.phpVisibilityQuery = PhpVisibilityQuery.forProject(project);
            this.frameworkIdent = frameworkIdent;
            this.files.addAll(Arrays.asList(files));
        }

        public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
            ArrayList<ImportantFilesImplementation.FileInfo> result = new ArrayList<ImportantFilesImplementation.FileInfo>(this.files.size());
            for (File file : this.files) {
                FileObject fo = FileUtil.toFileObject((File)file);
                if (fo == null) continue;
                if (fo.isFolder()) {
                    IllegalStateException ex = new IllegalStateException("No folders allowed among configuration files [" + fo.getNameExt() + " for " + this.frameworkIdent + "]");
                    LOGGER.log(Level.INFO, ex.getMessage(), ex);
                    continue;
                }
                if (this.phpVisibilityQuery.isVisible(fo)) {
                    result.add(new ImportantFilesImplementation.FileInfo(fo));
                    continue;
                }
                LOGGER.log(Level.INFO, "File {0} ignored (not visible)", fo.getPath());
            }
            return result;
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }

    @SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="No need to override these methods")
    private static final class ImportantFileNode
    extends FilterNode {
        private final PhpProject project;
        private final ImportantFilesImplementation.FileInfo fileInfo;

        ImportantFileNode(PhpProject project, ImportantFilesImplementation.FileInfo fileInfo) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)fileInfo.getFile()).getNodeDelegate());
            assert (project != null);
            this.project = project;
            this.fileInfo = fileInfo;
        }

        public String getDisplayName() {
            String displayName = this.fileInfo.getDisplayName();
            if (displayName != null) {
                return displayName;
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            String displayName = this.getDisplayName();
            assert (displayName != null) : this.fileInfo;
            StatusDecorator statusDecorator = this.getStatusDecorator();
            if (statusDecorator != null) {
                return statusDecorator.annotateNameHtml(displayName, Collections.singleton(this.fileInfo.getFile()));
            }
            return displayName;
        }

        public String getShortDescription() {
            FileObject file = this.fileInfo.getFile();
            String filepath = null;
            FileObject sourceDir = ProjectPropertiesSupport.getSourcesDirectory(this.project);
            if (sourceDir != null) {
                filepath = FileUtil.getRelativePath((FileObject)sourceDir, (FileObject)file);
            }
            if (filepath == null) {
                filepath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)file);
            }
            if (filepath == null) {
                filepath = FileUtil.getFileDisplayName((FileObject)file);
            }
            return filepath;
        }

        @CheckForNull
        private StatusDecorator getStatusDecorator() {
            try {
                return this.fileInfo.getFile().getFileSystem().getDecorator();
            }
            catch (FileStateInvalidException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return null;
            }
        }
    }

    private static final class ConfigFilesChildren
    extends Children.Keys<ImportantFilesImplementation.FileInfo> {
        private static final Logger LOGGER = Logger.getLogger(ConfigFilesChildren.class.getName());
        private final PhpProject project;
        private final List<ImportantFilesImplementation> configFiles;

        ConfigFilesChildren(PhpProject project, List<ImportantFilesImplementation> configFiles) {
            super(true);
            assert (project != null);
            assert (configFiles != null);
            this.project = project;
            this.configFiles = configFiles;
        }

        public boolean hasConfigFiles() {
            return !this.getConfigFiles().isEmpty();
        }

        private void refreshConfigFiles() {
            this.setKeys();
        }

        protected Node[] createNodes(ImportantFilesImplementation.FileInfo key) {
            assert (key != null);
            try {
                return new Node[]{new ImportantFileNode(this.project, key)};
            }
            catch (DataObjectNotFoundException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                return new Node[0];
            }
        }

        protected void addNotify() {
            this.setKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        private void setKeys() {
            this.setKeys(this.getConfigFiles());
        }

        private List<ImportantFilesImplementation.FileInfo> getConfigFiles() {
            LinkedHashSet importantFiles = new LinkedHashSet();
            for (ImportantFilesImplementation provider : this.configFiles) {
                importantFiles.addAll(provider.getFiles());
            }
            return new ArrayList<ImportantFilesImplementation.FileInfo>(importantFiles);
        }
    }

    private static final class ConfigFilesNode
    extends AbstractNode {
        private static final String BADGE = "org/netbeans/modules/php/project/ui/resources/config-badge.gif";
        private final Node iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();

        ConfigFilesNode(Children children) {
            super(children);
        }

        public String getDisplayName() {
            return Bundle.ConfigFilesNode_name();
        }

        public Image getIcon(int type) {
            return ImageUtilities.mergeImages((Image)this.iconDelegate.getIcon(type), (Image)ImageUtilities.loadImage((String)BADGE), (int)7, (int)7);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }
}

