/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.awt.Container;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionQuery;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SQLCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1 || queryType == 9) {
            DatabaseConnection dbconn = SQLCompletionProvider.findDBConn(component);
            return new AsyncCompletionTask((AsyncCompletionQuery)new SQLCompletionQuery(dbconn), component);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        String message;
        if (!".".equals(typedText)) {
            return 0;
        }
        if (!SQLCompletionProvider.isDotAtOffset(component, component.getSelectionStart() - 1)) {
            return 0;
        }
        DatabaseConnection dbconn = SQLCompletionProvider.findDBConn(component);
        if (dbconn == null) {
            message = NbBundle.getMessage(SQLCompletionProvider.class, (String)"MSG_NoDatabaseConnection");
            StatusDisplayer.getDefault().setStatusText(message);
        }
        if (dbconn != null && dbconn.getJDBCConnection() == null) {
            message = NbBundle.getMessage(SQLCompletionProvider.class, (String)"MSG_NotConnected");
            StatusDisplayer.getDefault().setStatusText(message);
        }
        return 1;
    }

    private static DatabaseConnection findDBConn(JTextComponent component) {
        Lookup context = SQLCompletionProvider.findContext(component);
        if (context == null) {
            return null;
        }
        SQLExecution sqlExecution = (SQLExecution)context.lookup(SQLExecution.class);
        if (sqlExecution == null) {
            return null;
        }
        return sqlExecution.getDatabaseConnection();
    }

    private static Lookup findContext(JTextComponent component) {
        for (Container comp = component; comp != null; comp = comp.getParent()) {
            Lookup lookup;
            if (!(comp instanceof Lookup.Provider) || (lookup = ((Lookup.Provider)comp).getLookup()) == null) continue;
            return lookup;
        }
        return null;
    }

    private static boolean isDotAtOffset(JTextComponent component, int offset) {
        Document doc = component.getDocument();
        boolean[] result = new boolean[]{false};
        doc.render(() -> {
            TokenSequence<SQLTokenId> seq = SQLCompletionProvider.getSQLTokenSequence(doc);
            if (seq == null) {
                return;
            }
            seq.move(offset);
            if (!seq.moveNext() && !seq.movePrevious()) {
                return;
            }
            if (seq.offset() != offset) {
                return;
            }
            result[0] = seq.token().id() == SQLTokenId.DOT;
        });
        return result[0];
    }

    private static TokenSequence<SQLTokenId> getSQLTokenSequence(Document doc) {
        if (doc.getProperty(Language.class) == null) {
            doc.putProperty(Language.class, SQLTokenId.language());
        }
        TokenHierarchy hierarchy = TokenHierarchy.get((Document)doc);
        return hierarchy.tokenSequence(SQLTokenId.language());
    }
}

