/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.apigen.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.apigen.commands.ApiGenScript;
import org.netbeans.modules.php.apigen.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ApiGenOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 458797646546L;
    private static final String APIGEN_LAST_FOLDER_SUFFIX = ".apigen";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel apiGenLabel;
    private JTextField apiGenTextField;
    private JButton browseButton;
    private JLabel errorLabel;
    private JLabel hintLabel;
    private JLabel installationInstructionsLabel;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton searchButton;
    private JLabel versionLabel;

    public ApiGenOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.hintLabel.setText(Bundle.ApiGenOptionsPanel_apiGen_hint("apigen", ApiGenScript.SCRIPT_NAME_LONG));
        this.errorLabel.setText(" ");
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.apiGenTextField.getDocument().addDocumentListener(documentListener);
    }

    public String getApiGen() {
        return this.apiGenTextField.getText();
    }

    public void setApiGen(String apiGen) {
        this.apiGenTextField.setText(apiGen);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.apiGenLabel = new JLabel();
        this.apiGenTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchButton = new JButton();
        this.hintLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.installationInstructionsLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.apiGenLabel.setLabelFor(this.apiGenTextField);
        Mnemonics.setLocalizedText((JLabel)this.apiGenLabel, (String)NbBundle.getMessage(ApiGenOptionsPanel.class, (String)"ApiGenOptionsPanel.apiGenLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ApiGenOptionsPanel.class, (String)"ApiGenOptionsPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ApiGenOptionsPanel.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(ApiGenOptionsPanel.class, (String)"ApiGenOptionsPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ApiGenOptionsPanel.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(ApiGenOptionsPanel.class, (String)"ApiGenOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(ApiGenOptionsPanel.class, (String)"ApiGenOptionsPanel.versionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installationInstructionsLabel, (String)NbBundle.getMessage(ApiGenOptionsPanel.class, (String)"ApiGenOptionsPanel.installationInstructionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(ApiGenOptionsPanel.class, (String)"ApiGenOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ApiGenOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ApiGenOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.apiGenLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.apiGenTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.errorLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installationInstructionsLabel).addComponent(this.learnMoreLabel, -2, -1, -2).addComponent(this.versionLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.browseButton, this.searchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.apiGenTextField, -2, -1, -2).addComponent(this.apiGenLabel).addComponent(this.searchButton).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintLabel).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installationInstructionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://apigen.org/"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File apiGenScript = new FileChooserBuilder(ApiGenOptionsPanel.class.getName() + APIGEN_LAST_FOLDER_SUFFIX).setTitle(Bundle.ApiGenOptionsPanel_browse_title()).setFilesOnly(true).showOpenDialog();
        if (apiGenScript != null) {
            apiGenScript = FileUtil.normalizeFile((File)apiGenScript);
            this.apiGenTextField.setText(apiGenScript.getAbsolutePath());
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String script = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"apigen", ApiGenScript.SCRIPT_NAME_LONG});
            }

            public String getWindowTitle() {
                return Bundle.ApiGenOptionsPanel_search_scripts_title();
            }

            public String getListTitle() {
                return Bundle.ApiGenOptionsPanel_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.ApiGenOptionsPanel_search_scripts_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.ApiGenOptionsPanel_search_scripts_notFound();
            }
        });
        if (script != null) {
            this.apiGenTextField.setText(script);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            ApiGenOptionsPanel.this.fireChange();
        }
    }
}

