/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.ast;

import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;

public final class TruffleNode {
    private final String className;
    private final String description;
    private final String sourceURI;
    private final int l1;
    private final int c1;
    private final int l2;
    private final int c2;
    private final String tags;
    private final TruffleNode[] ch;
    private boolean current;
    private boolean currentEncapsulating;

    public TruffleNode(String className, String description, String sourceURI, int l1, int c1, int l2, int c2, String tags, int numCh) {
        this.className = className;
        this.description = description;
        this.sourceURI = sourceURI;
        this.l1 = l1;
        this.c1 = c1;
        this.l2 = l2;
        this.c2 = c2;
        this.tags = tags;
        this.ch = new TruffleNode[numCh];
    }

    private void setChild(int i, TruffleNode node) {
        this.ch[i] = node;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassSimpleName() {
        int index = this.className.lastIndexOf(46);
        if (index > 0) {
            return this.className.substring(index + 1);
        }
        return this.className;
    }

    public String getTags() {
        return this.tags;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public int getStartLine() {
        return this.l1;
    }

    public int getStartColumn() {
        return this.c1;
    }

    public int getEndLine() {
        return this.l2;
    }

    public int getEndColumn() {
        return this.c2;
    }

    public TruffleNode[] getChildren() {
        return this.ch;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public boolean isCurrentEncapsulating() {
        return this.currentEncapsulating;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TruffleNode node;
        private SourcePosition currentPosition;

        private Builder() {
        }

        public Builder nodes(String nodes) {
            StringLineReader slr = new StringLineReader(nodes);
            this.node = this.parseNode(slr);
            return this;
        }

        public TruffleNode build() {
            if (this.currentPosition != null) {
                Builder.markCurrent(this.node, this.currentPosition);
            }
            return this.node;
        }

        private static boolean markCurrent(TruffleNode node, SourcePosition currentPosition) {
            if (node.getStartLine() == currentPosition.getStartLine() && node.getEndLine() == currentPosition.getEndLine() && node.getStartColumn() == currentPosition.getStartColumn() && node.getEndColumn() == currentPosition.getEndColumn()) {
                node.current = true;
                return true;
            }
            boolean isSomeCurrent = false;
            for (TruffleNode ch : node.getChildren()) {
                if (!Builder.markCurrent(ch, currentPosition)) continue;
                isSomeCurrent = true;
            }
            node.currentEncapsulating = isSomeCurrent;
            return isSomeCurrent;
        }

        private TruffleNode parseNode(StringLineReader slr) {
            int l1;
            int c1;
            int l2;
            int c2;
            String sourceURI;
            String className = slr.nextLine();
            String description = slr.nextLine();
            String ss = slr.nextLine();
            if (ss.isEmpty()) {
                sourceURI = null;
                c2 = -1;
                l2 = -1;
                c1 = -1;
                l1 = -1;
            } else {
                sourceURI = ss;
                ss = slr.nextLine();
                int i1 = 0;
                int i2 = ss.indexOf(58);
                l1 = Integer.parseInt(ss.substring(i1, i2));
                i1 = i2 + 1;
                i2 = ss.indexOf(45);
                c1 = Integer.parseInt(ss.substring(i1, i2));
                i1 = i2 + 1;
                i2 = ss.indexOf(58, i1);
                l2 = Integer.parseInt(ss.substring(i1, i2));
                i1 = i2 + 1;
                i2 = ss.length();
                c2 = Integer.parseInt(ss.substring(i1, i2));
            }
            String tags = slr.nextLine();
            int numCh = Integer.parseInt(slr.nextLine());
            TruffleNode node = new TruffleNode(className, description, sourceURI, l1, c1, l2, c2, tags, numCh);
            for (int i = 0; i < numCh; ++i) {
                node.setChild(i, this.parseNode(slr));
            }
            return node;
        }

        public Builder currentPosition(SourcePosition position) {
            this.currentPosition = position;
            return this;
        }

        private static class StringLineReader {
            private final String lines;
            private int i = 0;

            private StringLineReader(String lines) {
                this.lines = lines;
            }

            String nextLine() {
                int i2 = this.lines.indexOf(10, this.i);
                if (i2 < this.i) {
                    return null;
                }
                String line = this.lines.substring(this.i, i2);
                this.i = i2 + 1;
                return line;
            }
        }
    }
}

