/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.htmlui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.spi.ProtoPresenter;
import org.netbeans.html.presenters.spi.ProtoPresenterBuilder;
import org.netbeans.modules.java.lsp.server.htmlui.Buttons;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.HtmlPageParams;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.spi.htmlui.HTMLViewerSpi;
import org.openide.util.Exceptions;

public class WebView
implements Closeable {
    private static final Logger LOG = Logger.getLogger(WebView.class.getName());
    private final Consumer<Page> viewer;
    private final String app;
    private Runnable onPageLoad;
    private String id;

    public WebView(Consumer<Page> viewer) {
        this.viewer = viewer;
        this.app = WebView.findCalleeClassName();
    }

    public void displayPage(HTMLViewerSpi.Context ctx) {
        try {
            this.onPageLoad = () -> {
                Buttons.registerCloseWindow();
                try {
                    ctx.onPageLoad();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            };
            this.id = UUID.randomUUID().toString();
            Server.SESSIONS.put(this.id, new Command(this));
            this.viewer.accept(new Page(this.id, this.getText(ctx.getPage(), this.id), this.getResources(ctx.getPage(), ctx.getResources())));
        }
        catch (IOException ex) {
            Logger.getLogger(WebView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void close() throws IOException {
        Server.SESSIONS.remove(this.id);
    }

    private String getText(URL page, String id) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader is = new InputStreamReader(page.openStream());){
            int ch;
            int state;
            int n = state = id != null ? 0 : 1000;
            while ((ch = ((Reader)is).read()) != -1) {
                char lower = Character.toLowerCase((char)ch);
                switch (state) {
                    case 1000: {
                        break;
                    }
                    case 0: {
                        if (lower != '<') break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (lower == 'b') {
                            state = 2;
                            break;
                        }
                        if (lower == ' ' || lower == '\n') break;
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (lower == 'o') {
                            state = 3;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 3: {
                        if (lower == 'd') {
                            state = 4;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 4: {
                        if (lower == 'y') {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 5: {
                        if (lower == '>') {
                            state = 500;
                            break;
                        }
                        if (lower == ' ' || lower == '\n') break;
                        state = 0;
                    }
                }
                sb.append((char)ch);
                if (state != 500) continue;
                this.emitScript(sb, id);
                state = 1000;
            }
            if (state != 1000) {
                this.emitScript(sb, id);
            }
        }
        return sb.toString();
    }

    private void emitScript(StringBuilder sb, String id) throws IOException {
        sb.append("<script id='exec' type='text/javascript'>\nconst vscode = acquireVsCodeApi();\n(function () {\n  window.addEventListener('message', new Function('event', `\n    const message = event.data;\n    if (message.pause) {\n      debugger;\n    }\n    if (message.execScript) {\n      try {\n        (0 || eval)(message.execScript);\n      } catch (e) {\n        console.warn(e); \n      }\n    }\n  `));\n  vscode.postMessage({\n    command: 'command',\n    data: {\n      id: '" + id + "'\n    }\n  });\n}());\n</script>\n");
    }

    private Map<String, String> getResources(URL page, String[] resources) throws IOException {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String resource : resources) {
            ret.put(resource, this.getText(new URL(page, resource), null));
        }
        return ret;
    }

    private String createCallbackFn(String id) {
        return "this.toBrwsrSrvr = function(name, a1, a2, a3, a4) {\n  vscode.postMessage({\n    command: 'command',\n    data: {\n      id: '" + id + "',\n      name,\n      p0: encodeURIComponent(a1),\n      p1: encodeURIComponent(a2),\n      p2: encodeURIComponent(a3),\n      p3: encodeURIComponent(a4)\n    }  });\n  return '';\n};\n";
    }

    private static String findCalleeClassName() {
        StackTraceElement[] frames;
        for (StackTraceElement e : frames = new Exception().getStackTrace()) {
            String cn = e.getClassName();
            if (cn.startsWith("com.dukescript.presenters.") || cn.startsWith("org.netbeans.html.") || cn.startsWith("net.java.html.") || cn.startsWith("java.") || cn.startsWith("javafx.") || cn.startsWith("com.sun.")) continue;
            return cn;
        }
        return "org.netbeans.html";
    }

    public static final class Server
    extends CodeActionsProvider {
        private static final Map<String, Command> SESSIONS = new HashMap<String, Command>();
        private static final String PROCESS_COMMAND = "nbls.htmlui.process.command";
        private static final String ID = "id";
        private final Gson gson = new Gson();

        @Override
        public Set<String> getCommands() {
            return Collections.singleton(PROCESS_COMMAND);
        }

        @Override
        public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
            Command c;
            Map m;
            String id;
            if (arguments != null && !arguments.isEmpty() && (id = (String)(m = (Map)this.gson.fromJson((JsonElement)((JsonObject)arguments.get(0)), Map.class)).get(ID)) != null && (c = SESSIONS.get(id)) != null) {
                return c.service(client, m).thenApply(res -> res != null ? res : "null");
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
            return Collections.emptyList();
        }
    }

    private static final class Command
    implements Executor,
    ThreadFactory {
        private final WebView webView;
        private final String id;
        private final Executor RUN;
        private Thread RUNNER;
        private NbCodeLanguageClient client;
        private final ProtoPresenter presenter;

        private Command(WebView webView) {
            this.webView = webView;
            this.id = this.webView.id;
            this.RUN = Executors.newSingleThreadExecutor(this);
            this.presenter = ProtoPresenterBuilder.newBuilder().preparator(this::callbackFn, true).loadJavaScript(this::loadJS, false).app(webView.app).dispatcher((Executor)this, true).displayer(this::displayPage).logger(this::log).type("Browser").register((Object)this).build();
        }

        @Override
        public void execute(Runnable r) {
            this.runSafe(r, (Fn.Presenter)this.presenter);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t;
            this.RUNNER = t = new Thread(r, "Processor for " + this.id);
            return t;
        }

        private void execScript(String obj) {
            this.client.execInHtmlPage(new HtmlPageParams(this.id, obj));
        }

        private void initialize(NbCodeLanguageClient client) {
            if (this.client == null) {
                this.client = client;
                this.execute(this.webView.onPageLoad);
            }
        }

        private CompletableFuture<Object> service(NbCodeLanguageClient client, Map params) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            String methodName = (String)params.get("name");
            if (methodName == null) {
                this.initialize(client);
                future.complete(null);
            } else {
                try {
                    String result = this.presenter.js2java(methodName, URLDecoder.decode((String)params.get("p0"), "UTF-8"), URLDecoder.decode((String)params.get("p1"), "UTF-8"), URLDecoder.decode((String)params.get("p2"), "UTF-8"), URLDecoder.decode((String)params.get("p3"), "UTF-8"));
                    future.complete(result);
                }
                catch (Exception ex) {
                    future.complete("error:" + ex.getMessage());
                }
            }
            return future;
        }

        private void callbackFn(ProtoPresenterBuilder.OnPrepared onReady) {
            String sb = this.webView.createCallbackFn(this.id);
            this.execScript(sb);
            onReady.callbackIsPrepared("toBrwsrSrvr");
        }

        private void log(int priority, String msg, Object ... args) {
            Level level = Command.findLevel(priority);
            if (args.length == 1 && args[0] instanceof Throwable) {
                LOG.log(level, msg, (Throwable)args[0]);
            } else {
                LOG.log(level, msg, args);
            }
        }

        private void loadJS(String js) {
            this.execScript(js);
        }

        private void displayPage(URL url, Runnable r) {
            throw new UnsupportedOperationException(url.toString());
        }

        private void runSafe(final Runnable r, final Fn.Presenter p) {
            class Wrap
            implements Runnable {
                Wrap() {
                }

                @Override
                public void run() {
                    if (p != null) {
                        try (Closeable c = Fn.activate((Fn.Presenter)p);){
                            r.run();
                        }
                        catch (IOException iOException) {}
                    } else {
                        r.run();
                    }
                }
            }
            if (this.RUNNER == Thread.currentThread()) {
                if (p != null) {
                    Wrap w = new Wrap();
                    w.run();
                } else {
                    r.run();
                }
            } else {
                Wrap w = new Wrap();
                this.RUN.execute(w);
            }
        }

        private static Level findLevel(int priority) {
            if (priority >= Level.SEVERE.intValue()) {
                return Level.SEVERE;
            }
            if (priority >= Level.WARNING.intValue()) {
                return Level.WARNING;
            }
            if (priority >= Level.INFO.intValue()) {
                return Level.INFO;
            }
            return Level.FINE;
        }
    }

    public static final class Page {
        private final String id;
        private final String text;
        private final Map<String, String> resources;

        private Page(String id, String text, Map<String, String> resources) {
            this.id = id;
            this.text = text;
            this.resources = resources;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public Map<String, String> getResources() {
            return this.resources;
        }
    }
}

