/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.util.Objects;
import org.netbeans.core.startup.layers.NbinstURLMapper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class NbinstURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new NbinstURLConnection(u);
    }

    @Override
    protected InetAddress getHostAddress(URL u) {
        return null;
    }

    @Override
    protected int hashCode(URL u) {
        String file;
        int h = 0;
        String host = u.getHost();
        if (host != null) {
            h += host.toLowerCase().hashCode();
        }
        if ((file = u.getFile()) != null) {
            h += file.hashCode();
        }
        return h;
    }

    @Override
    protected boolean sameFile(URL u1, URL u2) {
        if (!(u1.getProtocol() == u2.getProtocol() || u1.getProtocol() != null && u1.getProtocol().equalsIgnoreCase(u2.getProtocol()))) {
            return false;
        }
        if (!Objects.equals(u1.getFile(), u2.getFile())) {
            return false;
        }
        return this.hostsEqual(u1, u2);
    }

    @Override
    protected boolean hostsEqual(URL u1, URL u2) {
        String host1 = u1.getHost();
        String host2 = u2.getHost();
        if (host1 != null && host2 != null) {
            return host1.equalsIgnoreCase(host2);
        }
        return host1 == null && host2 == null;
    }

    private static class NbinstURLConnection
    extends URLConnection {
        private File f;
        private InputStream iStream;

        public NbinstURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            if (this.f == null) {
                this.f = NbinstURLMapper.decodeURL(this.url);
                if (this.f == null) {
                    throw new FileNotFoundException("Cannot find: " + this.url);
                }
            }
            if (!this.f.isFile()) {
                throw new UnknownServiceException();
            }
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
                return (int)this.f.length();
            }
            catch (IOException e) {
                return -1;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.iStream == null) {
                this.iStream = new FileInputStream(this.f);
            }
            return this.iStream;
        }

        @Override
        public String getHeaderField(String name) {
            if ("content-type".equals(name)) {
                try {
                    this.connect();
                    FileObject fo = FileUtil.toFileObject((File)this.f);
                    if (fo != null) {
                        return fo.getMIMEType();
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            return super.getHeaderField(name);
        }
    }
}

