/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.api.model.AuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class NamedAuthInfoFluentImpl<A extends NamedAuthInfoFluent<A>>
extends BaseFluent<A>
implements NamedAuthInfoFluent<A> {
    private String name;
    private AuthInfoBuilder user;
    private Map<String, Object> additionalProperties;

    public NamedAuthInfoFluentImpl() {
    }

    public NamedAuthInfoFluentImpl(NamedAuthInfo instance) {
        if (instance != null) {
            this.withName(instance.getName());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public AuthInfo getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public AuthInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(AuthInfo user) {
        this._visitables.get("user").remove(this.user);
        if (user != null) {
            this.user = new AuthInfoBuilder(user);
            this._visitables.get("user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get("user").remove(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUserLike(AuthInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new AuthInfoBuilder().build());
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editOrNewUserLike(AuthInfo item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class UserNestedImpl<N>
    extends AuthInfoFluentImpl<NamedAuthInfoFluent.UserNested<N>>
    implements NamedAuthInfoFluent.UserNested<N>,
    Nested<N> {
        AuthInfoBuilder builder;

        UserNestedImpl(AuthInfo item) {
            this.builder = new AuthInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new AuthInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedAuthInfoFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

