/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SECategoryExtensionProvider;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerApplication
extends JPanel
implements HelpCtx.Provider {
    private File lastImageFolder;
    private J2SEProject project;
    private List<J2SECategoryExtensionProvider> compProviders = new LinkedList<J2SECategoryExtensionProvider>();
    private int nextExtensionYPos;
    private JButton browseButton;
    private JLabel descLabel;
    private JTextArea descTextArea1;
    private JPanel extPanel;
    private JLabel homepageLabel;
    private JTextField homepageTextField;
    private JScrollPane jScrollPane;
    private JPanel mainPanel;
    private JLabel panelDescLabel;
    private JLabel splashLabel;
    private JTextField splashTextField;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JLabel vendorLabel;
    private JTextField vendorTextField;

    public CustomizerApplication(J2SEProjectProperties props) {
        this.initComponents();
        this.titleTextField.setDocument(props.APPLICATION_TITLE_DOC);
        this.vendorTextField.setDocument(props.APPLICATION_VENDOR_DOC);
        this.descTextArea1.setDocument(props.APPLICATION_DESC_DOC);
        this.homepageTextField.setDocument(props.APPLICATION_HOMEPAGE_DOC);
        this.splashTextField.setDocument(props.APPLICATION_SPLASH_DOC);
        this.project = props.getProject();
        for (J2SECategoryExtensionProvider compProvider : this.project.getLookup().lookupAll(J2SECategoryExtensionProvider.class)) {
            if (compProvider.getCategory() != J2SECategoryExtensionProvider.ExtensibleCategory.APPLICATION || !this.addExtPanel(this.project, compProvider, this.nextExtensionYPos)) continue;
            this.compProviders.add(compProvider);
            ++this.nextExtensionYPos;
        }
        this.addPanelFiller(this.nextExtensionYPos);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.panelDescLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.vendorLabel = new JLabel();
        this.descLabel = new JLabel();
        this.homepageLabel = new JLabel();
        this.splashLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.vendorTextField = new JTextField();
        this.homepageTextField = new JTextField();
        this.splashTextField = new JTextField();
        this.browseButton = new JButton();
        this.jScrollPane = new JScrollPane();
        this.descTextArea1 = new JTextArea();
        this.extPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.panelDescLabel, (String)NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.panelDescLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.mainPanel.add((Component)this.panelDescLabel, gridBagConstraints);
        this.titleLabel.setLabelFor(this.titleTextField);
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.titleLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.mainPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.vendorLabel.setLabelFor(this.vendorTextField);
        Mnemonics.setLocalizedText((JLabel)this.vendorLabel, (String)NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.vendorLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.mainPanel.add((Component)this.vendorLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.descLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.mainPanel.add((Component)this.descLabel, gridBagConstraints);
        this.homepageLabel.setLabelFor(this.homepageTextField);
        Mnemonics.setLocalizedText((JLabel)this.homepageLabel, (String)NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.homepageLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.mainPanel.add((Component)this.homepageLabel, gridBagConstraints);
        this.splashLabel.setLabelFor(this.splashTextField);
        Mnemonics.setLocalizedText((JLabel)this.splashLabel, (String)NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.splashLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.mainPanel.add((Component)this.splashLabel, gridBagConstraints);
        this.titleTextField.setText(NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.titleTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.mainPanel.add((Component)this.titleTextField, gridBagConstraints);
        this.vendorTextField.setText(NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.vendorTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.mainPanel.add((Component)this.vendorTextField, gridBagConstraints);
        this.homepageTextField.setText(NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.homepageTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.mainPanel.add((Component)this.homepageTextField, gridBagConstraints);
        this.splashTextField.setText(NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.splashTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.mainPanel.add((Component)this.splashTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(CustomizerApplication.class, (String)"CustomizerApplication.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerApplication.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.mainPanel.add((Component)this.browseButton, gridBagConstraints);
        this.descTextArea1.setColumns(8);
        this.descTextArea1.setRows(4);
        this.jScrollPane.setViewportView(this.descTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.mainPanel.add((Component)this.jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new SplashFileFilter());
        if (this.lastImageFolder != null) {
            chooser.setCurrentDirectory(this.lastImageFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage(CustomizerApplication.class, (String)"LBL_Select_Splash_Image"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.splashTextField.setText(file.getAbsolutePath());
            this.lastImageFolder = file.getParentFile();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerApplication.class);
    }

    private boolean addExtPanel(Project p, J2SECategoryExtensionProvider compProvider, int gridY) {
        J2SECategoryExtensionProvider.ConfigChangeListener ccl;
        JComponent comp;
        if (compProvider != null && (comp = compProvider.createComponent(p, ccl = new J2SECategoryExtensionProvider.ConfigChangeListener(){

            @Override
            public void propertiesChanged(Map<String, String> updates) {
            }
        })) != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = gridY;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
            return true;
        }
        return false;
    }

    private void addPanelFiller(int gridY) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = gridY;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.extPanel.add((Component)new Box.Filler(new Dimension(), new Dimension(), new Dimension(10000, 10000)), constraints);
    }

    private static class SplashFileFilter
    extends FileFilter {
        private SplashFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String ext;
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            return index > 0 && index < name.length() - 1 && ("gif".equals(ext = name.substring(index + 1).toLowerCase()) || "png".equals(ext) || "jpg".equals(ext));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(CustomizerApplication.class, (String)"TXT_SplashImageFiles");
        }
    }
}

