/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.CreateDatabaseBase;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateDatabaseRequest
extends BmcRequest<CreateDatabaseBase> {
    private CreateDatabaseBase createNewDatabaseDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateDatabaseBase getCreateNewDatabaseDetails() {
        return this.createNewDatabaseDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateDatabaseBase getBody$() {
        return this.createNewDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().createNewDatabaseDetails(this.createNewDatabaseDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createNewDatabaseDetails=").append(String.valueOf((Object)this.createNewDatabaseDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDatabaseRequest)) {
            return false;
        }
        CreateDatabaseRequest other = (CreateDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createNewDatabaseDetails, (Object)other.createNewDatabaseDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createNewDatabaseDetails == null ? 43 : this.createNewDatabaseDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDatabaseRequest, CreateDatabaseBase> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateDatabaseBase createNewDatabaseDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createNewDatabaseDetails(CreateDatabaseBase createNewDatabaseDetails) {
            this.createNewDatabaseDetails = createNewDatabaseDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDatabaseRequest o) {
            this.createNewDatabaseDetails(o.getCreateNewDatabaseDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDatabaseRequest build() {
            CreateDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDatabaseBase body) {
            this.createNewDatabaseDetails(body);
            return this;
        }

        public CreateDatabaseRequest buildWithoutInvocationCallback() {
            CreateDatabaseRequest request = new CreateDatabaseRequest();
            request.createNewDatabaseDetails = this.createNewDatabaseDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

