/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer;

import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public final class TracerProgressObject {
    private final int steps;
    private String text;
    private int currentStep;
    private int lastStep;
    private final Set<Listener> listeners;

    public TracerProgressObject(int steps) {
        this(steps, null);
    }

    public TracerProgressObject(int steps, String text) {
        if (steps < 1) {
            throw new IllegalArgumentException("steps value must be >= 1: " + steps);
        }
        this.steps = steps;
        this.text = text;
        this.currentStep = 0;
        this.lastStep = 0;
        this.listeners = new HashSet<Listener>();
    }

    public synchronized int getSteps() {
        return this.steps;
    }

    public synchronized int getCurrentStep() {
        return this.currentStep;
    }

    public synchronized String getText() {
        return this.text;
    }

    public void addStep() {
        this.addSteps(1);
    }

    public void addStep(String text) {
        this.addSteps(1, text);
    }

    public void addSteps(int steps) {
        this.addSteps(steps, this.text);
    }

    public synchronized void addSteps(int steps, String text) {
        if (steps < 0) {
            throw new IllegalArgumentException("steps value must be >= 0: " + steps);
        }
        if (this.currentStep + steps > this.steps) {
            throw new IllegalArgumentException("Total steps exceeded: " + (this.currentStep + steps) + ">" + this.steps);
        }
        this.currentStep += steps;
        this.text = text;
        this.fireChange();
    }

    public synchronized void setText(String text) {
        this.text = text;
        this.fireChange();
    }

    public synchronized void finish() {
        if (this.isFinished()) {
            return;
        }
        this.currentStep = this.steps;
        this.fireChange();
    }

    public synchronized boolean isFinished() {
        return this.currentStep == this.steps;
    }

    public synchronized void addListener(Listener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        final int currentStepF = this.currentStep;
        final int addedStepsF = this.currentStep - this.lastStep;
        final String textF = this.text;
        final HashSet<Listener> toNotify = new HashSet<Listener>(this.listeners);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : toNotify) {
                    listener.progressChanged(addedStepsF, currentStepF, textF);
                }
            }
        });
        this.lastStep = this.currentStep;
    }

    public static interface Listener {
        public void progressChanged(int var1, int var2, String var3);
    }
}

