/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SourceFoldersPanel
extends JPanel
implements HelpCtx.Provider,
ListSelectionListener {
    private static final String DEFAULT_SOURCE_LEVEL = "11";
    private static final List<String> JAVA_SOURCE_LEVEL = Collections.unmodifiableList(Arrays.asList("1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "9", "10", "11", "12", "13", "14", "15", "16", "17"));
    private SourcesModel sourceFoldersModel;
    private SourcesModel testFoldersModel;
    private ChangeListener listener;
    private boolean isWizard;
    private ProjectModel model;
    private static final List<String> TEST_FOLDER_PATHS = Arrays.asList("test");
    private JButton addFolder;
    private JButton addTestFolder;
    private JButton downFolder;
    private JButton downTestFolder;
    private JComboBox encodingComboBox;
    private JLabel encodingLabel;
    private JButton includesExcludesButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JButton removeFolder;
    private JButton removeTestFolder;
    private JTable sourceFolders;
    private JComboBox<String> sourceLevel;
    private JTable testFolders;
    private JButton upFolder;
    private JButton upTestFolder;

    public SourceFoldersPanel() {
        this(true);
    }

    public SourceFoldersPanel(boolean isWizard) {
        this.isWizard = isWizard;
        this.initComponents();
        this.sourceFoldersModel = new SourcesModel(false);
        this.sourceFolders.setModel(this.sourceFoldersModel);
        this.sourceFolders.getSelectionModel().addListSelectionListener(this);
        this.testFoldersModel = new SourcesModel(true);
        this.testFolders.setModel(this.testFoldersModel);
        this.testFolders.getSelectionModel().addListSelectionListener(this);
        this.sourceFolders.getTableHeader().setReorderingAllowed(false);
        this.sourceFolders.setDefaultRenderer(String.class, new ToolTipRenderer());
        this.testFolders.getTableHeader().setReorderingAllowed(false);
        this.testFolders.setDefaultRenderer(String.class, new ToolTipRenderer());
        this.initSourceLevel();
        this.jLabel1.setVisible(isWizard);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SourceFoldersPanel.class);
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    private void initSourceLevel() {
        for (String javaSourceLevel : JAVA_SOURCE_LEVEL) {
            this.sourceLevel.addItem(javaSourceLevel);
        }
    }

    private void updateButtons() {
        this.removeFolder.setEnabled(this.sourceFolders.getSelectedRowCount() > 0);
        this.removeTestFolder.setEnabled(this.testFolders.getSelectedRowCount() > 0);
        this.updateUpDownButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    private void updateUpDownButtons() {
        int first = this.sourceFolders.getSelectionModel().getMinSelectionIndex();
        int last = this.sourceFolders.getSelectionModel().getMaxSelectionIndex();
        this.upFolder.setEnabled(first > 0);
        this.downFolder.setEnabled(last > -1 && last < this.sourceFoldersModel.getRowCount() - 1);
        first = this.testFolders.getSelectionModel().getMinSelectionIndex();
        last = this.testFolders.getSelectionModel().getMaxSelectionIndex();
        this.upTestFolder.setEnabled(first > 0);
        this.downTestFolder.setEnabled(last > -1 && last < this.testFoldersModel.getRowCount() - 1);
    }

    private void updateSourceLevelCombo(String sourceLevelValue) {
        this.sourceLevel.setSelectedItem(sourceLevelValue);
    }

    private void updateEncodingCombo() {
        String enc = this.model.getEncoding();
        this.encodingComboBox.setModel(ProjectCustomizer.encodingModel((String)enc));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.sourceLevel = new JComboBox();
        this.addFolder = new JButton();
        this.removeFolder = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sourceFolders = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.testFolders = new JTable();
        this.jLabel4 = new JLabel();
        this.addTestFolder = new JButton();
        this.removeTestFolder = new JButton();
        this.upFolder = new JButton();
        this.downFolder = new JButton();
        this.downTestFolder = new JButton();
        this.upTestFolder = new JButton();
        this.includesExcludesButton = new JButton();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.setMinimumSize(new Dimension(265, 375));
        this.setPreferredSize(new Dimension(800, 500));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel1"));
        this.jLabel2.setLabelFor(this.sourceFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel2"));
        this.jLabel3.setLabelFor(this.sourceLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceLevel_Label"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel3"));
        this.sourceLevel.setEditable(true);
        this.sourceLevel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SourceFoldersPanel.this.sourceLevelItemStateChanged(evt);
            }
        });
        this.sourceLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.sourceLevelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 16);
        this.add(this.sourceLevel, gridBagConstraints);
        this.sourceLevel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceLevel_Name"));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle");
        this.sourceLevel.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_sourceLevel"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_addFolder"));
        this.addFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.addFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addFolder, gridBagConstraints);
        this.addFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_addFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_removeFolder"));
        this.removeFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.removeFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.removeFolder, gridBagConstraints);
        this.removeFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_removeFolder"));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportView(this.sourceFolders);
        this.sourceFolders.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_sourceFolders"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 12, 8);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jScrollPanel1"));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setViewportView(this.testFolders);
        this.testFolders.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SourceFoldersPanel_testFolders"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jScrollPane2.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_jScrollPane2"));
        this.jLabel4.setLabelFor(this.testFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_TestSourceFoldersPanel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_addTestFolder"));
        this.addTestFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.addTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addTestFolder, gridBagConstraints);
        this.addTestFolder.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_addTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_removeTestFolder"));
        this.removeTestFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.removeTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.removeTestFolder, gridBagConstraints);
        this.removeTestFolder.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_removeTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.upFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_upFolder"));
        this.upFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.upFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.upFolder, gridBagConstraints);
        this.upFolder.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_upFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.downFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_downFolder"));
        this.downFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.downFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.downFolder, gridBagConstraints);
        this.downFolder.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_downFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.downTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_downTestFolder"));
        this.downTestFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.downTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.downTestFolder, gridBagConstraints);
        this.downTestFolder.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_downTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.upTestFolder, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_upTestFolder"));
        this.upTestFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.upTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.upTestFolder, gridBagConstraints);
        this.upTestFolder.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_SourceFoldersPanel_upTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.includesExcludesButton, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"SourceFoldersPanel.includesExcludesButton.text"));
        this.includesExcludesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.includesExcludesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.includesExcludesButton, gridBagConstraints);
        this.includesExcludesButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Includes-Excludes_Name"));
        this.includesExcludesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Includes-Excludes_Desc"));
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_Encoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)this.encodingLabel, gridBagConstraints);
        this.encodingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Label_Name"));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Label_Desc"));
        this.encodingComboBox.setRenderer(ProjectCustomizer.encodingRenderer());
        this.encodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.encodingComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 0, 0, 16);
        this.add((Component)this.encodingComboBox, gridBagConstraints);
        this.encodingComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Name"));
        this.encodingComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Encoding_Desc"));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(SourceFoldersPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel1.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSN_Freeform_Warning_Message"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"ACSD_Freeform_Warning_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void encodingComboBoxActionPerformed(ActionEvent evt) {
        Object selItem = this.encodingComboBox.getModel().getSelectedItem();
        if (selItem instanceof Charset) {
            this.model.setEncoding(((Charset)selItem).name());
            FileEncodingQuery.setDefaultEncoding((Charset)((Charset)selItem));
        } else {
            this.model.setEncoding(selItem.toString());
        }
    }

    private void includesExcludesButtonActionPerformed(ActionEvent evt) {
        IncludeExcludeVisualizer v = new IncludeExcludeVisualizer();
        ArrayList<File> roots = new ArrayList<File>();
        for (JavaProjectGenerator.SourceFolder folder : this.model.getSourceFolders()) {
            v.setIncludePattern(folder.includes != null ? folder.includes : "**");
            v.setExcludePattern(folder.excludes != null ? folder.excludes : "");
            File f = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)folder.location);
            if (!f.isDirectory()) continue;
            roots.add(f);
        }
        v.setRoots(roots.toArray(new File[0]));
        DialogDescriptor dd = new DialogDescriptor((Object)v.getVisualizerPanel(), NbBundle.getMessage(SourceFoldersPanel.class, (String)"SourceFoldersPanel.title.includeExclude"));
        dd.setOptionType(2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            for (JavaProjectGenerator.SourceFolder folder : this.model.getSourceFolders()) {
                folder.includes = v.getIncludePattern().equals("**") ? null : v.getIncludePattern();
                folder.excludes = v.getExcludePattern().equals("") ? null : v.getExcludePattern();
            }
        }
    }

    private void downTestFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.testFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = indeces.length - 1; i >= 0; --i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], true);
            this.model.moveSourceFolder(fromIndex, fromIndex + 1);
        }
        this.testFoldersModel.fireTableDataChanged();
        this.testFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.testFolders.getSelectionModel().addSelectionInterval(indeces[i] + 1, indeces[i] + 1);
        }
    }

    private void upTestFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.testFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = 0; i < indeces.length; ++i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], true);
            this.model.moveSourceFolder(fromIndex, fromIndex - 1);
        }
        this.testFoldersModel.fireTableDataChanged();
        this.testFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.testFolders.getSelectionModel().addSelectionInterval(indeces[i] - 1, indeces[i] - 1);
        }
    }

    private void downFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.sourceFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = indeces.length - 1; i >= 0; --i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], false);
            this.model.moveSourceFolder(fromIndex, fromIndex + 1);
        }
        this.sourceFoldersModel.fireTableDataChanged();
        this.sourceFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.sourceFolders.getSelectionModel().addSelectionInterval(indeces[i] + 1, indeces[i] + 1);
        }
    }

    private void upFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.sourceFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = 0; i < indeces.length; ++i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], false);
            this.model.moveSourceFolder(fromIndex, fromIndex - 1);
        }
        this.sourceFoldersModel.fireTableDataChanged();
        this.sourceFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.sourceFolders.getSelectionModel().addSelectionInterval(indeces[i] - 1, indeces[i] - 1);
        }
    }

    private void removeTestFolderActionPerformed(ActionEvent evt) {
        int[] indeces = this.testFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (int i = indeces.length - 1; i >= 0; --i) {
            String location = this.getItem((int)indeces[i], (boolean)true).location;
            this.model.removeSourceFolder(this.calcRealSourceIndex(indeces[i], true));
        }
        this.testFoldersModel.fireTableDataChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
        this.updateButtons();
    }

    private void addTestFolderActionPerformed(ActionEvent evt) {
        this.doAddFolderActionPerformed(evt, true);
    }

    private void sourceLevelItemStateChanged(ItemEvent evt) {
        this.sourceLevelChanged();
    }

    private void removeFolderActionPerformed(ActionEvent evt) {
        int[] indeces = this.sourceFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (int i = indeces.length - 1; i >= 0; --i) {
            String location = this.getItem((int)indeces[i], (boolean)false).location;
            this.model.removeSourceFolder(this.calcRealSourceIndex(indeces[i], false));
        }
        this.sourceFoldersModel.fireTableDataChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
        this.updateButtons();
    }

    private void addFolderActionPerformed(ActionEvent evt) {
        this.doAddFolderActionPerformed(evt, false);
    }

    private void sourceLevelActionPerformed(ActionEvent evt) {
        this.sourceLevelChanged();
    }

    private void sourceLevelChanged() {
        if (this.model != null) {
            String value = (String)this.sourceLevel.getSelectedItem();
            if (value.matches("\\d+(?:\\.\\d+)?")) {
                this.model.setSourceLevel(value);
            } else {
                this.model.setSourceLevel(DEFAULT_SOURCE_LEVEL);
                this.sourceLevel.setSelectedItem(DEFAULT_SOURCE_LEVEL);
            }
        }
    }

    private void doAddFolderActionPerformed(ActionEvent evt, boolean isTests) {
        File[] files;
        FileChooserBuilder builder = new FileChooserBuilder(SourceFoldersPanel.class).setDirectoriesOnly(true);
        if (this.model.getBaseFolder() != null) {
            files = this.model.getBaseFolder().listFiles();
            if (files != null && files.length > 0) {
                builder.setDefaultWorkingDirectory(files[0]);
            } else {
                builder.setDefaultWorkingDirectory(this.model.getBaseFolder());
            }
        }
        if (isTests) {
            builder.setTitle(NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_Browse_Test_Folder"));
        } else {
            builder.setTitle(NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_Browse_Source_Folder"));
        }
        files = builder.showMultiOpenDialog();
        if (files != null) {
            this.model.setEncoding(this.encodingComboBox.getModel().getSelectedItem().toString());
            Set<File> invalidRoots = SourceFoldersPanel.processRoots(this.model, files, isTests, this.isWizard);
            if (isTests) {
                this.testFoldersModel.fireTableDataChanged();
            } else {
                this.sourceFoldersModel.fireTableDataChanged();
            }
            if (this.listener != null) {
                this.listener.stateChanged(null);
            }
            this.updateButtons();
            if (invalidRoots.size() > 0) {
                this.showInvalidRootsWarning(invalidRoots);
            }
        }
    }

    static Set<File> processRoots(ProjectModel model, File[] files, boolean isTests, boolean isWizard) {
        HashSet<File> invalidRoots = new HashSet<File>();
        block0: for (File file : files) {
            File sourceLoc = FileUtil.normalizeFile((File)file);
            String location = Util.relativizeLocation((File)model.getBaseFolder(), (File)model.getNBProjectFolder(), (File)sourceLoc);
            Project thisProject = isWizard ? null : FileOwnerQuery.getOwner((URI)Utilities.toURI((File)model.getNBProjectFolder()));
            Project p = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)sourceLoc));
            if (!(p == null || thisProject != null && thisProject.equals(p) || SourceFoldersPanel.isParentOf(model.getNBProjectFolder(), sourceLoc) || SourceFoldersPanel.isParentOf(model.getBaseFolder(), sourceLoc))) {
                invalidRoots.add(sourceLoc);
                continue;
            }
            List<JavaProjectGenerator.SourceFolder> sourceFolders = model.getSourceFolders();
            for (JavaProjectGenerator.SourceFolder sf : sourceFolders) {
                if (!location.equals(sf.location)) continue;
                if ((!isTests || model.isTestSourceFolder(sf)) && (isTests || !model.isTestSourceFolder(sf))) continue block0;
                invalidRoots.add(sourceLoc);
                continue block0;
            }
            JavaProjectGenerator.SourceFolder sf = new JavaProjectGenerator.SourceFolder();
            sf.location = location;
            sf.type = "java";
            sf.style = "packages";
            sf.label = SourceFoldersPanel.getDefaultLabel(sf.location, isTests);
            if (!sourceFolders.isEmpty()) {
                JavaProjectGenerator.SourceFolder prototype = sourceFolders.iterator().next();
                sf.includes = prototype.includes;
                sf.excludes = prototype.excludes;
            }
            sf.encoding = model.getEncoding();
            model.addSourceFolder(sf, isTests);
        }
        return invalidRoots;
    }

    private static boolean isParentOf(File parent, File child) {
        while (child != null && !child.equals(parent)) {
            child = child.getParentFile();
        }
        return child != null && child.equals(parent);
    }

    private void showInvalidRootsWarning(Set<File> invalidRoots) {
        JButton closeOption = new JButton(NbBundle.getMessage(SourceFoldersPanel.class, (String)"CTL_SourceFolderPanel_Close"));
        closeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"AD_SourceFolderPanel_Close"));
        WarningDlg warning = new WarningDlg(invalidRoots);
        String message = NbBundle.getMessage(SourceFoldersPanel.class, (String)"MSG_InvalidRoot");
        JOptionPane optionPane = new JOptionPane(new Object[]{message, warning}, 2, 0, null, new Object[0], null);
        optionPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"AD_InvalidRootDlg"));
        DialogDescriptor dd = new DialogDescriptor((Object)optionPane, NbBundle.getMessage(SourceFoldersPanel.class, (String)"TITLE_InvalidRoot"), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    static String getDefaultLabel(String location, boolean isTests) {
        if (location.equals(".") || "${project.dir}/".equals(location + "/")) {
            return isTests ? NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_default_test_packages") : NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_default_source_packages");
        }
        String relloc = location;
        if (relloc.startsWith("${project.dir}/")) {
            relloc = relloc.substring("${project.dir}/".length());
        }
        return relloc.replace('/', File.separatorChar);
    }

    public static String getLocationDisplayName(PropertyEvaluator evaluator, File base, String val) {
        File f = Util.resolveFile((PropertyEvaluator)evaluator, (File)base, (String)val);
        if (f == null) {
            return val;
        }
        String location = f.getAbsolutePath();
        if (CollocationQuery.areCollocated((File)base, (File)f)) {
            location = PropertyUtils.relativizeFile((File)base, (File)f).replace('/', File.separatorChar);
        }
        return location;
    }

    private JavaProjectGenerator.SourceFolder getItem(int index, boolean tests) {
        return this.model.getSourceFolder(this.calcRealSourceIndex(index, tests));
    }

    private int calcRealSourceIndex(int index, boolean tests) {
        int realIndex = 0;
        for (int i = 0; i < this.model.getSourceFoldersCount(); ++i) {
            JavaProjectGenerator.SourceFolder sf = this.model.getSourceFolder(i);
            boolean isTest = this.model.isTestSourceFolder(sf);
            if (tests && !isTest || !tests && isTest) continue;
            if (index == realIndex) {
                return i;
            }
            ++realIndex;
        }
        throw new ArrayIndexOutOfBoundsException("index=" + index + " tests=" + tests + " realIndex=" + realIndex);
    }

    public boolean hasSomeSourceFolder() {
        return this.model.getSourceFoldersCount() > 0;
    }

    public void setModel(ProjectModel model, AntProjectHelper projectHelper) {
        this.model = model;
        this.updateSourceLevelCombo(model.getSourceLevel());
        this.updateEncodingCombo();
        this.updateButtons();
        if (this.isWizard) {
            this.updateModel(this.findPossibleSourceRoots());
        }
        this.sourceFoldersModel.fireTableDataChanged();
    }

    private void updateModel(List<JavaProjectGenerator.SourceFolder> srcFolders) {
        if (srcFolders.isEmpty()) {
            return;
        }
        ArrayList<JavaProjectGenerator.SourceFolder> finalSourceFolders = new ArrayList<JavaProjectGenerator.SourceFolder>();
        ArrayList<JavaProjectGenerator.SourceFolder> finalTestFolders = new ArrayList<JavaProjectGenerator.SourceFolder>();
        boolean notEmpty = false;
        for (JavaProjectGenerator.SourceFolder sf : srcFolders) {
            boolean contains = false;
            for (JavaProjectGenerator.SourceFolder msf : this.model.getSourceFolders()) {
                if (!msf.location.equals(sf.location)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            boolean testFolder = false;
            for (String path : TEST_FOLDER_PATHS) {
                if (sf.location.indexOf(path) == -1) continue;
                testFolder = true;
                break;
            }
            if (!testFolder) {
                finalSourceFolders.add(sf);
                notEmpty = true;
                continue;
            }
            finalTestFolders.add(sf);
            notEmpty = true;
        }
        if (notEmpty) {
            FolderComparator comparator = new FolderComparator();
            finalSourceFolders.sort(comparator);
            finalTestFolders.sort(comparator);
            for (JavaProjectGenerator.SourceFolder sf : finalSourceFolders) {
                this.model.addSourceFolder(sf, false);
            }
            for (JavaProjectGenerator.SourceFolder sf : finalTestFolders) {
                this.model.addSourceFolder(sf, true);
            }
        }
    }

    private List<JavaProjectGenerator.SourceFolder> findPossibleSourceRoots() {
        ArrayList<JavaProjectGenerator.SourceFolder> srcFolders = new ArrayList<JavaProjectGenerator.SourceFolder>();
        File baseFolder = this.model.getBaseFolder();
        FileObject baseFolderFO = FileUtil.toFileObject((File)baseFolder);
        Set sourceRoots = JavadocAndSourceRootDetection.findSourceRoots((FileObject)baseFolderFO, null);
        for (FileObject possibleSrcRoot : sourceRoots) {
            JavaProjectGenerator.SourceFolder sf = new JavaProjectGenerator.SourceFolder();
            File sourceLoc = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)possibleSrcRoot));
            sf.location = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)sourceLoc);
            sf.type = "java";
            sf.style = "packages";
            sf.label = SourceFoldersPanel.getDefaultLabel(sf.location, false);
            sf.encoding = this.model.getEncoding();
            srcFolders.add(sf);
        }
        return srcFolders;
    }

    private class SourcesModel
    extends AbstractTableModel {
        private boolean tests;

        public SourcesModel(boolean tests) {
            this.tests = tests;
        }

        @Override
        public int getColumnCount() {
            return SourceFoldersPanel.this.isWizard ? 1 : 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_Package");
                }
            }
            return NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_Label");
        }

        @Override
        public int getRowCount() {
            if (SourceFoldersPanel.this.model == null) {
                return 0;
            }
            int count = 0;
            for (int i = 0; i < SourceFoldersPanel.this.model.getSourceFoldersCount(); ++i) {
                JavaProjectGenerator.SourceFolder sf = SourceFoldersPanel.this.model.getSourceFolder(i);
                boolean isTest = SourceFoldersPanel.this.model.isTestSourceFolder(sf);
                if (this.tests && isTest) {
                    ++count;
                }
                if (this.tests || isTest) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String loc = ((SourceFoldersPanel)SourceFoldersPanel.this).getItem((int)rowIndex, (boolean)this.tests).location;
                loc = SourceFoldersPanel.getLocationDisplayName(SourceFoldersPanel.this.model.getEvaluator(), SourceFoldersPanel.this.model.getNBProjectFolder(), loc);
                return loc;
            }
            return ((SourceFoldersPanel)SourceFoldersPanel.this).getItem((int)rowIndex, (boolean)this.tests).label;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public void setValueAt(Object val, int rowIndex, int columnIndex) {
            JavaProjectGenerator.SourceFolder sf = SourceFoldersPanel.this.getItem(rowIndex, this.tests);
            sf.label = (String)val;
            if (sf.label.length() == 0) {
                sf.label = SourceFoldersPanel.getDefaultLabel(sf.location, this.tests);
            }
        }
    }

    private class ToolTipRenderer
    extends DefaultTableCellRenderer {
        private ToolTipRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JComponent) {
                ((JComponent)c).setToolTipText((String)value);
            }
            return c;
        }
    }

    private static class WarningDlg
    extends JPanel {
        public WarningDlg(Set invalidRoots) {
            this.initGui(invalidRoots);
        }

        private void initGui(Set invalidRoots) {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(SourceFoldersPanel.class, (String)"LBL_InvalidRoot"));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 1.0;
            c.insets = new Insets(12, 0, 6, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            JList<Object> roots = new JList<Object>(invalidRoots.toArray());
            roots.setCellRenderer(new InvalidRootRenderer(true));
            JScrollPane p = new JScrollPane(roots);
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 1;
            c.anchor = 18;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.insets = new Insets(0, 0, 12, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(p, c);
            this.add(p);
            label.setLabelFor(roots);
            roots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"AD_InvalidRoot"));
            JLabel label2 = new JLabel();
            label2.setText(NbBundle.getMessage(SourceFoldersPanel.class, (String)"MSG_InvalidRoot2"));
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(label2, c);
            this.add(label2);
        }

        private static class InvalidRootRenderer
        extends DefaultListCellRenderer {
            private boolean projectConflict;

            public InvalidRootRenderer(boolean projectConflict) {
                this.projectConflict = projectConflict;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Project p;
                File f = (File)value;
                String message = f.getAbsolutePath();
                if (this.projectConflict && (p = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)f))) != null) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    String projectName = pi.getDisplayName();
                    message = NbBundle.getMessage(SourceFoldersPanel.class, (String)"TXT_RootOwnedByProject", (Object)message, (Object)projectName);
                }
                return super.getListCellRendererComponent((JList<?>)list, message, index, isSelected, cellHasFocus);
            }
        }
    }

    private class FolderComparator
    implements Comparator {
        private FolderComparator() {
        }

        public int compare(Object o1, Object o2) throws ClassCastException {
            if (!(o1 instanceof JavaProjectGenerator.SourceFolder) || !(o2 instanceof JavaProjectGenerator.SourceFolder)) {
                throw new ClassCastException();
            }
            return ((JavaProjectGenerator.SourceFolder)o1).location.compareTo(((JavaProjectGenerator.SourceFolder)o2).location);
        }
    }
}

