/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.modules.j2ee.ejbverification.fixes.ExposeBusinessMethod;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;

public class BusinessMethodExposed {
    private static final Logger LOG = Logger.getLogger(BusinessMethodExposed.class.getName());

    private BusinessMethodExposed() {
    }

    public static Collection<ErrorDescription> run(HintContext hintContext) {
        ArrayList<ErrorDescription> problems = new ArrayList<ErrorDescription>();
        EJBProblemContext ctx = HintsUtils.getOrCacheContext(hintContext);
        if (ctx != null && ctx.getEjb() instanceof Session) {
            ArrayList<TypeElement> localInterfaces = null;
            ArrayList<TypeElement> remoteInterfaces = null;
            EjbJar ejbModule = ctx.getEjbModule();
            Profile profile = ejbModule.getJ2eeProfile();
            if (profile != null && profile.isAtLeast(Profile.JAVA_EE_6_WEB)) {
                int intfCount = ctx.getEjbData().getBusinessLocal().length + ctx.getEjbData().getBusinessRemote().length;
                localInterfaces = new ArrayList<TypeElement>(BusinessMethodExposed.resolveClasses(hintContext.getInfo(), ctx.getEjbData().getBusinessLocal()));
                remoteInterfaces = new ArrayList<TypeElement>(BusinessMethodExposed.resolveClasses(hintContext.getInfo(), ctx.getEjbData().getBusinessRemote()));
                if (intfCount == 0 || JavaUtils.hasAnnotation(ctx.getClazz(), "javax.ejb.LocalBean") || JavaUtils.hasAnnotation(ctx.getClazz(), "jakarta.ejb.LocalBean")) {
                    return null;
                }
            }
            if (JavaUtils.hasAnnotation(ctx.getClazz(), "javax.jws.WebService") || JavaUtils.hasAnnotation(ctx.getClazz(), "jakarta.jws.WebService")) {
                return null;
            }
            if (localInterfaces == null) {
                localInterfaces = new ArrayList<TypeElement>(BusinessMethodExposed.resolveClasses(hintContext.getInfo(), ctx.getEjbData().getBusinessLocal()));
            }
            if (remoteInterfaces == null) {
                remoteInterfaces = new ArrayList<TypeElement>(BusinessMethodExposed.resolveClasses(hintContext.getInfo(), ctx.getEjbData().getBusinessRemote()));
            }
            ArrayList<ExecutableElement> definedMethods = new ArrayList<ExecutableElement>();
            for (TypeElement iface : localInterfaces) {
                definedMethods.addAll(ElementFilter.methodsIn(iface.getEnclosedElements()));
            }
            for (TypeElement iface : remoteInterfaces) {
                definedMethods.addAll(ElementFilter.methodsIn(iface.getEnclosedElements()));
            }
            HashMap definedMethodsByName = new HashMap();
            for (ExecutableElement method : definedMethods) {
                String hashName = method.getSimpleName().toString();
                if (!definedMethodsByName.containsKey(hashName)) {
                    definedMethodsByName.put(hashName, new ArrayList(1));
                }
                ((ArrayList)definedMethodsByName.get(hashName)).add(method);
            }
            for (ExecutableElement method : ElementFilter.methodsIn(ctx.getClazz().getEnclosedElements())) {
                ExposeBusinessMethod fix;
                ArrayList potentialMatches;
                if (!BusinessMethodExposed.isEligibleMethod(method) || (potentialMatches = (ArrayList)definedMethodsByName.get(method.getSimpleName().toString())) != null && !potentialMatches.isEmpty() && BusinessMethodExposed.isFoundMatchingMethodSignature(hintContext.getInfo(), method, potentialMatches)) continue;
                ArrayList<Fix> fixes = new ArrayList<Fix>();
                for (TypeElement iface : localInterfaces) {
                    fix = new ExposeBusinessMethod(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)iface), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)method), true);
                    fixes.add(fix);
                }
                for (TypeElement iface : remoteInterfaces) {
                    fix = new ExposeBusinessMethod(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)iface), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)method), false);
                    fixes.add(fix);
                }
                ErrorDescription err = HintsUtils.createProblem((Element)method, hintContext.getInfo(), Bundle.BusinessMethodExposed_hint(), Severity.HINT, fixes);
                problems.add(err);
            }
            return problems;
        }
        return problems;
    }

    private static boolean isFoundMatchingMethodSignature(CompilationInfo cinfo, ExecutableElement method, ArrayList<ExecutableElement> potentialMatches) {
        for (ExecutableElement potentialMatch : potentialMatches) {
            if (!JavaUtils.isMethodSignatureSame(cinfo, method, potentialMatch)) continue;
            return true;
        }
        return false;
    }

    private static Collection<TypeElement> resolveClasses(CompilationInfo info, String[] classNames) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        if (classNames != null) {
            for (String className : classNames) {
                TypeElement clazz = info.getElements().getTypeElement(className);
                if (clazz == null) continue;
                result.add(clazz);
                BusinessMethodExposed.addInterfaces(info, result, clazz.getInterfaces());
            }
        }
        return result;
    }

    private static void addInterfaces(CompilationInfo info, Collection<TypeElement> result, List<? extends TypeMirror> interfaces) {
        for (TypeMirror typeMirror : interfaces) {
            TypeElement te = (TypeElement)info.getTypes().asElement(typeMirror);
            result.add(te);
            BusinessMethodExposed.addInterfaces(info, result, te.getInterfaces());
        }
    }

    private static boolean isEligibleMethod(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && HintsUtils.isContainingKnownClasses(method);
    }
}

