/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ConstantDeclaration
extends BodyDeclaration {
    private final ArrayList<Identifier> names = new ArrayList();
    private final ArrayList<Expression> initializers = new ArrayList();
    private final boolean isGlobal;
    @NullAllowed
    private final Expression constType;

    private ConstantDeclaration(int start, int end, int modifier, Expression constType, List<Identifier> names, List<Expression> initializers, boolean isGlobal, List<Attribute> attributes) {
        super(start, end, modifier, false, attributes);
        this.constType = constType;
        this.names.addAll(names);
        this.initializers.addAll(initializers);
        this.isGlobal = isGlobal;
    }

    private ConstantDeclaration(int start, int end, int modifier, Expression constType, List variablesAndDefaults, boolean isGlobal) {
        super(start, end, modifier);
        this.constType = constType;
        if (variablesAndDefaults == null || variablesAndDefaults.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (ASTNode[] element : variablesAndDefaults) {
            assert (element != null && element.length == 2 && element[0] != null && element[1] != null);
            this.names.add((Identifier)element[0]);
            this.initializers.add((Expression)element[1]);
        }
        this.isGlobal = isGlobal;
    }

    public ConstantDeclaration(int start, int end, int modifier, List variablesAndDefaults, boolean isGlobal) {
        this(start, end, modifier, null, variablesAndDefaults, isGlobal);
    }

    public static ConstantDeclaration create(int start, int end, int modifier, @NullAllowed Expression constType, List variablesAndDefaults, boolean isGlobal) {
        return new ConstantDeclaration(start, end, modifier, constType, variablesAndDefaults, isGlobal);
    }

    public static ConstantDeclaration create(ConstantDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new ConstantDeclaration(start, declaration.getEndOffset(), declaration.getModifier(), declaration.getConstType(), declaration.getNames(), declaration.getInitializers(), declaration.isGlobal(), attributes);
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public List<Expression> getInitializers() {
        return Collections.unmodifiableList(this.initializers);
    }

    public List<Identifier> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    @CheckForNull
    public Expression getConstType() {
        return this.constType;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.names.size(); ++i) {
            Expression initializer = this.initializers.get(i);
            sb.append(this.names.get(i)).append(" = ").append(initializer).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sbAttributes.toString() + (String)(!this.getModifierString().isEmpty() ? this.getModifierString() + " " : "") + "const " + (String)(this.getConstType() != null ? VariousUtils.getDeclaredType(this.getConstType()) + " " : "") + sb;
    }
}

