/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

final class CompletionContextFinder {
    private static final String NAMESPACE_FALSE_TOKEN = "NAMESPACE_FALSE_TOKEN";
    private static final String GROUP_USE_STATEMENT_TOKENS = "GROUP_USE_STATEMENT_TOKENS";
    private static final String MULTI_CATCH_EXCEPTION_TOKENS = "MULTI_CATCH_EXCEPTION_TOKENS";
    private static final String COMBINED_USE_STATEMENT_TOKENS = "COMBINED_USE_STATEMENT_TOKENS";
    private static final String CONST_STATEMENT_TOKENS = "CONST_STATEMENT_TOKENS";
    private static final String CONST_DECLARED_TYPE_TOKENS = "CONST_DECLARED_TYPE_TOKENS";
    private static final String ENUM_CASE_STATEMENT_TOKENS = "ENUM_CASE_STATEMENT_TOKENS";
    private static final String FIELD_UNION_OR_INTERSECTION_TYPE_TOKENS = "FIELD_UNION_TYPE_TOKENS";
    private static final String FIELD_MODIFIERS_TOKENS = "FIELD_MODIFIERS_TOKENS";
    private static final String OBJECT_OPERATOR_TOKEN = "OBJECT_OPERATOR_TOKEN";
    private static final String TYPE_KEYWORD = "TYPE_KEYWORD";
    private static final PHPTokenId[] COMMENT_TOKENS = new PHPTokenId[]{PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_COMMENT_END};
    private static final PHPTokenId[] PHPDOC_TOKENS = new PHPTokenId[]{PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END};
    private static final List<Object[]> CLASS_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_NEW}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> THROW_TOKEN_CHAINS = Arrays.asList({PHPTokenId.PHP_THROW}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> THROW_NEW_TOKEN_CHAINS = Arrays.asList({PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> FUNCTION_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> GROUP_USE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", "GROUP_USE_STATEMENT_TOKENS"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", PHPTokenId.WHITESPACE, "GROUP_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> GROUP_USE_CONST_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", "GROUP_USE_STATEMENT_TOKENS"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", PHPTokenId.WHITESPACE, "GROUP_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> GROUP_USE_FUNCTION_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", "GROUP_USE_STATEMENT_TOKENS"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", PHPTokenId.WHITESPACE, "GROUP_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> USE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_USE, "COMBINED_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> USE_CONST_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, "COMBINED_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> USE_FUNCTION_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, "COMBINED_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> NAMESPACE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_NAMESPACE}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"});
    private static final List<Object[]> INSTANCEOF_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_INSTANCEOF}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CATCH_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_CATCH, "MULTI_CATCH_EXCEPTION_TOKENS"}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, "MULTI_CATCH_EXCEPTION_TOKENS"});
    private static final List<Object[]> CLASS_MEMBER_TOKENCHAINS = Arrays.asList({"OBJECT_OPERATOR_TOKEN"}, {"OBJECT_OPERATOR_TOKEN", PHPTokenId.PHP_STRING}, {"OBJECT_OPERATOR_TOKEN", PHPTokenId.PHP_VARIABLE}, {"OBJECT_OPERATOR_TOKEN", PHPTokenId.PHP_TOKEN}, {"OBJECT_OPERATOR_TOKEN", PHPTokenId.WHITESPACE}, {"OBJECT_OPERATOR_TOKEN", PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {"OBJECT_OPERATOR_TOKEN", PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {"OBJECT_OPERATOR_TOKEN", PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final List<Object[]> STATIC_CLASS_MEMBER_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final List<Object[]> CLASS_MEMBER_IN_STRING_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, "OBJECT_OPERATOR_TOKEN"}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, "OBJECT_OPERATOR_TOKEN", PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, "OBJECT_OPERATOR_TOKEN", PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, "OBJECT_OPERATOR_TOKEN", PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, "OBJECT_OPERATOR_TOKEN", PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, "OBJECT_OPERATOR_TOKEN", PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final List<Object[]> METHOD_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> FIELD_TYPE_TOKENCHAINS = Arrays.asList({"FIELD_MODIFIERS_TOKENS", PHPTokenId.WHITESPACE, "FIELD_MODIFIERS_TOKENS"}, {"FIELD_MODIFIERS_TOKENS", PHPTokenId.WHITESPACE, "FIELD_MODIFIERS_TOKENS", PHPTokenId.WHITESPACE}, {"FIELD_MODIFIERS_TOKENS", PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {"FIELD_MODIFIERS_TOKENS", PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}, {"FIELD_MODIFIERS_TOKENS", PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, "NAMESPACE_FALSE_TOKEN"}, {"FIELD_MODIFIERS_TOKENS", PHPTokenId.WHITESPACE, "FIELD_UNION_TYPE_TOKENS"});
    private static final List<Object[]> CLASS_CONTEXT_KEYWORDS_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_PRIVATE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PROTECTED}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PUBLIC}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PRIVATE_SET}, {PHPTokenId.PHP_PRIVATE_SET, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PRIVATE_SET, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PROTECTED_SET}, {PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PUBLIC_SET}, {PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_STATIC}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ABSTRACT}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_FINAL}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_READONLY}, {PHPTokenId.PHP_READONLY, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_READONLY, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.WHITESPACE}, {PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_CLOSE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_SEMICOLON}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CONST_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, "CONST_STATEMENT_TOKENS"}, {PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, "CONST_STATEMENT_TOKENS"}, {PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "CONST_DECLARED_TYPE_TOKENS", PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, "CONST_STATEMENT_TOKENS"}, {PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "CONST_DECLARED_TYPE_TOKENS", PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, "CONST_STATEMENT_TOKENS"});
    private static final List<Object[]> CONST_TYPE_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_CONST}, {PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "CONST_DECLARED_TYPE_TOKENS"});
    private static final List<Object[]> CONST_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "CONST_DECLARED_TYPE_TOKENS", PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "CONST_DECLARED_TYPE_TOKENS", PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> ENUM_CASE_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_CASE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE, "CONST_STATEMENT_TOKENS"}, {PHPTokenId.PHP_CASE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING, "CONST_STATEMENT_TOKENS"});
    private static final List<Object[]> SERVER_ARRAY_TOKENCHAINS = Collections.singletonList(new Object[]{PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_TOKEN});
    private static final List<String> SERVER_ARRAY_TOKENTEXTS = Arrays.asList("$_SERVER", "[");
    private static final Set<PHPTokenId> BUILT_IN_TYPES = Set.of(PHPTokenId.PHP_TYPE_BOOL, PHPTokenId.PHP_TYPE_FLOAT, PHPTokenId.PHP_TYPE_INT, PHPTokenId.PHP_TYPE_STRING, PHPTokenId.PHP_TYPE_VOID, PHPTokenId.PHP_TYPE_NEVER, PHPTokenId.PHP_TYPE_OBJECT, PHPTokenId.PHP_TYPE_MIXED, PHPTokenId.PHP_SELF, PHPTokenId.PHP_PARENT, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_NULL, PHPTokenId.PHP_FALSE, PHPTokenId.PHP_TRUE, PHPTokenId.PHP_ARRAY, PHPTokenId.PHP_ITERABLE, PHPTokenId.PHP_CALLABLE);
    private static final Set<PHPTokenId> FIELD_MODIFIERS = Set.of(PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.PHP_PRIVATE_SET, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_READONLY, PHPTokenId.PHP_FINAL, PHPTokenId.PHP_VAR);
    private static final Set<PHPTokenId> VISIBILITY_MODIFIERS = Set.of(PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_PRIVATE);
    private static final Set<PHPTokenId> SET_VISIBILITY_MODIFIERS = Set.of(PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.PHP_PRIVATE_SET);
    static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.T_OPEN_TAG_WITH_ECHO, PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_CASTING);

    private CompletionContextFinder() {
    }

    @NonNull
    static CompletionContext findCompletionContext(ParserResult info, int caretOffset) {
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return CompletionContext.NONE;
        }
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, caretOffset);
        if (tokenSequence == null) {
            return CompletionContext.NONE;
        }
        tokenSequence.move(caretOffset);
        boolean moveNextSucces = tokenSequence.moveNext();
        if (!moveNextSucces && !tokenSequence.movePrevious()) {
            return CompletionContext.NONE;
        }
        Token token = tokenSequence.token();
        PHPTokenId tokenId = (PHPTokenId)token.id();
        if (tokenId.equals((Object)PHPTokenId.PHP_CLOSETAG) && tokenSequence.offset() < caretOffset) {
            return CompletionContext.NONE;
        }
        int tokenIdOffset = tokenSequence.token().offset(th);
        CompletionContext clsIfaceDeclContext = CompletionContextFinder.getClsIfaceDeclContext((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, tokenSequence);
        if (clsIfaceDeclContext != null) {
            return clsIfaceDeclContext;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, THROW_TOKEN_CHAINS, moveNextSucces)) {
            return CompletionContext.THROW;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, THROW_NEW_TOKEN_CHAINS, moveNextSucces)) {
            return CompletionContext.THROW_NEW;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_NAME_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.NEW_CLASS;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_MEMBER_IN_STRING_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.CLASS_MEMBER_IN_STRING;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_MEMBER_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.CLASS_MEMBER;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, STATIC_CLASS_MEMBER_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.STATIC_CLASS_MEMBER;
        }
        if (tokenId == PHPTokenId.PHP_COMMENT) {
            return CompletionContextFinder.getCompletionContextInComment(tokenSequence, caretOffset, info);
        }
        if (CompletionContextFinder.isPhpDocToken(tokenSequence)) {
            return CompletionContext.PHPDOC;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CATCH_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.CATCH;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, NAMESPACE_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.NAMESPACE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, INSTANCEOF_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.TYPE_NAME;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, GROUP_USE_KEYWORD_TOKENS, moveNextSucces)) {
            while (tokenSequence.movePrevious()) {
                tokenId = (PHPTokenId)tokenSequence.token().id();
                if (tokenId == PHPTokenId.WHITESPACE) continue;
                if (tokenId == PHPTokenId.PHP_CONST) {
                    return CompletionContext.GROUP_USE_CONST_KEYWORD;
                }
                if (tokenId != PHPTokenId.PHP_FUNCTION) break;
                return CompletionContext.GROUP_USE_FUNCTION_KEYWORD;
            }
            return CompletionContext.GROUP_USE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, GROUP_USE_CONST_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.GROUP_USE_CONST_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, GROUP_USE_FUNCTION_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.GROUP_USE_FUNCTION_KEYWORD;
        }
        if (CompletionContextFinder.isInAttribute(caretOffset, tokenSequence, true)) {
            if (CompletionContextFinder.isInAttribute(caretOffset, tokenSequence, false)) {
                return CompletionContext.ATTRIBUTE;
            }
            CompletionContext namedArgumentsContext = CompletionContextFinder.getNamedArgumentsContext(caretOffset, tokenSequence);
            if (namedArgumentsContext != null) {
                return namedArgumentsContext;
            }
            return CompletionContext.ATTRIBUTE_EXPRESSION;
        }
        if (CompletionContextFinder.isInsideInterfaceDeclarationBlock(info, caretOffset, tokenSequence)) {
            CompletionContext paramContext = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, caretOffset, tokenSequence);
            if (paramContext != null) {
                return paramContext;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CONST_TYPE_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.CONST_TYPE_NAME;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CONST_NAME_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.NONE;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CONST_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.CLASS_CONST_EXPRESSION;
            }
            return CompletionContext.INTERFACE_CONTEXT_KEYWORDS;
        }
        if (CompletionContextFinder.isInsideClassOrTraitOrEnumDeclarationBlock(info, caretOffset, tokenSequence)) {
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_KEYWORD_TOKENS, moveNextSucces)) {
                return CompletionContext.USE_TRAITS;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, METHOD_NAME_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.METHOD_NAME;
            }
            CompletionContext paramContext = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, caretOffset, tokenSequence);
            if (paramContext != null) {
                return paramContext;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, FIELD_TYPE_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.FIELD_TYPE_NAME;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CONST_TYPE_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.CONST_TYPE_NAME;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CONST_NAME_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.NONE;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CONST_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.CLASS_CONST_EXPRESSION;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, ENUM_CASE_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.ENUM_CASE_EXPRESSION;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_CONTEXT_KEYWORDS_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.CLASS_CONTEXT_KEYWORDS;
            }
            return CompletionContext.NONE;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.USE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_CONST_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.USE_CONST_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_FUNCTION_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.USE_FUNCTION_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, FUNCTION_NAME_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.NONE;
        }
        if (CompletionContextFinder.isCommonCommentToken(tokenSequence)) {
            return CompletionContext.NONE;
        }
        switch (tokenId) {
            case T_INLINE_HTML: {
                return CompletionContext.HTML;
            }
            case PHP_CONSTANT_ENCAPSED_STRING: {
                char encChar = tokenSequence.token().text().charAt(0);
                if (encChar == '\"') {
                    if (CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS, moveNextSucces) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                        return CompletionContext.SERVER_ENTRY_CONSTANTS;
                    }
                    return CompletionContext.STRING;
                }
                if (encChar == '\'' && CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS, moveNextSucces) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                    return CompletionContext.SERVER_ENTRY_CONSTANTS;
                }
                return CompletionContext.NONE;
            }
        }
        if (CompletionContextFinder.isEachOfTokens(CompletionContextFinder.getLeftPreceedingTokens(tokenSequence), new PHPTokenId[]{PHPTokenId.PHP_GLOBAL, PHPTokenId.WHITESPACE}) || CompletionContextFinder.isWhiteSpace((Token<PHPTokenId>)token) && CompletionContextFinder.isEachOfTokens(CompletionContextFinder.getLeftPreceedingTokens(tokenSequence), new PHPTokenId[]{PHPTokenId.PHP_GLOBAL})) {
            return CompletionContext.GLOBAL;
        }
        CompletionContext paramContext = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, caretOffset, tokenSequence);
        if (paramContext != null) {
            return paramContext;
        }
        CompletionContext namedArgumentsContext = CompletionContextFinder.getNamedArgumentsContext(caretOffset, tokenSequence);
        if (namedArgumentsContext != null) {
            return namedArgumentsContext;
        }
        if (tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.PHP_OPENTAG && TokenUtilities.textEquals((CharSequence)"<?", (CharSequence)tokenSequence.token().text()) && tokenSequence.offset() + 2 == caretOffset) {
            return CompletionContext.OPEN_TAG;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CONST_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.GLOBAL_CONST_EXPRESSION;
        }
        if (CompletionContextFinder.isInMatchExpression(caretOffset, tokenSequence)) {
            return CompletionContext.MATCH_EXPRESSION;
        }
        return CompletionContext.EXPRESSION;
    }

    private static boolean isPhpDocToken(TokenSequence<PHPTokenId> tokenSequence) {
        return CompletionContextFinder.isOneOfTokens(tokenSequence, PHPDOC_TOKENS);
    }

    private static boolean isCommonCommentToken(TokenSequence<PHPTokenId> tokenSequence) {
        return CompletionContextFinder.isOneOfTokens(tokenSequence, COMMENT_TOKENS);
    }

    private static boolean isCommentToken(TokenSequence<PHPTokenId> tokenSequence) {
        return CompletionContextFinder.isCommonCommentToken(tokenSequence) || CompletionContextFinder.isPhpDocToken(tokenSequence);
    }

    private static boolean isOneOfTokens(TokenSequence<PHPTokenId> tokenSequence, PHPTokenId[] tokenIds) {
        TokenId searchedId = tokenSequence.token().id();
        for (PHPTokenId tokenId : tokenIds) {
            if (!((Object)((Object)tokenId)).equals(searchedId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEachOfTokens(Token<PHPTokenId>[] tokens, PHPTokenId[] tokenIds) {
        EnumSet<PHPTokenId> set = EnumSet.noneOf(PHPTokenId.class);
        for (Token<PHPTokenId> token : tokens) {
            TokenId searchedId = token.id();
            for (PHPTokenId tokenId : tokenIds) {
                if (!tokenId.equals(searchedId)) continue;
                set.add(tokenId);
            }
        }
        return set.size() == tokenIds.length;
    }

    private static boolean acceptTokenChainTexts(TokenSequence<PHPTokenId> tokenSequence, List<String> tokenTexts) {
        int orgTokenSequencePos = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = tokenSequence.movePrevious();
        for (int i = tokenTexts.size() - 1; i >= 0; --i) {
            String tokenTxt = tokenTexts.get(i);
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (!TokenUtilities.textEquals((CharSequence)tokenTxt, (CharSequence)tokenSequence.token().text())) {
                accept = false;
                break;
            }
            moreTokens = tokenSequence.movePrevious();
        }
        tokenSequence.move(orgTokenSequencePos);
        tokenSequence.moveNext();
        return accept;
    }

    private static boolean acceptTokenChains(TokenSequence<PHPTokenId> tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!CompletionContextFinder.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptTokenChain(TokenSequence<PHPTokenId> tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        int orgTokenSequencePos = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        boolean lastTokenWasComment = false;
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenID = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenID instanceof PHPTokenId) {
                if (CompletionContextFinder.isCommentToken(tokenSequence)) {
                    ++i;
                    moreTokens = tokenSequence.movePrevious();
                    lastTokenWasComment = true;
                    continue;
                }
                if (tokenSequence.token().id() == PHPTokenId.WHITESPACE && lastTokenWasComment) {
                    ++i;
                    moreTokens = tokenSequence.movePrevious();
                    lastTokenWasComment = false;
                    continue;
                }
                lastTokenWasComment = false;
                if (tokenSequence.token().id() == tokenID) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            if (tokenID == NAMESPACE_FALSE_TOKEN) {
                if (CompletionContextFinder.consumeNameSpace(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == GROUP_USE_STATEMENT_TOKENS) {
                if (CompletionContextFinder.consumeClassesConstFunctionInGroupUse(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == MULTI_CATCH_EXCEPTION_TOKENS) {
                if (CompletionContextFinder.consumeMultiCatchExceptions(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == FIELD_MODIFIERS_TOKENS) {
                if (!CompletionContextFinder.isFieldModifier((Token<PHPTokenId>)tokenSequence.token())) {
                    accept = false;
                    break;
                }
                moreTokens = tokenSequence.movePrevious();
                continue;
            }
            if (tokenID == FIELD_UNION_OR_INTERSECTION_TYPE_TOKENS) {
                if (CompletionContextFinder.consumeFieldDeclaredTypes(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == COMBINED_USE_STATEMENT_TOKENS) {
                if (CompletionContextFinder.consumeClassesInCombinedUse(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == TYPE_KEYWORD) {
                if (CompletionContextFinder.consumeUntilTypeKeyword(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == CONST_STATEMENT_TOKENS) {
                if (CompletionContextFinder.consumeUntilConstEqual(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == CONST_DECLARED_TYPE_TOKENS) {
                if (CompletionContextFinder.consumeConstDeclaredTypes(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == ENUM_CASE_STATEMENT_TOKENS) {
                if (CompletionContextFinder.consumeUntilEnumCaseEqual(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == OBJECT_OPERATOR_TOKEN) {
                if (!CompletionContextFinder.consumeObjectOperator(tokenSequence)) {
                    accept = false;
                    break;
                }
                moreTokens = tokenSequence.movePrevious();
                continue;
            }
            assert (false) : "Unsupported token type: " + tokenID.getClass().getName();
        }
        tokenSequence.move(orgTokenSequencePos);
        tokenSequence.moveNext();
        return accept;
    }

    private static boolean consumeNameSpace(TokenSequence tokenSequence) {
        boolean hadNSSeparator = false;
        if (tokenSequence.token().id() != PHPTokenId.PHP_NS_SEPARATOR && tokenSequence.token().id() != PHPTokenId.PHP_STRING) {
            return false;
        }
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_NS_SEPARATOR || tokenSequence.token().id() == PHPTokenId.PHP_STRING) {
                hadNSSeparator = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (tokenSequence.token().id() == PHPTokenId.PHP_NS_SEPARATOR || tokenSequence.token().id() == PHPTokenId.PHP_STRING);
        return hadNSSeparator;
    }

    private static boolean consumeComment(TokenSequence<PHPTokenId> tokenSequence) {
        while (tokenSequence.token().id() == PHPTokenId.PHP_COMMENT_START || tokenSequence.token().id() == PHPTokenId.PHP_COMMENT_END || tokenSequence.token().id() == PHPTokenId.PHP_COMMENT) {
            if (tokenSequence.movePrevious()) continue;
            return false;
        }
        return true;
    }

    private static boolean consumeClassesConstFunctionInGroupUse(TokenSequence<PHPTokenId> tokenSequence) {
        if (tokenSequence.token().id() != PHPTokenId.PHP_CURLY_OPEN && tokenSequence.token().id() != PHPTokenId.PHP_TOKEN && tokenSequence.token().id() != PHPTokenId.PHP_CONST && tokenSequence.token().id() != PHPTokenId.PHP_FUNCTION && tokenSequence.token().id() != PHPTokenId.WHITESPACE && !CompletionContextFinder.consumeNameSpace(tokenSequence)) {
            return false;
        }
        boolean hasCurlyOpen = false;
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_USE) {
                return false;
            }
            if (tokenSequence.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                hasCurlyOpen = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (!hasCurlyOpen && (tokenSequence.token().id() == PHPTokenId.PHP_CURLY_OPEN || tokenSequence.token().id() == PHPTokenId.PHP_TOKEN || tokenSequence.token().id() == PHPTokenId.PHP_CONST || tokenSequence.token().id() == PHPTokenId.PHP_FUNCTION || tokenSequence.token().id() == PHPTokenId.WHITESPACE || CompletionContextFinder.consumeNameSpace(tokenSequence) || CompletionContextFinder.consumeComment(tokenSequence)));
        return hasCurlyOpen;
    }

    private static boolean consumeFieldDeclaredTypes(TokenSequence<PHPTokenId> tokenSequence) {
        if (!(CompletionContextFinder.isTypeSeparator((Token<PHPTokenId>)tokenSequence.token()) || tokenSequence.token().id() == PHPTokenId.WHITESPACE || tokenSequence.token().id() == PHPTokenId.PHP_STRING || CompletionContextFinder.isType((Token<PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.consumeNameSpace(tokenSequence))) {
            return false;
        }
        boolean isFieldType = false;
        boolean hasTypeSeparator = false;
        do {
            if (CompletionContextFinder.isTypeSeparator((Token<PHPTokenId>)tokenSequence.token())) {
                hasTypeSeparator = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (CompletionContextFinder.isTypeSeparator((Token<PHPTokenId>)tokenSequence.token()) || tokenSequence.token().id() == PHPTokenId.WHITESPACE || tokenSequence.token().id() == PHPTokenId.PHP_STRING || CompletionContextFinder.isType((Token<PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.consumeNameSpace(tokenSequence));
        if (hasTypeSeparator && CompletionContextFinder.isFieldModifier((Token<PHPTokenId>)tokenSequence.token())) {
            tokenSequence.moveNext();
            isFieldType = true;
        }
        return isFieldType;
    }

    private static boolean consumeConstDeclaredTypes(TokenSequence<PHPTokenId> tokenSequence) {
        if (!(CompletionContextFinder.isTypeSeparator((Token<PHPTokenId>)tokenSequence.token()) || tokenSequence.token().id() == PHPTokenId.WHITESPACE || tokenSequence.token().id() == PHPTokenId.PHP_STRING || CompletionContextFinder.isType((Token<PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.isNullableTypesPrefix((Token<PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.consumeNameSpace(tokenSequence))) {
            return false;
        }
        boolean isConstType = false;
        TokenId lastTokenId = null;
        Token lastTokenExceptForWS = null;
        do {
            if (lastTokenId == PHPTokenId.WHITESPACE && (!CompletionContextFinder.isTypeSeparator((Token<PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.isRightParen((Token<PHPTokenId>)tokenSequence.token()) && !CompletionContextFinder.isVerticalBar(lastTokenExceptForWS))) {
                isConstType = false;
                break;
            }
            lastTokenId = tokenSequence.token().id();
            if (lastTokenId != PHPTokenId.WHITESPACE) {
                lastTokenExceptForWS = tokenSequence.token();
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (CompletionContextFinder.isTypeSeparator((Token<PHPTokenId>)tokenSequence.token()) || tokenSequence.token().id() == PHPTokenId.WHITESPACE || tokenSequence.token().id() == PHPTokenId.PHP_STRING || CompletionContextFinder.isType((Token<PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.isNullableTypesPrefix((Token<PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.consumeNameSpace(tokenSequence));
        if (tokenSequence.token().id() == PHPTokenId.PHP_CONST) {
            tokenSequence.moveNext();
            isConstType = true;
        }
        return isConstType;
    }

    private static boolean isTypeSeparator(Token<PHPTokenId> token) {
        return CompletionContextFinder.isVerticalBar(token) || CompletionContextFinder.isReference(token) || CompletionContextFinder.isLeftParen(token) || CompletionContextFinder.isRightParen(token);
    }

    private static boolean consumeMultiCatchExceptions(TokenSequence<PHPTokenId> tokenSequence) {
        if (tokenSequence.token().id() != PHPTokenId.PHP_OPERATOR && tokenSequence.token().id() != PHPTokenId.PHP_TOKEN && tokenSequence.token().id() != PHPTokenId.WHITESPACE && !CompletionContextFinder.consumeNameSpace(tokenSequence)) {
            return false;
        }
        boolean hasParenOpen = false;
        boolean first = true;
        do {
            if (first) {
                first = false;
                if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                    if (!tokenSequence.movePrevious()) {
                        return false;
                    }
                    if (CompletionContextFinder.consumeNameSpace(tokenSequence)) {
                        return false;
                    }
                }
            }
            if (CompletionContextFinder.isLeftParen((Token<? extends PHPTokenId>)tokenSequence.token())) {
                hasParenOpen = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (!hasParenOpen && (CompletionContextFinder.isVerticalBar((Token<? extends PHPTokenId>)tokenSequence.token()) || CompletionContextFinder.isLeftParen((Token<? extends PHPTokenId>)tokenSequence.token()) || tokenSequence.token().id() == PHPTokenId.WHITESPACE || CompletionContextFinder.consumeNameSpace(tokenSequence)));
        return hasParenOpen;
    }

    private static boolean consumeClassesInCombinedUse(TokenSequence<PHPTokenId> tokenSequence) {
        boolean hasCommaDelimiter = false;
        if (tokenSequence.token().id() != PHPTokenId.PHP_TOKEN && tokenSequence.token().id() != PHPTokenId.WHITESPACE && !CompletionContextFinder.consumeNameSpace(tokenSequence)) {
            return false;
        }
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_TOKEN) {
                hasCommaDelimiter = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (tokenSequence.token().id() == PHPTokenId.PHP_TOKEN || tokenSequence.token().id() == PHPTokenId.WHITESPACE || CompletionContextFinder.consumeNameSpace(tokenSequence));
        return hasCommaDelimiter;
    }

    private static boolean consumeUntilTypeKeyword(TokenSequence<PHPTokenId> tokenSequence) {
        boolean result = false;
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_CLASS || tokenSequence.token().id() == PHPTokenId.PHP_INTERFACE || tokenSequence.token().id() == PHPTokenId.PHP_TRAIT || tokenSequence.token().id() == PHPTokenId.PHP_EXTENDS || tokenSequence.token().id() == PHPTokenId.PHP_IMPLEMENTS) {
                result = true;
                break;
            }
            if (tokenSequence.token().id() != PHPTokenId.PHP_NAMESPACE) continue;
            result = false;
            break;
        } while (tokenSequence.movePrevious());
        return result;
    }

    private static boolean consumeUntilConstEqual(TokenSequence<PHPTokenId> tokenSequence) {
        boolean hasEqual = false;
        while (tokenSequence.token().id() != PHPTokenId.PHP_CONST && tokenSequence.token().id() != PHPTokenId.PHP_SEMICOLON) {
            if (CompletionContextFinder.isEqualSign((Token<PHPTokenId>)tokenSequence.token())) {
                hasEqual = true;
                tokenSequence.movePrevious();
                break;
            }
            if (tokenSequence.movePrevious()) continue;
        }
        return hasEqual;
    }

    private static boolean consumeUntilEnumCaseEqual(TokenSequence<PHPTokenId> tokenSequence) {
        boolean hasEqual = false;
        while (tokenSequence.token().id() != PHPTokenId.PHP_CASE && tokenSequence.token().id() != PHPTokenId.PHP_SEMICOLON) {
            if (CompletionContextFinder.isEqualSign((Token<PHPTokenId>)tokenSequence.token())) {
                hasEqual = true;
                tokenSequence.movePrevious();
                break;
            }
            if (tokenSequence.movePrevious()) continue;
        }
        return hasEqual;
    }

    private static boolean consumeObjectOperator(TokenSequence<PHPTokenId> tokenSequence) {
        boolean result = false;
        do {
            if (!CompletionContextFinder.isObjectOperatorToken((Token<PHPTokenId>)tokenSequence.token())) continue;
            result = true;
            break;
        } while ((CompletionContextFinder.isCommentToken(tokenSequence) || CompletionContextFinder.isWhiteSpace((Token<PHPTokenId>)tokenSequence.token())) && tokenSequence.movePrevious());
        return result;
    }

    private static Token<PHPTokenId>[] getLeftPreceedingTokens(TokenSequence<PHPTokenId> tokenSequence) {
        Token<PHPTokenId>[] preceedingTokens = CompletionContextFinder.getPreceedingTokens(tokenSequence);
        if (preceedingTokens.length == 0) {
            return preceedingTokens;
        }
        Token[] leftPreceedingTokens = new Token[preceedingTokens.length - 1];
        System.arraycopy(preceedingTokens, 1, leftPreceedingTokens, 0, leftPreceedingTokens.length);
        return leftPreceedingTokens;
    }

    private static Token<PHPTokenId>[] getPreceedingTokens(TokenSequence<PHPTokenId> tokenSequence) {
        int orgOffset = tokenSequence.offset();
        LinkedList<Token> tokens = new LinkedList<Token>();
        boolean success = true;
        if (tokenSequence.moveNext()) {
            boolean bl = success = tokenSequence.movePrevious() && tokenSequence.movePrevious();
        }
        if (success) {
            Token token = tokenSequence.token();
            while (token != null && !CTX_DELIMITERS.contains(token.id())) {
                tokens.addFirst(token);
                if (!tokenSequence.movePrevious()) break;
                token = tokenSequence.token();
            }
        }
        tokenSequence.move(orgOffset);
        tokenSequence.moveNext();
        return tokens.toArray(new Token[0]);
    }

    @CheckForNull
    private static CompletionContext getClsIfaceDeclContext(Token<PHPTokenId> token, int tokenOffset, TokenSequence<PHPTokenId> tokenSequence) {
        boolean isNew = false;
        boolean isClass = false;
        boolean isTrait = false;
        boolean isEnum = false;
        int openParenthesis = 0;
        boolean isIface = false;
        boolean isExtends = false;
        boolean isImplements = false;
        boolean isNsSeparator = false;
        boolean isString = false;
        boolean isBackingType = false;
        Token<PHPTokenId> stringToken = null;
        List<? extends Token<PHPTokenId>> preceedingLineTokens = CompletionContextFinder.getPreceedingLineTokens(token, tokenOffset, tokenSequence);
        for (int i = 0; i < preceedingLineTokens.size(); ++i) {
            boolean nokeywords;
            Token<PHPTokenId> cToken = preceedingLineTokens.get(i);
            TokenId tokenId = cToken.id();
            boolean bl = nokeywords = !isIface && !isClass && !isTrait && !isEnum && !isExtends && !isImplements && !isNsSeparator && !isBackingType;
            if (tokenId.equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)cToken.text(), (CharSequence)")")) {
                --openParenthesis;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)cToken.text(), (CharSequence)"(")) {
                ++openParenthesis;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_CLASS)) {
                isClass = true;
                for (int j = i + 1; j < preceedingLineTokens.size(); ++j) {
                    Token<PHPTokenId> tkn = preceedingLineTokens.get(j);
                    if (tkn.id() == PHPTokenId.WHITESPACE) continue;
                    boolean bl2 = isNew = tkn.id() == PHPTokenId.PHP_NEW;
                    break;
                }
                if (!isNew || openParenthesis <= 0) break;
                return null;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_TRAIT)) {
                isTrait = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_ENUM)) {
                isEnum = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_INTERFACE)) {
                isIface = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_EXTENDS)) {
                isExtends = true;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_IMPLEMENTS)) {
                isImplements = true;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_NS_SEPARATOR)) {
                isNsSeparator = true;
                continue;
            }
            if (CompletionContextFinder.isReturnTypeSeparator(cToken)) {
                isBackingType = true;
                continue;
            }
            if (nokeywords && tokenId.equals((Object)PHPTokenId.PHP_STRING)) {
                isString = true;
                stringToken = cToken;
                continue;
            }
            if (!nokeywords || !tokenId.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) continue;
            return null;
        }
        if (isClass || isIface || isTrait || isEnum) {
            if (isImplements) {
                return CompletionContext.INTERFACE_NAME;
            }
            if (isBackingType) {
                if (isString) {
                    return CompletionContext.IMPLEMENTS;
                }
                return CompletionContext.BACKING_TYPE;
            }
            if (isExtends) {
                if (isString && isClass && stringToken != null && tokenOffset == 0 && preceedingLineTokens.size() > 0 && preceedingLineTokens.get(0).text().equals(stringToken.text())) {
                    return CompletionContext.CLASS_NAME;
                }
                if (isString && isClass) {
                    return CompletionContext.IMPLEMENTS;
                }
                if (!isString && isClass) {
                    return CompletionContext.CLASS_NAME;
                }
                if (isIface) {
                    return CompletionContext.INTERFACE_NAME;
                }
                return !isString ? (isClass ? CompletionContext.CLASS_NAME : CompletionContext.INTERFACE_NAME) : (isClass ? CompletionContext.IMPLEMENTS : CompletionContext.INTERFACE_NAME);
            }
            if (isIface) {
                return !isString ? CompletionContext.NONE : CompletionContext.EXTENDS;
            }
            if (isEnum) {
                return !isString ? CompletionContext.NONE : CompletionContext.IMPLEMENTS;
            }
            if (isClass) {
                if (isString || isNew) {
                    return CompletionContext.INHERITANCE;
                }
                return CompletionContext.NONE;
            }
        } else if (isExtends || isImplements) {
            boolean firstString = false;
            for (Token<PHPTokenId> token2 : preceedingLineTokens) {
                TokenId id = token2.id();
                if (id == PHPTokenId.PHP_EXTENDS) {
                    return CompletionContext.CLASS_NAME;
                }
                if (id == PHPTokenId.PHP_IMPLEMENTS) {
                    return CompletionContext.INTERFACE_NAME;
                }
                if (id == PHPTokenId.PHP_STRING) {
                    if (firstString) break;
                    firstString = true;
                    continue;
                }
                if (id == PHPTokenId.WHITESPACE) continue;
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private static CompletionContext getParamaterContext(Token<PHPTokenId> token, int carretOffset, TokenSequence<PHPTokenId> tokenSequence) {
        boolean isFunctionDeclaration = false;
        boolean isCompletionSeparator = false;
        CompletionContext contextForSeparator = null;
        boolean isNamespaceSeparator = false;
        boolean testCompletionSeparator = true;
        boolean checkReturnTypeSeparator = false;
        boolean isUnionOrIntersectionType = false;
        boolean isInConstructor = false;
        int orgOffset = tokenSequence.offset();
        tokenSequence.moveNext();
        boolean first = true;
        while (tokenSequence.movePrevious()) {
            Token cToken = tokenSequence.token();
            PHPTokenId id = (PHPTokenId)cToken.id();
            if (first) {
                first = false;
                if (PHPTokenId.PHP_SEMICOLON.equals((Object)id) || PHPTokenId.PHP_CURLY_OPEN.equals((Object)id) || CompletionContextFinder.isComma(token)) continue;
            }
            if (CompletionContextFinder.isConstructor((Token<PHPTokenId>)cToken)) {
                isInConstructor = true;
            }
            if (CTX_DELIMITERS.contains((Object)id) && !CompletionContextFinder.isReference((Token<PHPTokenId>)cToken) && !CompletionContextFinder.isNew((Token<PHPTokenId>)cToken) && !CompletionContextFinder.isVariadic((Token<PHPTokenId>)cToken) && !CompletionContextFinder.isInitilizerToken((Token<PHPTokenId>)cToken) && !CompletionContextFinder.isVerticalBar((Token<? extends PHPTokenId>)cToken) && !CompletionContextFinder.isOrOperator((Token<PHPTokenId>)cToken) && !CompletionContextFinder.isAndOperator((Token<PHPTokenId>)cToken)) break;
            if (isFunctionDeclaration) continue;
            if (!isCompletionSeparator && testCompletionSeparator) {
                if (CompletionContextFinder.isEqualSign((Token<PHPTokenId>)cToken)) {
                    isCompletionSeparator = true;
                    contextForSeparator = CompletionContext.DEFAULT_PARAMETER_VALUE;
                    continue;
                }
                if (CompletionContextFinder.isParamSeparator((Token<PHPTokenId>)cToken)) {
                    isCompletionSeparator = true;
                    contextForSeparator = CompletionContext.VISIBILITY_MODIFIER_OR_TYPE_NAME;
                    continue;
                }
                if (CompletionContextFinder.isArray(token) || CompletionContextFinder.isCallable(token) || CompletionContextFinder.isIterable(token) || CompletionContextFinder.isNullableTypesPrefix((Token<PHPTokenId>)cToken) || CompletionContextFinder.isVerticalBar((Token<? extends PHPTokenId>)cToken) || CompletionContextFinder.isReference((Token<PHPTokenId>)cToken) || CompletionContextFinder.isOrOperator((Token<PHPTokenId>)cToken) || CompletionContextFinder.isAndOperator((Token<PHPTokenId>)cToken) || CompletionContextFinder.isVisibilityModifier((Token<PHPTokenId>)cToken) || CompletionContextFinder.isSetVisibilityModifier((Token<PHPTokenId>)cToken) || CompletionContextFinder.isReadonlyModifier((Token<PHPTokenId>)cToken)) {
                    if (CompletionContextFinder.isReference((Token<PHPTokenId>)cToken)) {
                        int origOffset = tokenSequence.offset();
                        try {
                            Token<? extends PHPTokenId> previous = LexUtilities.findPrevious(tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_OPERATOR));
                            if (CompletionContextFinder.isComma(previous) || CompletionContextFinder.isLeftParen(previous)) {
                                int offset = cToken.offset(null) + cToken.text().length();
                                if (carretOffset < offset) continue;
                                testCompletionSeparator = false;
                                continue;
                            }
                        }
                        finally {
                            tokenSequence.move(origOffset);
                            tokenSequence.moveNext();
                            continue;
                        }
                    }
                    isCompletionSeparator = true;
                    if (CompletionContextFinder.isVerticalBar((Token<? extends PHPTokenId>)cToken) || CompletionContextFinder.isOrOperator((Token<PHPTokenId>)cToken) || CompletionContextFinder.isReference((Token<PHPTokenId>)cToken) || CompletionContextFinder.isAndOperator((Token<PHPTokenId>)cToken)) {
                        isUnionOrIntersectionType = true;
                    }
                    contextForSeparator = CompletionContextFinder.isVisibilityModifier(token) || CompletionContextFinder.isVisibilityModifier((Token<PHPTokenId>)cToken) || CompletionContextFinder.isSetVisibilityModifier(token) || CompletionContextFinder.isSetVisibilityModifier((Token<PHPTokenId>)cToken) || CompletionContextFinder.isReadonlyModifier(token) || CompletionContextFinder.isReadonlyModifier((Token<PHPTokenId>)cToken) ? CompletionContext.VISIBILITY_MODIFIER_OR_TYPE_NAME : CompletionContext.TYPE_NAME;
                    checkReturnTypeSeparator = true;
                    continue;
                }
                if (CompletionContextFinder.isReturnTypeSeparator((Token<PHPTokenId>)cToken)) {
                    isCompletionSeparator = true;
                    contextForSeparator = CompletionContext.RETURN_TYPE_NAME;
                    continue;
                }
                if (CompletionContextFinder.isAcceptedPrefix((Token<PHPTokenId>)cToken)) {
                    int offset;
                    if (CompletionContextFinder.isNamespaceSeparator((Token<PHPTokenId>)cToken)) {
                        isNamespaceSeparator = true;
                        continue;
                    }
                    if (!isNamespaceSeparator && CompletionContextFinder.isString((Token<PHPTokenId>)cToken)) {
                        offset = cToken.offset(null) + cToken.text().length();
                        if (carretOffset > offset) {
                            testCompletionSeparator = false;
                        }
                    } else if ((CompletionContextFinder.isReference((Token<PHPTokenId>)cToken) || CompletionContextFinder.isRightParen((Token<PHPTokenId>)cToken) || CompletionContextFinder.isVariable((Token<PHPTokenId>)cToken)) && carretOffset >= (offset = cToken.offset(null) + cToken.text().length())) {
                        testCompletionSeparator = false;
                    }
                    isNamespaceSeparator = false;
                    continue;
                }
                if (CompletionContextFinder.isCommentToken(tokenSequence) || CompletionContextFinder.isNew((Token<PHPTokenId>)cToken)) continue;
                testCompletionSeparator = false;
                continue;
            }
            if (checkReturnTypeSeparator) {
                if (!CompletionContextFinder.isReturnTypeToken((Token<PHPTokenId>)cToken)) {
                    checkReturnTypeSeparator = false;
                } else if (CompletionContextFinder.isVerticalBar((Token<? extends PHPTokenId>)cToken) || CompletionContextFinder.isReference((Token<PHPTokenId>)cToken)) {
                    isUnionOrIntersectionType = true;
                }
                if (!CompletionContextFinder.isReturnTypeSeparator((Token<PHPTokenId>)cToken)) continue;
                contextForSeparator = isUnionOrIntersectionType ? CompletionContext.RETURN_UNION_OR_INTERSECTION_TYPE_NAME : CompletionContext.RETURN_TYPE_NAME;
                continue;
            }
            if (!CompletionContextFinder.isFunctionDeclaration((Token<PHPTokenId>)cToken)) continue;
            isFunctionDeclaration = true;
            if (isInConstructor || contextForSeparator != CompletionContext.VISIBILITY_MODIFIER_OR_TYPE_NAME) break;
            contextForSeparator = CompletionContext.TYPE_NAME;
            break;
        }
        tokenSequence.move(orgOffset);
        tokenSequence.moveNext();
        return isFunctionDeclaration && isCompletionSeparator ? contextForSeparator : (isFunctionDeclaration ? CompletionContext.NONE : null);
    }

    private static boolean isNamespaceSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NS_SEPARATOR);
    }

    private static boolean isFunctionDeclaration(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_FUNCTION) || ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_FN);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isNew(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NEW);
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPERATOR) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"&");
    }

    private static boolean isVariadic(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPERATOR) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"...");
    }

    static boolean isLeftParen(Token<? extends PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"(");
    }

    private static boolean isRightParen(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)")");
    }

    private static boolean isLeftBracket(Token<? extends PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"[");
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"]");
    }

    private static boolean isEqualSign(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPERATOR) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"=");
    }

    private static boolean isParamSeparator(Token<PHPTokenId> token) {
        return CompletionContextFinder.isComma(token) || CompletionContextFinder.isLeftParen(token);
    }

    private static boolean isReturnTypeSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)":");
    }

    static boolean isVerticalBar(Token<? extends PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"|");
    }

    private static boolean isOrOperator(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"||");
    }

    private static boolean isAndOperator(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"&&");
    }

    private static boolean isNullableTypesPrefix(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"?");
    }

    private static boolean isMinus(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPERATOR) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"-");
    }

    private static boolean isQuoteString(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && (TokenUtilities.startsWith((CharSequence)token.text(), (CharSequence)"'") || TokenUtilities.startsWith((CharSequence)token.text(), (CharSequence)"\""));
    }

    private static boolean isArray(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_ARRAY);
    }

    private static boolean isCallable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_CALLABLE);
    }

    private static boolean isIterable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_ITERABLE);
    }

    private static boolean isAcceptedPrefix(Token<PHPTokenId> token) {
        return CompletionContextFinder.isVariable(token) || CompletionContextFinder.isReference(token) || CompletionContextFinder.isRightParen(token) || CompletionContextFinder.isString(token) || CompletionContextFinder.isWhiteSpace(token) || CompletionContextFinder.isNamespaceSeparator(token) || CompletionContextFinder.isType(token);
    }

    private static boolean isFieldModifier(Token<PHPTokenId> token) {
        return FIELD_MODIFIERS.contains(token.id());
    }

    private static boolean isVisibilityModifier(Token<PHPTokenId> token) {
        return VISIBILITY_MODIFIERS.contains(token.id());
    }

    private static boolean isSetVisibilityModifier(Token<PHPTokenId> token) {
        return SET_VISIBILITY_MODIFIERS.contains(token.id());
    }

    private static boolean isReadonlyModifier(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_READONLY;
    }

    private static boolean isConstructor(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_STRING && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"__construct");
    }

    private static boolean isType(Token<PHPTokenId> token) {
        return BUILT_IN_TYPES.contains(token.id());
    }

    static boolean isComma(Token<? extends PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)",");
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    private static boolean isInitilizerToken(Token<PHPTokenId> token) {
        return CompletionContextFinder.isQuoteString(token) || CompletionContextFinder.isEqualSign(token) || CompletionContextFinder.isMinus(token);
    }

    private static boolean isReturnTypeToken(Token<PHPTokenId> token) {
        return CompletionContextFinder.isVerticalBar(token) || CompletionContextFinder.isNullableTypesPrefix(token) || CompletionContextFinder.isType(token) || CompletionContextFinder.isString(token) || CompletionContextFinder.isWhiteSpace(token) || CompletionContextFinder.isNamespaceSeparator(token);
    }

    private static boolean isObjectOperatorToken(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_OBJECT_OPERATOR || token.id() == PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR;
    }

    static boolean lineContainsAny(Token<PHPTokenId> token, int tokenOffset, TokenSequence<PHPTokenId> tokenSequence, List<PHPTokenId> ids) {
        List<? extends Token<PHPTokenId>> preceedingLineTokens = CompletionContextFinder.getPreceedingLineTokens(token, tokenOffset, tokenSequence);
        for (Token<PHPTokenId> token2 : preceedingLineTokens) {
            if (!ids.contains(token2.id())) continue;
            return true;
        }
        return false;
    }

    private static List<? extends Token<PHPTokenId>> getPreceedingLineTokens(Token<PHPTokenId> token, int tokenOffset, TokenSequence<PHPTokenId> tokenSequence) {
        int orgOffset = tokenSequence.offset();
        LinkedList<Token> tokens = new LinkedList<Token>();
        if (token.id() != PHPTokenId.WHITESPACE || TokenUtilities.indexOf((CharSequence)token.text().subSequence(0, Math.min(token.text().length(), tokenOffset)), (int)10) == -1) {
            Token cToken;
            while (tokenSequence.movePrevious() && ((cToken = tokenSequence.token()).id() != PHPTokenId.WHITESPACE || TokenUtilities.indexOf((CharSequence)cToken.text(), (int)10) == -1) && cToken.id() != PHPTokenId.PHP_LINE_COMMENT) {
                tokens.addLast(cToken);
            }
        }
        tokenSequence.move(orgOffset);
        tokenSequence.moveNext();
        return tokens;
    }

    private static synchronized boolean isInsideInterfaceDeclarationBlock(ParserResult info, int caretOffset, TokenSequence<PHPTokenId> tokenSequence) {
        boolean retval = false;
        List<ASTNode> nodePath = NavUtils.underCaret(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset));
        int nodesCount = nodePath.size();
        if (nodesCount > 0) {
            ASTNode lastNode = nodePath.get(nodesCount - 1);
            if (lastNode instanceof Block) {
                if (nodesCount > 1) {
                    lastNode = nodePath.get(nodesCount - 2);
                    retval = lastNode instanceof InterfaceDeclaration ? true : CompletionContextFinder.isUnderInterfaceTokenId(tokenSequence);
                }
            } else {
                retval = CompletionContextFinder.isUnderInterfaceTokenId(tokenSequence);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isUnderInterfaceTokenId(TokenSequence<PHPTokenId> tokenSequence) {
        boolean retval = false;
        int curlyBalance = -1;
        int orgOffset = tokenSequence.offset();
        try {
            while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                TokenId id = token.id();
                if (id.equals((Object)PHPTokenId.PHP_INTERFACE) && curlyBalance == 0) {
                    retval = true;
                } else {
                    if (id.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                        ++curlyBalance;
                        continue;
                    }
                    if (id.equals((Object)PHPTokenId.PHP_CURLY_CLOSE)) {
                        --curlyBalance;
                        continue;
                    }
                    if (!id.equals((Object)PHPTokenId.PHP_CLASS) && !id.equals((Object)PHPTokenId.PHP_WHILE) && !id.equals((Object)PHPTokenId.PHP_IF) && !id.equals((Object)PHPTokenId.PHP_FOR) && !id.equals((Object)PHPTokenId.PHP_FOREACH) && !id.equals((Object)PHPTokenId.PHP_TRY) && !id.equals((Object)PHPTokenId.PHP_CATCH) && !id.equals((Object)PHPTokenId.PHP_FUNCTION)) continue;
                    retval = false;
                }
                break;
            }
        }
        finally {
            tokenSequence.move(orgOffset);
            tokenSequence.moveNext();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isInsideClassOrTraitOrEnumDeclarationBlock(ParserResult info, int caretOffset, TokenSequence<PHPTokenId> tokenSequence) {
        List<ASTNode> nodePath = NavUtils.underCaret(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset));
        boolean methDecl = false;
        boolean funcDecl = false;
        boolean typeDecl = false;
        boolean isTypeInsideFunc = false;
        boolean isFuncInsideType = false;
        for (ASTNode aSTNode : nodePath) {
            if (aSTNode instanceof FunctionDeclaration) {
                funcDecl = true;
                if (!typeDecl) continue;
                isFuncInsideType = true;
                continue;
            }
            if (aSTNode instanceof MethodDeclaration) {
                methDecl = true;
                continue;
            }
            if (!(aSTNode instanceof ClassDeclaration) && !(aSTNode instanceof TraitDeclaration) && !(aSTNode instanceof EnumDeclaration)) continue;
            if (aSTNode.getEndOffset() != caretOffset) {
                typeDecl = true;
                if (!funcDecl) continue;
                isTypeInsideFunc = true;
                continue;
            }
            return false;
        }
        if (funcDecl && !methDecl && !typeDecl) {
            final StringBuilder sb = new StringBuilder();
            new DefaultVisitor(){

                @Override
                public void visit(ASTError astError) {
                    super.visit(astError);
                    sb.append(astError.toString());
                }
            }.scan(Utils.getRoot(info));
            if (sb.length() == 0) {
                return false;
            }
        }
        if (isTypeInsideFunc && !isFuncInsideType) {
            return true;
        }
        int orgOffset = tokenSequence.offset();
        try {
            int curlyOpen = 0;
            int curlyClose = 0;
            while (tokenSequence.movePrevious()) {
                boolean isTypeScope;
                Token token = tokenSequence.token();
                TokenId id = token.id();
                if (id.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                    ++curlyOpen;
                    continue;
                }
                if (id.equals((Object)PHPTokenId.PHP_CURLY_CLOSE)) {
                    ++curlyClose;
                    continue;
                }
                if ((id.equals((Object)PHPTokenId.PHP_FUNCTION) || id.equals((Object)PHPTokenId.PHP_WHILE) || id.equals((Object)PHPTokenId.PHP_IF) || id.equals((Object)PHPTokenId.PHP_FOR) || id.equals((Object)PHPTokenId.PHP_FOREACH) || id.equals((Object)PHPTokenId.PHP_TRY) || id.equals((Object)PHPTokenId.PHP_CATCH)) && curlyOpen > curlyClose) {
                    boolean bl = false;
                    return bl;
                }
                if (!id.equals((Object)PHPTokenId.PHP_CLASS) && !id.equals((Object)PHPTokenId.PHP_TRAIT) && !id.equals((Object)PHPTokenId.PHP_ENUM)) continue;
                boolean bl = isTypeScope = curlyOpen > 0 && curlyOpen > curlyClose;
                return bl;
            }
        }
        finally {
            tokenSequence.move(orgOffset);
            tokenSequence.moveNext();
        }
        return false;
    }

    @CheckForNull
    static Token<? extends PHPTokenId> findFunctionInvocationName(TokenSequence<PHPTokenId> ts, int caretOffset) {
        ts.move(caretOffset);
        if (!ts.movePrevious()) {
            return null;
        }
        Token token = ts.token();
        PHPTokenId id = (PHPTokenId)token.id();
        if (id != PHPTokenId.PHP_STRING && id != PHPTokenId.WHITESPACE && !CompletionContextFinder.isParamSeparator((Token<PHPTokenId>)token)) {
            return null;
        }
        Token<? extends PHPTokenId> previousToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.PHP_STRING, PHPTokenId.WHITESPACE));
        if (previousToken == null) {
            return null;
        }
        if (CompletionContextFinder.isComma(previousToken)) {
            int braceBalance = 0;
            int curlyBalance = 0;
            while (ts.movePrevious()) {
                if (TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)"${") || TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)"{")) {
                    ++curlyBalance;
                } else if (TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)"}")) {
                    --curlyBalance;
                } else if (TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)"(")) {
                    if (braceBalance == 0) {
                        previousToken = ts.token();
                        break;
                    }
                    ++braceBalance;
                } else if (TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)")")) {
                    --braceBalance;
                }
                if (ts.token().id() != PHPTokenId.PHP_SEMICOLON || curlyBalance != 0) continue;
            }
        }
        if (CompletionContextFinder.isLeftParen(previousToken) && ts.movePrevious()) {
            previousToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE));
            if (previousToken == null) {
                return null;
            }
            if (previousToken.id() == PHPTokenId.PHP_STRING) {
                return ts.token();
            }
        }
        return null;
    }

    @CheckForNull
    private static CompletionContext getNamedArgumentsContext(int caretOffset, TokenSequence<PHPTokenId> ts) {
        int originalOffset = ts.offset();
        CompletionContext retval = null;
        Token<? extends PHPTokenId> functionName = CompletionContextFinder.findFunctionInvocationName(ts, caretOffset);
        if (functionName != null) {
            ts.moveNext();
            retval = CompletionContextFinder.acceptTokenChains(ts, CLASS_MEMBER_TOKENCHAINS, true) ? CompletionContext.CLASS_MEMBER_PARAMETER_NAME : (CompletionContextFinder.acceptTokenChains(ts, STATIC_CLASS_MEMBER_TOKENCHAINS, true) ? CompletionContext.STATIC_CLASS_MEMBER_PARAMETER_NAME : (CompletionContextFinder.acceptTokenChains(ts, CLASS_NAME_TOKENCHAINS, true) || CompletionContextFinder.isInAttribute(caretOffset, ts, true) ? CompletionContext.CONSTRUCTOR_PARAMETER_NAME : CompletionContext.FUNCTION_PARAMETER_NAME));
        }
        ts.move(originalOffset);
        ts.moveNext();
        return retval;
    }

    private static boolean isInMatchExpression(int caretOffset, TokenSequence<PHPTokenId> ts) {
        int originalOffset = ts.offset();
        boolean result = false;
        ts.move(caretOffset);
        if (ts.moveNext() && ts.movePrevious()) {
            TokenId tokenId;
            while (ts.movePrevious() && (tokenId = ts.token().id()) != PHPTokenId.PHP_SEMICOLON) {
                if (tokenId != PHPTokenId.PHP_MATCH) continue;
                result = true;
                break;
            }
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    static boolean isInAttribute(int caretOffset, TokenSequence<PHPTokenId> ts, boolean allowInArgs) {
        int originalOffset = ts.offset();
        boolean result = false;
        int bracketBalance = 0;
        int parenBalance = 0;
        ts.move(caretOffset);
        while (ts.movePrevious()) {
            if (CompletionContextFinder.isLeftBracket((Token<? extends PHPTokenId>)ts.token())) {
                --bracketBalance;
            } else if (CompletionContextFinder.isRightBracket((Token<PHPTokenId>)ts.token())) {
                ++bracketBalance;
            } else if (CompletionContextFinder.isLeftParen((Token<? extends PHPTokenId>)ts.token())) {
                --parenBalance;
            } else if (CompletionContextFinder.isRightParen((Token<PHPTokenId>)ts.token())) {
                ++parenBalance;
            }
            TokenId tokenId = ts.token().id();
            if (tokenId == PHPTokenId.PHP_ATTRIBUTE) {
                if (allowInArgs) {
                    result = bracketBalance == 0;
                    break;
                }
                result = bracketBalance == 0 && parenBalance == 0;
                break;
            }
            if (tokenId != PHPTokenId.PHP_SEMICOLON && !CompletionContextFinder.isFunctionDeclaration((Token<PHPTokenId>)ts.token()) && !CompletionContextFinder.isVisibilityModifier((Token<PHPTokenId>)ts.token()) && !CompletionContextFinder.isSetVisibilityModifier((Token<PHPTokenId>)ts.token())) continue;
            break;
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    static CompletionContext getCompletionContextInComment(TokenSequence<PHPTokenId> tokenSeq, int caretOffset, ParserResult info) {
        Token token = tokenSeq.token();
        CharSequence text = token.text();
        if (text == null || text.length() == 0) {
            return CompletionContext.NONE;
        }
        int offset = caretOffset - tokenSeq.offset() - 1;
        char charAt = '\u0000';
        if (offset > -1) {
            charAt = text.charAt(offset--);
            while (-1 < offset && !Character.isWhitespace(charAt) && charAt != '$') {
                charAt = text.charAt(offset);
                --offset;
            }
        }
        if (offset < text.length() && charAt == '$') {
            return CompletionContext.STRING;
        }
        return CompletionContext.TYPE_NAME;
    }

    static int lexerToASTOffset(PHPParseResult result, int lexerOffset) {
        return lexerOffset;
    }

    static int lexerToASTOffset(ParserResult info, int lexerOffset) {
        int value = 0;
        if (info instanceof PHPParseResult) {
            PHPParseResult result = (PHPParseResult)info;
            value = CompletionContextFinder.lexerToASTOffset(result, lexerOffset);
        }
        return value;
    }

    public static enum CompletionContext {
        EXPRESSION,
        GLOBAL_CONST_EXPRESSION,
        CLASS_CONST_EXPRESSION,
        MATCH_EXPRESSION,
        ENUM_CASE_EXPRESSION,
        HTML,
        CLASS_NAME,
        INTERFACE_NAME,
        BACKING_TYPE,
        TYPE_NAME,
        RETURN_TYPE_NAME,
        RETURN_UNION_OR_INTERSECTION_TYPE_NAME,
        FIELD_TYPE_NAME,
        CONST_TYPE_NAME,
        VISIBILITY_MODIFIER_OR_TYPE_NAME,
        STRING,
        CLASS_MEMBER,
        STATIC_CLASS_MEMBER,
        PHPDOC,
        INHERITANCE,
        EXTENDS,
        IMPLEMENTS,
        METHOD_NAME,
        CLASS_MEMBER_PARAMETER_NAME,
        STATIC_CLASS_MEMBER_PARAMETER_NAME,
        FUNCTION_PARAMETER_NAME,
        CONSTRUCTOR_PARAMETER_NAME,
        CLASS_CONTEXT_KEYWORDS,
        SERVER_ENTRY_CONSTANTS,
        NONE,
        NEW_CLASS,
        GLOBAL,
        NAMESPACE_KEYWORD,
        GROUP_USE_KEYWORD,
        GROUP_USE_CONST_KEYWORD,
        GROUP_USE_FUNCTION_KEYWORD,
        USE_KEYWORD,
        USE_CONST_KEYWORD,
        USE_FUNCTION_KEYWORD,
        DEFAULT_PARAMETER_VALUE,
        OPEN_TAG,
        THROW,
        THROW_NEW,
        CATCH,
        CLASS_MEMBER_IN_STRING,
        INTERFACE_CONTEXT_KEYWORDS,
        USE_TRAITS,
        ATTRIBUTE,
        ATTRIBUTE_EXPRESSION;

    }

    static enum KeywordCompletionType {
        SIMPLE,
        CURSOR_INSIDE_BRACKETS,
        ENDS_WITH_CURLY_BRACKETS,
        ENDS_WITH_SPACE,
        ENDS_WITH_SEMICOLON,
        ENDS_WITH_COLON,
        ENDS_WITH_BRACKETS_AND_CURLY_BRACKETS,
        CURSOR_BEFORE_ENDING_SEMICOLON;

    }
}

