/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterWrapper;
import org.netbeans.modules.debugger.jpda.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.impl.StepUtils;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;

public class StepIntoNextMethod
implements Executor,
PropertyChangeListener {
    private static final Logger smartLogger = Logger.getLogger("org.netbeans.modules.debugger.jpda.smartstepping");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private volatile StepRequest stepIntoRequest;
    private String position;
    private int depth;
    private final JPDADebuggerImpl debugger;
    private final ContextProvider contextProvider;
    private final boolean smartSteppingStepOut;
    private boolean steppingFromFilteredLocation;
    private boolean steppingFromCompoundFilteredLocation;
    private SmartSteppingFilterWrapper smartSteppingFilter;
    private boolean didStepThrough;
    private final Properties p;
    private StepActionProvider stepActionProvider;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    public StepIntoNextMethod(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.contextProvider = contextProvider;
        this.debugger.getSmartSteppingFilter().addPropertyChangeListener((PropertyChangeListener)this);
        SourcePath ec = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        ec.addPropertyChangeListener(this);
        Map properties = (Map)contextProvider.lookupFirst(null, Map.class);
        this.smartSteppingStepOut = properties != null ? properties.containsKey("SS_ACTION_STEPOUT") : false;
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    private JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    public void runAction() {
        this.runAction(true);
    }

    public void runAction(boolean doResume) {
        this.runAction(null, doResume, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAction(Object action, boolean doResume, Lock lock, Boolean isSteppingFromFilteredLocation, Boolean isSteppingFromCompoundFilteredLocation) {
        smartLogger.finer("STEP INTO NEXT METHOD.");
        JPDAThread t = this.getDebuggerImpl().getCurrentThread();
        if (t == null) {
            smartLogger.finer("Can not step into next method! No current thread!");
            return;
        }
        this.smartSteppingFilter = new SmartSteppingFilterWrapper(this.debugger.getSmartSteppingFilter());
        this.didStepThrough = false;
        boolean locked = lock == null;
        try {
            CallStackFrame topFrame;
            if (lock == null) {
                lock = this.getDebuggerImpl().getSuspend() == 1 ? ((JPDAThreadImpl)t).accessLock.writeLock() : this.getDebuggerImpl().accessLock.writeLock();
                lock.lock();
                if (!t.isSuspended() && !((JPDAThreadImpl)t).isSuspendedNoFire()) {
                    if (smartLogger.isLoggable(Level.FINER)) {
                        smartLogger.finer("Can not step into next method! Thread " + t + " not suspended!");
                    }
                    return;
                }
            }
            JPDAThreadImpl[] resumeThreadPtr = new JPDAThreadImpl[]{null};
            int stepDepth = ActionsManager.ACTION_STEP_OUT.equals(action) ? 3 : 1;
            if (isSteppingFromFilteredLocation != null) {
                this.steppingFromFilteredLocation = isSteppingFromFilteredLocation;
            } else {
                boolean bl = this.steppingFromFilteredLocation = !StepActionProvider.stopInClass(t.getClassName(), this.smartSteppingFilter);
            }
            this.steppingFromCompoundFilteredLocation = isSteppingFromCompoundFilteredLocation != null ? isSteppingFromCompoundFilteredLocation : ((topFrame = StepActionProvider.getTopFrame(t)) != null ? !this.getCompoundSmartSteppingListener().stopAt(this.contextProvider, topFrame, this.smartSteppingFilter).isStop() : !this.getCompoundSmartSteppingListener().stopHere(this.contextProvider, t, this.smartSteppingFilter));
            StepRequest stepRequest = this.setStepRequest(stepDepth, resumeThreadPtr);
            this.position = t.getClassName() + '.' + t.getMethodName() + ':' + t.getLineNumber(null);
            if (stepDepth == 1) {
                if (this.position.startsWith("jdk.nashorn.internal.scripts.Script") && "JS".equals(this.debugger.getSession().getCurrentLanguage())) {
                    try {
                        EventRequestWrapper.disable(stepRequest);
                        stepRequest.addClassFilter("jdk.nashorn.internal.scripts.Script*");
                        EventRequestWrapper.enable(stepRequest);
                    }
                    catch (InternalExceptionWrapper ex) {
                        stepRequest = null;
                    }
                    catch (InvalidRequestStateExceptionWrapper ex) {
                        stepRequest = null;
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                        stepRequest = null;
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                        stepRequest = null;
                    }
                }
                this.stepIntoRequest = stepRequest;
            }
            this.depth = t.getStackDepth();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JDI Request (action step into next method): " + stepRequest);
            }
            if (stepRequest == null) {
                return;
            }
            ((JPDAThreadImpl)t).setInStep(true, stepRequest);
            if (doResume) {
                if (resumeThreadPtr[0] == null) {
                    this.getDebuggerImpl().resume();
                } else {
                    this.getDebuggerImpl().resumeCurrentThread();
                }
            }
        }
        finally {
            if (locked && lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("exclusionPatterns".equals(ev.getPropertyName())) {
            if (ev.getOldValue() != null) {
                smartLogger.finer("Exclusion patterns removed. Removing step requests.");
                JPDAThreadImpl currentThread = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
                if (currentThread != null) {
                    ThreadReference tr = currentThread.getThreadReference();
                    this.removeStepRequests(tr);
                }
            } else {
                if (smartLogger.isLoggable(Level.FINER)) {
                    if (this.stepIntoRequest == null) {
                        smartLogger.finer("Exclusion patterns has been added");
                    } else {
                        smartLogger.finer("Add exclusion patterns: " + ev.getNewValue());
                    }
                }
                try {
                    this.addPatternsToRequest(((Set)ev.getNewValue()).toArray(new String[((Set)ev.getNewValue()).size()]), this.stepIntoRequest);
                }
                catch (InternalExceptionWrapper ex) {
                    return;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return;
                }
            }
        } else if ("sourceRoots".equals(ev.getPropertyName())) {
            smartLogger.finer("Source roots changed");
            JPDAThreadImpl jtr = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
            if (jtr != null) {
                ThreadReference tr = jtr.getThreadReference();
                this.removeStepRequests(tr);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exec(Event event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removed(EventRequest eventRequest) {
        StepRequest sr = (StepRequest)eventRequest;
        try {
            JPDAThreadImpl st = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(sr));
            st.setInStep(false, null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    private StepActionProvider getStepActionProvider() {
        if (this.stepActionProvider == null) {
            List l = this.contextProvider.lookup(null, ActionsProvider.class);
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                if (!(l.get(i) instanceof StepActionProvider)) continue;
                this.stepActionProvider = (StepActionProvider)l.get(i);
            }
        }
        return this.stepActionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStepRequests(ThreadReference tr) {
        StepIntoNextMethod stepIntoNextMethod = this;
        synchronized (stepIntoNextMethod) {
            this.stepIntoRequest = null;
        }
        JPDADebuggerActionProvider.removeStepRequests(this.getDebuggerImpl(), tr);
        smartLogger.finer("removing all patterns, all step requests.");
    }

    private StepRequest setStepRequest(int step) {
        return this.setStepRequest(step, -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepRequest setStepRequest(int step, int stepSize) {
        StepRequest enabledStepRequest = null;
        if (step == 1) {
            StepIntoNextMethod stepIntoNextMethod = this;
            synchronized (stepIntoNextMethod) {
                if (this.stepIntoRequest != null) {
                    try {
                        this.addPatternsToRequest(this.smartSteppingFilter.getExclusionPatterns(), this.stepIntoRequest);
                        try {
                            EventRequestWrapper.enable(this.stepIntoRequest);
                            enabledStepRequest = this.stepIntoRequest;
                        }
                        catch (IllegalThreadStateException itsex) {
                            this.getDebuggerImpl().getOperator().unregister(this.stepIntoRequest);
                            this.stepIntoRequest = null;
                            return null;
                        }
                        catch (ObjectCollectedExceptionWrapper ocex) {
                            this.getDebuggerImpl().getOperator().unregister(this.stepIntoRequest);
                            this.stepIntoRequest = null;
                            return null;
                        }
                        catch (InvalidRequestStateExceptionWrapper irse) {
                            this.getDebuggerImpl().getOperator().unregister(this.stepIntoRequest);
                            this.stepIntoRequest = null;
                            return null;
                        }
                    }
                    catch (VMDisconnectedExceptionWrapper e) {
                        this.stepIntoRequest = null;
                        return null;
                    }
                    catch (InternalExceptionWrapper e) {
                        this.stepIntoRequest = null;
                        return null;
                    }
                }
            }
        }
        if (enabledStepRequest != null) {
            return enabledStepRequest;
        }
        return this.setStepRequest(step, stepSize, null);
    }

    private StepRequest setStepRequest(int step, JPDAThreadImpl[] resumeThreadPtr) {
        return this.setStepRequest(step, -2, resumeThreadPtr);
    }

    private StepRequest setStepRequest(int step, int stepSize, JPDAThreadImpl[] resumeThreadPtr) {
        int suspendPolicy;
        StepRequest stepRequest;
        JPDAThreadImpl thread = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
        ThreadReference tr = thread.getThreadReference();
        this.removeStepRequests(tr);
        VirtualMachine vm = this.getDebuggerImpl().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        try {
            stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), tr, stepSize, step);
            StepUtils.markOriginalStepDepth(stepRequest, tr);
            this.getDebuggerImpl().getOperator().register(stepRequest, this);
            suspendPolicy = this.getDebuggerImpl().getSuspend();
            EventRequestWrapper.setSuspendPolicy(stepRequest, suspendPolicy);
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        if (smartLogger.isLoggable(Level.FINER)) {
            smartLogger.finer("Set step request(" + step + ") and patterns: ");
        }
        try {
            try {
                if (!this.steppingFromFilteredLocation) {
                    this.addPatternsToRequest(this.smartSteppingFilter.getExclusionPatterns(), stepRequest);
                }
                EventRequestWrapper.enable(stepRequest);
            }
            catch (IllegalThreadStateException itsex) {
                this.getDebuggerImpl().getOperator().unregister(stepRequest);
                stepRequest = null;
                return null;
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
                this.getDebuggerImpl().getOperator().unregister(stepRequest);
                stepRequest = null;
                return null;
            }
            catch (InvalidRequestStateExceptionWrapper irse) {
                this.getDebuggerImpl().getOperator().unregister(stepRequest);
                stepRequest = null;
                return null;
            }
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        if (resumeThreadPtr != null) {
            resumeThreadPtr[0] = suspendPolicy == 1 ? thread : null;
        }
        return stepRequest;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.contextProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    private void addPatternsToRequest(String[] patterns, StepRequest stepRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (stepRequest == null) {
            return;
        }
        int k = patterns.length;
        for (int i = 0; i < k; ++i) {
            try {
                StepRequestWrapper.addClassExclusionFilter(stepRequest, patterns[i]);
            }
            catch (InvalidRequestStateException irex) {
                return;
            }
            smartLogger.log(Level.FINER, "   add pattern: {0}", patterns[i]);
        }
    }

    private boolean isFilteredClassOnStack(ThreadReference tr, int depth) {
        if (this.steppingFromFilteredLocation) {
            return false;
        }
        String[] patterns = this.smartSteppingFilter.getExclusionPatterns();
        if (patterns.length == 0) {
            return false;
        }
        try {
            int n = ThreadReferenceWrapper.frameCount(tr);
            if (n <= depth + 1) {
                return false;
            }
            List<StackFrame> frames = ThreadReferenceWrapper.frames(tr, 0, n - depth);
            for (StackFrame f : frames) {
                String className = ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(f)));
                for (String pattern : patterns) {
                    if (!StepIntoNextMethod.match(className, pattern)) continue;
                    smartLogger.log(Level.FINER, " class ''{0}'' on stack.", className);
                    return true;
                }
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            // empty catch block
        }
        return false;
    }

    private static boolean match(String name, String pattern) {
        if (pattern.startsWith("*")) {
            return name.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return name.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return name.contentEquals(pattern);
    }
}

