/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.File;
import java.io.IOException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xml.tools.generator.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public final class SelectFileDialog {
    private Util.NameCheck check;
    private Prompt selectDD;
    private FileObject folder;
    private String ext;

    public SelectFileDialog(FileObject folder, String name, String ext) {
        this(folder, name, ext, Util.JAVA_CHECK);
    }

    public SelectFileDialog(FileObject folder, String name, String ext, Util.NameCheck check) {
        this.folder = folder;
        this.ext = ext;
        this.check = check;
        this.selectDD = new Prompt(NbBundle.getMessage(SelectFileDialog.class, (String)"PROP_fileNameTitle") + " *." + ext, NbBundle.getMessage(SelectFileDialog.class, (String)"PROP_fileName"), name);
    }

    public FileObject getFileObject() throws IOException {
        FileObject newFO = null;
        while (newFO == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)this.selectDD);
            if (this.selectDD.getValue() != NotifyDescriptor.OK_OPTION) {
                throw new UserCancelException();
            }
            final String newName = this.selectDD.getInputText();
            newFO = this.folder.getFileObject(newName, this.ext);
            if (newFO == null || newFO.isVirtual()) {
                FileSystem fs = this.folder.getFileSystem();
                final FileObject tempFile = newFO;
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        if (tempFile != null && tempFile.isVirtual()) {
                            tempFile.delete();
                        }
                        try {
                            SelectFileDialog.this.folder.createData(newName, SelectFileDialog.this.ext);
                        }
                        catch (IOException exc) {
                            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SelectFileDialog.class, (String)"MSG_cannot_create_data", (Object)(newName + "." + SelectFileDialog.this.ext)), 2);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        }
                    }
                });
                newFO = this.folder.getFileObject(newName, this.ext);
                continue;
            }
            if (newFO == null) continue;
            DataObject data = DataObject.find((FileObject)newFO);
            if (data.isModified() || !data.isValid()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SelectFileDialog.class, (String)"BK0001"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                throw new UserCancelException();
            }
            if (GuiUtil.confirmAction((String)NbBundle.getMessage(SelectFileDialog.class, (String)"PROP_replaceMsg", (Object)newName, (Object)this.ext))) continue;
            throw new UserCancelException();
        }
        return newFO;
    }

    private class Prompt
    extends NotifyDescriptor.InputLine
    implements DocumentListener {
        public Prompt(String title, String label, String text) {
            super(label, title);
            this.setInputText(text);
            this.textField.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.verifyInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.verifyInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.verifyInput();
        }

        private void verifyInput() {
            String typedText = this.textField.getText();
            if (typedText.indexOf(File.separatorChar) != -1 || typedText.indexOf(":") != -1 || typedText.indexOf("/") != -1 || typedText.indexOf("\\") != -1) {
                SelectFileDialog.this.selectDD.setValid(false);
            } else {
                SelectFileDialog.this.selectDD.setValid(SelectFileDialog.this.check.checkName(typedText));
            }
        }
    }
}

