/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbmodule;

import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;

public final class NbModuleProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    private static final String NBMODULE_PROJECT_NAMESPACE_2 = "http://www.netbeans.org/ns/nb-module-project/2";
    private static final String NBMODULE_PROJECT_NAMESPACE_3 = "http://www.netbeans.org/ns/nb-module-project/3";
    private static final String NBMODULE_SUITE_PROJECT_NAMESPACE = "http://www.netbeans.org/ns/nb-module-suite-project/1";

    public boolean isFileObjectSupported(FileObject fo) {
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)fo);
        return src != null ? src.isTest() : false;
    }

    public org.netbeans.modules.profiler.api.JavaPlatform resolveProjectJavaPlatform() {
        return this.getProjectJavaPlatform(this.getProject());
    }

    private org.netbeans.modules.profiler.api.JavaPlatform getProjectJavaPlatform(Project project) {
        AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        FileObject projectDir = project.getProjectDirectory();
        if (aux.getConfigurationFragment("data", NBMODULE_SUITE_PROJECT_NAMESPACE, true) != null) {
            SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            if (ProfilerLogger.isDebug()) {
                ProfilerLogger.debug((String)("NB Suite " + projectDir.getPath()));
            }
            if (spp == null) {
                return null;
            }
            Set subProjects = spp.getSubprojects();
            if (subProjects.isEmpty()) {
                return null;
            }
            return this.getProjectJavaPlatform((Project)subProjects.iterator().next());
        }
        ClassPath bootCp = ClassPath.getClassPath((FileObject)projectDir, (String)"classpath/boot");
        List bootCpEntries = bootCp.entries();
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)("Boot CP " + bootCp));
        }
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)("File " + projectDir.getPath()));
        }
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < platforms.length; ++i) {
            JavaPlatform platform = platforms[i];
            if (!bootCpEntries.equals(platform.getBootstrapLibraries().entries())) continue;
            if (ProfilerLogger.isDebug()) {
                ProfilerLogger.debug((String)("Platform " + platform.getDisplayName()));
            }
            return org.netbeans.modules.profiler.api.JavaPlatform.getJavaPlatformById((String)((String)platform.getProperties().get("platform.ant.name")));
        }
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)"Platform null");
        }
        return null;
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        org.netbeans.modules.profiler.api.JavaPlatform platform = this.getProjectJavaPlatform();
        ss.setSystemArchitecture(platform.getPlatformArchitecture());
        ss.setJavaVersionString(platform.getPlatformJDKVersion());
        ss.setJavaExecutable(platform.getPlatformJavaFile());
    }

    public NbModuleProjectProfilingSupportProvider(Project project) {
        super(project);
    }
}

