/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MonitorModel
implements TreeModelFilter,
NodeModelFilter,
NodeActionsProviderFilter,
TableModel,
Constants {
    public static final String CONTENDED_MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/ContendedMonitor";
    public static final String OWNED_MONITORS = "org/netbeans/modules/debugger/resources/allInOneView/OwnedMonitors";
    public static final String MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/Monitor";
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection modelListeners = new HashSet();
    private Map<Object, Object> shortDescriptionMap = new HashMap<Object, Object>();

    public Object getRoot(TreeModel model) {
        return model.getRoot();
    }

    public Object[] getChildren(TreeModel model, Object o, int from, int to) throws UnknownTypeException {
        if (o instanceof ThreadWithBordel) {
            try {
                JPDAThread t = ((ThreadWithBordel)o).getOriginalThread();
                ObjectVariable contended = t.getContendedMonitor();
                ObjectVariable[] owned = t.getOwnedMonitors();
                ContendedMonitor cm = null;
                OwnedMonitors om = null;
                if (contended != null && from == 0 && to > 0) {
                    cm = new ContendedMonitor(contended);
                }
                if (owned.length > 0 && (contended != null && from < 2 && to > 1 || contended == null && from == 0 && to > 0)) {
                    om = new OwnedMonitors(owned);
                }
                int i = 0;
                if (cm != null) {
                    ++i;
                }
                if (om != null) {
                    ++i;
                }
                Object[] os = new Object[i];
                i = 0;
                if (cm != null) {
                    os[i++] = cm;
                }
                if (om != null) {
                    os[i++] = om;
                }
                return os;
            }
            catch (ObjectCollectedException t) {
            }
            catch (VMDisconnectedException t) {
                // empty catch block
            }
            return new Object[0];
        }
        if (o instanceof JPDAThreadGroup) {
            JPDAThreadGroup tg = (JPDAThreadGroup)o;
            Object[] ch = model.getChildren(o, from, to);
            int k = ch.length;
            for (int i = 0; i < k; ++i) {
                if (!(ch[i] instanceof JPDAThread)) continue;
                try {
                    JPDAThread t = (JPDAThread)ch[i];
                    if (t.getContendedMonitor() == null && t.getOwnedMonitors().length == 0) continue;
                    ThreadWithBordel twb = new ThreadWithBordel(t);
                    ch[i] = twb;
                    continue;
                }
                catch (ObjectCollectedException objectCollectedException) {
                    continue;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            return ch;
        }
        if (o instanceof OwnedMonitors) {
            OwnedMonitors om = (OwnedMonitors)o;
            Object[] fo = new Object[to - from];
            System.arraycopy(om.variables, from, fo, 0, to - from);
            return fo;
        }
        return model.getChildren(o, from, to);
    }

    public int getChildrenCount(TreeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ThreadWithBordel) {
            return Integer.MAX_VALUE;
        }
        if (o instanceof ThreadWithBordel) {
            return model.getChildrenCount((Object)((ThreadWithBordel)o).getOriginalThread());
        }
        if (o instanceof OwnedMonitors) {
            return ((OwnedMonitors)o).variables.length;
        }
        return model.getChildrenCount(o);
    }

    public boolean isLeaf(TreeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ThreadWithBordel) {
            return false;
        }
        if (o instanceof OwnedMonitors) {
            return false;
        }
        if (o instanceof ContendedMonitor) {
            return true;
        }
        if (o instanceof ObjectVariable) {
            return true;
        }
        return model.isLeaf(o);
    }

    public String getDisplayName(NodeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            ObjectVariable v = ((ContendedMonitor)o).variable;
            return MessageFormat.format(NbBundle.getBundle(MonitorModel.class).getString("CTL_MonitorModel_Column_ContendedMonitor"), v.getType(), v.getValue());
        }
        if (o instanceof ThreadWithBordel) {
            return model.getDisplayName((Object)((ThreadWithBordel)o).getOriginalThread());
        }
        if (o instanceof OwnedMonitors) {
            return NbBundle.getBundle(MonitorModel.class).getString("CTL_MonitorModel_Column_OwnedMonitors");
        }
        if (o instanceof ObjectVariable) {
            ObjectVariable v = (ObjectVariable)o;
            return MessageFormat.format(NbBundle.getBundle(MonitorModel.class).getString("CTL_MonitorModel_Column_Monitor"), v.getType(), v.getValue());
        }
        return model.getDisplayName(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final NodeModel model, final Object o) throws UnknownTypeException {
        Map<Object, Object> map = this.shortDescriptionMap;
        synchronized (map) {
            Object shortDescription = this.shortDescriptionMap.remove(o);
            if (shortDescription instanceof String) {
                return (String)shortDescription;
            }
            if (shortDescription instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)shortDescription);
            }
        }
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object shortDescription;
                if (o instanceof ContendedMonitor) {
                    v = ((ContendedMonitor)o).variable;
                    try {
                        shortDescription = "(" + v.getType() + ") " + v.getToStringValue();
                    }
                    catch (InvalidExpressionException ex) {
                        shortDescription = ex.getLocalizedMessage();
                    }
                } else if (o instanceof ThreadWithBordel) {
                    try {
                        shortDescription = model.getShortDescription((Object)((ThreadWithBordel)o).getOriginalThread());
                    }
                    catch (UnknownTypeException utex) {
                        shortDescription = utex;
                    }
                } else if (o instanceof OwnedMonitors) {
                    shortDescription = "";
                } else if (o instanceof ObjectVariable) {
                    v = (ObjectVariable)o;
                    try {
                        shortDescription = "(" + v.getType() + ") " + v.getToStringValue();
                    }
                    catch (InvalidExpressionException ex) {
                        shortDescription = ex.getLocalizedMessage();
                    }
                } else {
                    try {
                        shortDescription = model.getShortDescription(o);
                    }
                    catch (UnknownTypeException utex) {
                        shortDescription = utex;
                    }
                }
                if (shortDescription != null && !"".equals(shortDescription)) {
                    Map<Object, Object> map = MonitorModel.this.shortDescriptionMap;
                    synchronized (map) {
                        MonitorModel.this.shortDescriptionMap.put(o, shortDescription);
                    }
                    MonitorModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)MonitorModel.this, o, 4));
                }
            }
        });
        return "";
    }

    public String getIconBase(NodeModel model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return CONTENDED_MONITOR;
        }
        if (o instanceof ThreadWithBordel) {
            return model.getIconBase((Object)((ThreadWithBordel)o).getOriginalThread());
        }
        if (o instanceof OwnedMonitors) {
            return OWNED_MONITORS;
        }
        if (o instanceof ObjectVariable) {
            return MONITOR;
        }
        return model.getIconBase(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    public Action[] getActions(NodeActionsProvider model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return new Action[0];
        }
        if (o instanceof OwnedMonitors) {
            return new Action[0];
        }
        if (o instanceof ThreadWithBordel) {
            return model.getActions((Object)((ThreadWithBordel)o).getOriginalThread());
        }
        if (o instanceof ObjectVariable) {
            return new Action[0];
        }
        return model.getActions(o);
    }

    public void performDefaultAction(NodeActionsProvider model, Object o) throws UnknownTypeException {
        if (o instanceof ContendedMonitor) {
            return;
        }
        if (o instanceof OwnedMonitors) {
            return;
        }
        if (o instanceof ThreadWithBordel) {
            model.performDefaultAction((Object)((ThreadWithBordel)o).getOriginalThread());
            return;
        }
        if (o instanceof ObjectVariable) {
            return;
        }
        model.performDefaultAction(o);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof OwnedMonitors || node instanceof ContendedMonitor || node instanceof ObjectVariable) {
            if (columnID == "ThreadState") {
                return "";
            }
            if (columnID == "ThreadSuspended") {
                return null;
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ((node instanceof OwnedMonitors || node instanceof ContendedMonitor || node instanceof ObjectVariable) && (columnID == "ThreadState" || columnID == "ThreadSuspended")) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
    }

    static class ThreadWithBordel {
        private JPDAThread originalThread;

        ThreadWithBordel(JPDAThread orig) {
            this.originalThread = orig;
        }

        public JPDAThread getOriginalThread() {
            return this.originalThread;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ThreadWithBordel)) {
                return false;
            }
            ThreadWithBordel other = (ThreadWithBordel)obj;
            return this.originalThread.equals(other.originalThread);
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + (this.originalThread != null ? this.originalThread.hashCode() : 0);
            return hash;
        }
    }

    private static class ContendedMonitor {
        ObjectVariable variable;

        ContendedMonitor(ObjectVariable v) {
            this.variable = v;
        }
    }

    private static class OwnedMonitors {
        ObjectVariable[] variables;

        OwnedMonitors(ObjectVariable[] vs) {
            this.variables = vs;
        }
    }
}

