/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVirtualCircuitRequest
extends BmcRequest<Void> {
    private String virtualCircuitId;

    public String getVirtualCircuitId() {
        return this.virtualCircuitId;
    }

    public Builder toBuilder() {
        return new Builder().virtualCircuitId(this.virtualCircuitId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",virtualCircuitId=").append(String.valueOf(this.virtualCircuitId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVirtualCircuitRequest)) {
            return false;
        }
        GetVirtualCircuitRequest other = (GetVirtualCircuitRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.virtualCircuitId, other.virtualCircuitId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.virtualCircuitId == null ? 43 : this.virtualCircuitId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVirtualCircuitRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String virtualCircuitId = null;

        public Builder virtualCircuitId(String virtualCircuitId) {
            this.virtualCircuitId = virtualCircuitId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVirtualCircuitRequest o) {
            this.virtualCircuitId(o.getVirtualCircuitId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVirtualCircuitRequest build() {
            GetVirtualCircuitRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVirtualCircuitRequest buildWithoutInvocationCallback() {
            GetVirtualCircuitRequest request = new GetVirtualCircuitRequest();
            request.virtualCircuitId = this.virtualCircuitId;
            return request;
        }
    }
}

