/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInstancePoolLoadBalancerAttachmentRequest
extends BmcRequest<Void> {
    private String instancePoolId;
    private String instancePoolLoadBalancerAttachmentId;

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public String getInstancePoolLoadBalancerAttachmentId() {
        return this.instancePoolLoadBalancerAttachmentId;
    }

    public Builder toBuilder() {
        return new Builder().instancePoolId(this.instancePoolId).instancePoolLoadBalancerAttachmentId(this.instancePoolLoadBalancerAttachmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instancePoolId=").append(String.valueOf(this.instancePoolId));
        sb.append(",instancePoolLoadBalancerAttachmentId=").append(String.valueOf(this.instancePoolLoadBalancerAttachmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInstancePoolLoadBalancerAttachmentRequest)) {
            return false;
        }
        GetInstancePoolLoadBalancerAttachmentRequest other = (GetInstancePoolLoadBalancerAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instancePoolId, other.instancePoolId) && Objects.equals(this.instancePoolLoadBalancerAttachmentId, other.instancePoolLoadBalancerAttachmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instancePoolId == null ? 43 : this.instancePoolId.hashCode());
        result = result * 59 + (this.instancePoolLoadBalancerAttachmentId == null ? 43 : this.instancePoolLoadBalancerAttachmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstancePoolLoadBalancerAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instancePoolId = null;
        private String instancePoolLoadBalancerAttachmentId = null;

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder instancePoolLoadBalancerAttachmentId(String instancePoolLoadBalancerAttachmentId) {
            this.instancePoolLoadBalancerAttachmentId = instancePoolLoadBalancerAttachmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstancePoolLoadBalancerAttachmentRequest o) {
            this.instancePoolId(o.getInstancePoolId());
            this.instancePoolLoadBalancerAttachmentId(o.getInstancePoolLoadBalancerAttachmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstancePoolLoadBalancerAttachmentRequest build() {
            GetInstancePoolLoadBalancerAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInstancePoolLoadBalancerAttachmentRequest buildWithoutInvocationCallback() {
            GetInstancePoolLoadBalancerAttachmentRequest request = new GetInstancePoolLoadBalancerAttachmentRequest();
            request.instancePoolId = this.instancePoolId;
            request.instancePoolLoadBalancerAttachmentId = this.instancePoolLoadBalancerAttachmentId;
            return request;
        }
    }
}

