/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.CrossConnectMapping;
import com.oracle.bmc.core.model.VirtualCircuitIpMtu;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VirtualCircuit
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bandwidthShapeName")
    private final String bandwidthShapeName;
    @JsonProperty(value="bgpManagement")
    private final BgpManagement bgpManagement;
    @JsonProperty(value="bgpSessionState")
    private final BgpSessionState bgpSessionState;
    @JsonProperty(value="bgpIpv6SessionState")
    private final BgpIpv6SessionState bgpIpv6SessionState;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="crossConnectMappings")
    private final List<CrossConnectMapping> crossConnectMappings;
    @JsonProperty(value="routingPolicy")
    private final List<RoutingPolicy> routingPolicy;
    @JsonProperty(value="bgpAdminState")
    private final BgpAdminState bgpAdminState;
    @JsonProperty(value="isBfdEnabled")
    private final Boolean isBfdEnabled;
    @JsonProperty(value="isTransportMode")
    private final Boolean isTransportMode;
    @JsonProperty(value="customerBgpAsn")
    private final Integer customerBgpAsn;
    @JsonProperty(value="customerAsn")
    private final Long customerAsn;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="gatewayId")
    private final String gatewayId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="oracleBgpAsn")
    private final Integer oracleBgpAsn;
    @JsonProperty(value="providerName")
    private final String providerName;
    @JsonProperty(value="providerServiceId")
    private final String providerServiceId;
    @JsonProperty(value="providerServiceKeyName")
    private final String providerServiceKeyName;
    @JsonProperty(value="providerServiceName")
    private final String providerServiceName;
    @JsonProperty(value="providerState")
    private final ProviderState providerState;
    @JsonProperty(value="publicPrefixes")
    private final List<String> publicPrefixes;
    @JsonProperty(value="referenceComment")
    private final String referenceComment;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="serviceType")
    private final ServiceType serviceType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="ipMtu")
    private final VirtualCircuitIpMtu ipMtu;

    @Deprecated
    @ConstructorProperties(value={"bandwidthShapeName", "bgpManagement", "bgpSessionState", "bgpIpv6SessionState", "compartmentId", "crossConnectMappings", "routingPolicy", "bgpAdminState", "isBfdEnabled", "isTransportMode", "customerBgpAsn", "customerAsn", "definedTags", "displayName", "freeformTags", "gatewayId", "id", "lifecycleState", "oracleBgpAsn", "providerName", "providerServiceId", "providerServiceKeyName", "providerServiceName", "providerState", "publicPrefixes", "referenceComment", "region", "serviceType", "timeCreated", "type", "ipMtu"})
    public VirtualCircuit(String bandwidthShapeName, BgpManagement bgpManagement, BgpSessionState bgpSessionState, BgpIpv6SessionState bgpIpv6SessionState, String compartmentId, List<CrossConnectMapping> crossConnectMappings, List<RoutingPolicy> routingPolicy, BgpAdminState bgpAdminState, Boolean isBfdEnabled, Boolean isTransportMode, Integer customerBgpAsn, Long customerAsn, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String gatewayId, String id, LifecycleState lifecycleState, Integer oracleBgpAsn, String providerName, String providerServiceId, String providerServiceKeyName, String providerServiceName, ProviderState providerState, List<String> publicPrefixes, String referenceComment, String region, ServiceType serviceType, Date timeCreated, Type type, VirtualCircuitIpMtu ipMtu) {
        this.bandwidthShapeName = bandwidthShapeName;
        this.bgpManagement = bgpManagement;
        this.bgpSessionState = bgpSessionState;
        this.bgpIpv6SessionState = bgpIpv6SessionState;
        this.compartmentId = compartmentId;
        this.crossConnectMappings = crossConnectMappings;
        this.routingPolicy = routingPolicy;
        this.bgpAdminState = bgpAdminState;
        this.isBfdEnabled = isBfdEnabled;
        this.isTransportMode = isTransportMode;
        this.customerBgpAsn = customerBgpAsn;
        this.customerAsn = customerAsn;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.gatewayId = gatewayId;
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.oracleBgpAsn = oracleBgpAsn;
        this.providerName = providerName;
        this.providerServiceId = providerServiceId;
        this.providerServiceKeyName = providerServiceKeyName;
        this.providerServiceName = providerServiceName;
        this.providerState = providerState;
        this.publicPrefixes = publicPrefixes;
        this.referenceComment = referenceComment;
        this.region = region;
        this.serviceType = serviceType;
        this.timeCreated = timeCreated;
        this.type = type;
        this.ipMtu = ipMtu;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBandwidthShapeName() {
        return this.bandwidthShapeName;
    }

    public BgpManagement getBgpManagement() {
        return this.bgpManagement;
    }

    public BgpSessionState getBgpSessionState() {
        return this.bgpSessionState;
    }

    public BgpIpv6SessionState getBgpIpv6SessionState() {
        return this.bgpIpv6SessionState;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<CrossConnectMapping> getCrossConnectMappings() {
        return this.crossConnectMappings;
    }

    public List<RoutingPolicy> getRoutingPolicy() {
        return this.routingPolicy;
    }

    public BgpAdminState getBgpAdminState() {
        return this.bgpAdminState;
    }

    public Boolean getIsBfdEnabled() {
        return this.isBfdEnabled;
    }

    public Boolean getIsTransportMode() {
        return this.isTransportMode;
    }

    public Integer getCustomerBgpAsn() {
        return this.customerBgpAsn;
    }

    public Long getCustomerAsn() {
        return this.customerAsn;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getOracleBgpAsn() {
        return this.oracleBgpAsn;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderServiceId() {
        return this.providerServiceId;
    }

    public String getProviderServiceKeyName() {
        return this.providerServiceKeyName;
    }

    public String getProviderServiceName() {
        return this.providerServiceName;
    }

    public ProviderState getProviderState() {
        return this.providerState;
    }

    public List<String> getPublicPrefixes() {
        return this.publicPrefixes;
    }

    public String getReferenceComment() {
        return this.referenceComment;
    }

    public String getRegion() {
        return this.region;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Type getType() {
        return this.type;
    }

    public VirtualCircuitIpMtu getIpMtu() {
        return this.ipMtu;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualCircuit(");
        sb.append("super=").append(super.toString());
        sb.append("bandwidthShapeName=").append(String.valueOf(this.bandwidthShapeName));
        sb.append(", bgpManagement=").append(String.valueOf((Object)this.bgpManagement));
        sb.append(", bgpSessionState=").append(String.valueOf((Object)this.bgpSessionState));
        sb.append(", bgpIpv6SessionState=").append(String.valueOf((Object)this.bgpIpv6SessionState));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", crossConnectMappings=").append(String.valueOf(this.crossConnectMappings));
        sb.append(", routingPolicy=").append(String.valueOf(this.routingPolicy));
        sb.append(", bgpAdminState=").append(String.valueOf((Object)this.bgpAdminState));
        sb.append(", isBfdEnabled=").append(String.valueOf(this.isBfdEnabled));
        sb.append(", isTransportMode=").append(String.valueOf(this.isTransportMode));
        sb.append(", customerBgpAsn=").append(String.valueOf(this.customerBgpAsn));
        sb.append(", customerAsn=").append(String.valueOf(this.customerAsn));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", gatewayId=").append(String.valueOf(this.gatewayId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", oracleBgpAsn=").append(String.valueOf(this.oracleBgpAsn));
        sb.append(", providerName=").append(String.valueOf(this.providerName));
        sb.append(", providerServiceId=").append(String.valueOf(this.providerServiceId));
        sb.append(", providerServiceKeyName=").append(String.valueOf(this.providerServiceKeyName));
        sb.append(", providerServiceName=").append(String.valueOf(this.providerServiceName));
        sb.append(", providerState=").append(String.valueOf((Object)this.providerState));
        sb.append(", publicPrefixes=").append(String.valueOf(this.publicPrefixes));
        sb.append(", referenceComment=").append(String.valueOf(this.referenceComment));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", serviceType=").append(String.valueOf((Object)this.serviceType));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", ipMtu=").append(String.valueOf((Object)this.ipMtu));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualCircuit)) {
            return false;
        }
        VirtualCircuit other = (VirtualCircuit)((Object)o);
        return Objects.equals(this.bandwidthShapeName, other.bandwidthShapeName) && Objects.equals((Object)this.bgpManagement, (Object)other.bgpManagement) && Objects.equals((Object)this.bgpSessionState, (Object)other.bgpSessionState) && Objects.equals((Object)this.bgpIpv6SessionState, (Object)other.bgpIpv6SessionState) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.crossConnectMappings, other.crossConnectMappings) && Objects.equals(this.routingPolicy, other.routingPolicy) && Objects.equals((Object)this.bgpAdminState, (Object)other.bgpAdminState) && Objects.equals(this.isBfdEnabled, other.isBfdEnabled) && Objects.equals(this.isTransportMode, other.isTransportMode) && Objects.equals(this.customerBgpAsn, other.customerBgpAsn) && Objects.equals(this.customerAsn, other.customerAsn) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.gatewayId, other.gatewayId) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.oracleBgpAsn, other.oracleBgpAsn) && Objects.equals(this.providerName, other.providerName) && Objects.equals(this.providerServiceId, other.providerServiceId) && Objects.equals(this.providerServiceKeyName, other.providerServiceKeyName) && Objects.equals(this.providerServiceName, other.providerServiceName) && Objects.equals((Object)this.providerState, (Object)other.providerState) && Objects.equals(this.publicPrefixes, other.publicPrefixes) && Objects.equals(this.referenceComment, other.referenceComment) && Objects.equals(this.region, other.region) && Objects.equals((Object)this.serviceType, (Object)other.serviceType) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.ipMtu, (Object)other.ipMtu) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bandwidthShapeName == null ? 43 : this.bandwidthShapeName.hashCode());
        result = result * 59 + (this.bgpManagement == null ? 43 : this.bgpManagement.hashCode());
        result = result * 59 + (this.bgpSessionState == null ? 43 : this.bgpSessionState.hashCode());
        result = result * 59 + (this.bgpIpv6SessionState == null ? 43 : this.bgpIpv6SessionState.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.crossConnectMappings == null ? 43 : this.crossConnectMappings.hashCode());
        result = result * 59 + (this.routingPolicy == null ? 43 : this.routingPolicy.hashCode());
        result = result * 59 + (this.bgpAdminState == null ? 43 : this.bgpAdminState.hashCode());
        result = result * 59 + (this.isBfdEnabled == null ? 43 : this.isBfdEnabled.hashCode());
        result = result * 59 + (this.isTransportMode == null ? 43 : this.isTransportMode.hashCode());
        result = result * 59 + (this.customerBgpAsn == null ? 43 : this.customerBgpAsn.hashCode());
        result = result * 59 + (this.customerAsn == null ? 43 : this.customerAsn.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.gatewayId == null ? 43 : this.gatewayId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.oracleBgpAsn == null ? 43 : this.oracleBgpAsn.hashCode());
        result = result * 59 + (this.providerName == null ? 43 : this.providerName.hashCode());
        result = result * 59 + (this.providerServiceId == null ? 43 : this.providerServiceId.hashCode());
        result = result * 59 + (this.providerServiceKeyName == null ? 43 : this.providerServiceKeyName.hashCode());
        result = result * 59 + (this.providerServiceName == null ? 43 : this.providerServiceName.hashCode());
        result = result * 59 + (this.providerState == null ? 43 : this.providerState.hashCode());
        result = result * 59 + (this.publicPrefixes == null ? 43 : this.publicPrefixes.hashCode());
        result = result * 59 + (this.referenceComment == null ? 43 : this.referenceComment.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.serviceType == null ? 43 : this.serviceType.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.ipMtu == null ? 43 : this.ipMtu.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Public("PUBLIC"),
        Private("PRIVATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ServiceType implements BmcEnum
    {
        Colocated("COLOCATED"),
        Layer2("LAYER2"),
        Layer3("LAYER3"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ServiceType> map;

        private ServiceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServiceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ServiceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ServiceType.class);
            map = new HashMap<String, ServiceType>();
            for (ServiceType v : ServiceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProviderState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProviderState> map;

        private ProviderState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProviderState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProviderState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProviderState.class);
            map = new HashMap<String, ProviderState>();
            for (ProviderState v : ProviderState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        PendingProvider("PENDING_PROVIDER"),
        Verifying("VERIFYING"),
        Provisioning("PROVISIONING"),
        Provisioned("PROVISIONED"),
        Failed("FAILED"),
        Inactive("INACTIVE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BgpAdminState implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BgpAdminState> map;

        private BgpAdminState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BgpAdminState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BgpAdminState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BgpAdminState.class);
            map = new HashMap<String, BgpAdminState>();
            for (BgpAdminState v : BgpAdminState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RoutingPolicy implements BmcEnum
    {
        OracleServiceNetwork("ORACLE_SERVICE_NETWORK"),
        Regional("REGIONAL"),
        MarketLevel("MARKET_LEVEL"),
        Global("GLOBAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RoutingPolicy> map;

        private RoutingPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RoutingPolicy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RoutingPolicy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RoutingPolicy.class);
            map = new HashMap<String, RoutingPolicy>();
            for (RoutingPolicy v : RoutingPolicy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BgpIpv6SessionState implements BmcEnum
    {
        Up("UP"),
        Down("DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BgpIpv6SessionState> map;

        private BgpIpv6SessionState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BgpIpv6SessionState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BgpIpv6SessionState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BgpIpv6SessionState.class);
            map = new HashMap<String, BgpIpv6SessionState>();
            for (BgpIpv6SessionState v : BgpIpv6SessionState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BgpSessionState implements BmcEnum
    {
        Up("UP"),
        Down("DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BgpSessionState> map;

        private BgpSessionState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BgpSessionState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BgpSessionState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BgpSessionState.class);
            map = new HashMap<String, BgpSessionState>();
            for (BgpSessionState v : BgpSessionState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BgpManagement implements BmcEnum
    {
        CustomerManaged("CUSTOMER_MANAGED"),
        ProviderManaged("PROVIDER_MANAGED"),
        OracleManaged("ORACLE_MANAGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BgpManagement> map;

        private BgpManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BgpManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BgpManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BgpManagement.class);
            map = new HashMap<String, BgpManagement>();
            for (BgpManagement v : BgpManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bandwidthShapeName")
        private String bandwidthShapeName;
        @JsonProperty(value="bgpManagement")
        private BgpManagement bgpManagement;
        @JsonProperty(value="bgpSessionState")
        private BgpSessionState bgpSessionState;
        @JsonProperty(value="bgpIpv6SessionState")
        private BgpIpv6SessionState bgpIpv6SessionState;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="crossConnectMappings")
        private List<CrossConnectMapping> crossConnectMappings;
        @JsonProperty(value="routingPolicy")
        private List<RoutingPolicy> routingPolicy;
        @JsonProperty(value="bgpAdminState")
        private BgpAdminState bgpAdminState;
        @JsonProperty(value="isBfdEnabled")
        private Boolean isBfdEnabled;
        @JsonProperty(value="isTransportMode")
        private Boolean isTransportMode;
        @JsonProperty(value="customerBgpAsn")
        private Integer customerBgpAsn;
        @JsonProperty(value="customerAsn")
        private Long customerAsn;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="gatewayId")
        private String gatewayId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="oracleBgpAsn")
        private Integer oracleBgpAsn;
        @JsonProperty(value="providerName")
        private String providerName;
        @JsonProperty(value="providerServiceId")
        private String providerServiceId;
        @JsonProperty(value="providerServiceKeyName")
        private String providerServiceKeyName;
        @JsonProperty(value="providerServiceName")
        private String providerServiceName;
        @JsonProperty(value="providerState")
        private ProviderState providerState;
        @JsonProperty(value="publicPrefixes")
        private List<String> publicPrefixes;
        @JsonProperty(value="referenceComment")
        private String referenceComment;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="serviceType")
        private ServiceType serviceType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="ipMtu")
        private VirtualCircuitIpMtu ipMtu;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bandwidthShapeName(String bandwidthShapeName) {
            this.bandwidthShapeName = bandwidthShapeName;
            this.__explicitlySet__.add("bandwidthShapeName");
            return this;
        }

        public Builder bgpManagement(BgpManagement bgpManagement) {
            this.bgpManagement = bgpManagement;
            this.__explicitlySet__.add("bgpManagement");
            return this;
        }

        public Builder bgpSessionState(BgpSessionState bgpSessionState) {
            this.bgpSessionState = bgpSessionState;
            this.__explicitlySet__.add("bgpSessionState");
            return this;
        }

        public Builder bgpIpv6SessionState(BgpIpv6SessionState bgpIpv6SessionState) {
            this.bgpIpv6SessionState = bgpIpv6SessionState;
            this.__explicitlySet__.add("bgpIpv6SessionState");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder crossConnectMappings(List<CrossConnectMapping> crossConnectMappings) {
            this.crossConnectMappings = crossConnectMappings;
            this.__explicitlySet__.add("crossConnectMappings");
            return this;
        }

        public Builder routingPolicy(List<RoutingPolicy> routingPolicy) {
            this.routingPolicy = routingPolicy;
            this.__explicitlySet__.add("routingPolicy");
            return this;
        }

        public Builder bgpAdminState(BgpAdminState bgpAdminState) {
            this.bgpAdminState = bgpAdminState;
            this.__explicitlySet__.add("bgpAdminState");
            return this;
        }

        public Builder isBfdEnabled(Boolean isBfdEnabled) {
            this.isBfdEnabled = isBfdEnabled;
            this.__explicitlySet__.add("isBfdEnabled");
            return this;
        }

        public Builder isTransportMode(Boolean isTransportMode) {
            this.isTransportMode = isTransportMode;
            this.__explicitlySet__.add("isTransportMode");
            return this;
        }

        public Builder customerBgpAsn(Integer customerBgpAsn) {
            this.customerBgpAsn = customerBgpAsn;
            this.__explicitlySet__.add("customerBgpAsn");
            return this;
        }

        public Builder customerAsn(Long customerAsn) {
            this.customerAsn = customerAsn;
            this.__explicitlySet__.add("customerAsn");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            this.__explicitlySet__.add("gatewayId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder oracleBgpAsn(Integer oracleBgpAsn) {
            this.oracleBgpAsn = oracleBgpAsn;
            this.__explicitlySet__.add("oracleBgpAsn");
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            this.__explicitlySet__.add("providerName");
            return this;
        }

        public Builder providerServiceId(String providerServiceId) {
            this.providerServiceId = providerServiceId;
            this.__explicitlySet__.add("providerServiceId");
            return this;
        }

        public Builder providerServiceKeyName(String providerServiceKeyName) {
            this.providerServiceKeyName = providerServiceKeyName;
            this.__explicitlySet__.add("providerServiceKeyName");
            return this;
        }

        public Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            this.__explicitlySet__.add("providerServiceName");
            return this;
        }

        public Builder providerState(ProviderState providerState) {
            this.providerState = providerState;
            this.__explicitlySet__.add("providerState");
            return this;
        }

        public Builder publicPrefixes(List<String> publicPrefixes) {
            this.publicPrefixes = publicPrefixes;
            this.__explicitlySet__.add("publicPrefixes");
            return this;
        }

        public Builder referenceComment(String referenceComment) {
            this.referenceComment = referenceComment;
            this.__explicitlySet__.add("referenceComment");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder serviceType(ServiceType serviceType) {
            this.serviceType = serviceType;
            this.__explicitlySet__.add("serviceType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder ipMtu(VirtualCircuitIpMtu ipMtu) {
            this.ipMtu = ipMtu;
            this.__explicitlySet__.add("ipMtu");
            return this;
        }

        public VirtualCircuit build() {
            VirtualCircuit model = new VirtualCircuit(this.bandwidthShapeName, this.bgpManagement, this.bgpSessionState, this.bgpIpv6SessionState, this.compartmentId, this.crossConnectMappings, this.routingPolicy, this.bgpAdminState, this.isBfdEnabled, this.isTransportMode, this.customerBgpAsn, this.customerAsn, this.definedTags, this.displayName, this.freeformTags, this.gatewayId, this.id, this.lifecycleState, this.oracleBgpAsn, this.providerName, this.providerServiceId, this.providerServiceKeyName, this.providerServiceName, this.providerState, this.publicPrefixes, this.referenceComment, this.region, this.serviceType, this.timeCreated, this.type, this.ipMtu);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VirtualCircuit model) {
            if (model.wasPropertyExplicitlySet("bandwidthShapeName")) {
                this.bandwidthShapeName(model.getBandwidthShapeName());
            }
            if (model.wasPropertyExplicitlySet("bgpManagement")) {
                this.bgpManagement(model.getBgpManagement());
            }
            if (model.wasPropertyExplicitlySet("bgpSessionState")) {
                this.bgpSessionState(model.getBgpSessionState());
            }
            if (model.wasPropertyExplicitlySet("bgpIpv6SessionState")) {
                this.bgpIpv6SessionState(model.getBgpIpv6SessionState());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("crossConnectMappings")) {
                this.crossConnectMappings(model.getCrossConnectMappings());
            }
            if (model.wasPropertyExplicitlySet("routingPolicy")) {
                this.routingPolicy(model.getRoutingPolicy());
            }
            if (model.wasPropertyExplicitlySet("bgpAdminState")) {
                this.bgpAdminState(model.getBgpAdminState());
            }
            if (model.wasPropertyExplicitlySet("isBfdEnabled")) {
                this.isBfdEnabled(model.getIsBfdEnabled());
            }
            if (model.wasPropertyExplicitlySet("isTransportMode")) {
                this.isTransportMode(model.getIsTransportMode());
            }
            if (model.wasPropertyExplicitlySet("customerBgpAsn")) {
                this.customerBgpAsn(model.getCustomerBgpAsn());
            }
            if (model.wasPropertyExplicitlySet("customerAsn")) {
                this.customerAsn(model.getCustomerAsn());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("gatewayId")) {
                this.gatewayId(model.getGatewayId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("oracleBgpAsn")) {
                this.oracleBgpAsn(model.getOracleBgpAsn());
            }
            if (model.wasPropertyExplicitlySet("providerName")) {
                this.providerName(model.getProviderName());
            }
            if (model.wasPropertyExplicitlySet("providerServiceId")) {
                this.providerServiceId(model.getProviderServiceId());
            }
            if (model.wasPropertyExplicitlySet("providerServiceKeyName")) {
                this.providerServiceKeyName(model.getProviderServiceKeyName());
            }
            if (model.wasPropertyExplicitlySet("providerServiceName")) {
                this.providerServiceName(model.getProviderServiceName());
            }
            if (model.wasPropertyExplicitlySet("providerState")) {
                this.providerState(model.getProviderState());
            }
            if (model.wasPropertyExplicitlySet("publicPrefixes")) {
                this.publicPrefixes(model.getPublicPrefixes());
            }
            if (model.wasPropertyExplicitlySet("referenceComment")) {
                this.referenceComment(model.getReferenceComment());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("serviceType")) {
                this.serviceType(model.getServiceType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("ipMtu")) {
                this.ipMtu(model.getIpMtu());
            }
            return this;
        }
    }
}

