/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.DrgAttachmentNetworkDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class VcnDrgAttachmentNetworkDetails
extends DrgAttachmentNetworkDetails {
    @JsonProperty(value="routeTableId")
    private final String routeTableId;
    @JsonProperty(value="vcnRouteType")
    private final VcnRouteType vcnRouteType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VcnDrgAttachmentNetworkDetails(String id, String routeTableId, VcnRouteType vcnRouteType) {
        super(id);
        this.routeTableId = routeTableId;
        this.vcnRouteType = vcnRouteType;
    }

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public VcnRouteType getVcnRouteType() {
        return this.vcnRouteType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VcnDrgAttachmentNetworkDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", routeTableId=").append(String.valueOf(this.routeTableId));
        sb.append(", vcnRouteType=").append(String.valueOf((Object)this.vcnRouteType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VcnDrgAttachmentNetworkDetails)) {
            return false;
        }
        VcnDrgAttachmentNetworkDetails other = (VcnDrgAttachmentNetworkDetails)((Object)o);
        return Objects.equals(this.routeTableId, other.routeTableId) && Objects.equals((Object)this.vcnRouteType, (Object)other.vcnRouteType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.routeTableId == null ? 43 : this.routeTableId.hashCode());
        result = result * 59 + (this.vcnRouteType == null ? 43 : this.vcnRouteType.hashCode());
        return result;
    }

    public static enum VcnRouteType implements BmcEnum
    {
        VcnCidrs("VCN_CIDRS"),
        SubnetCidrs("SUBNET_CIDRS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, VcnRouteType> map;

        private VcnRouteType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static VcnRouteType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'VcnRouteType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(VcnRouteType.class);
            map = new HashMap<String, VcnRouteType>();
            for (VcnRouteType v : VcnRouteType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="routeTableId")
        private String routeTableId;
        @JsonProperty(value="vcnRouteType")
        private VcnRouteType vcnRouteType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            this.__explicitlySet__.add("routeTableId");
            return this;
        }

        public Builder vcnRouteType(VcnRouteType vcnRouteType) {
            this.vcnRouteType = vcnRouteType;
            this.__explicitlySet__.add("vcnRouteType");
            return this;
        }

        public VcnDrgAttachmentNetworkDetails build() {
            VcnDrgAttachmentNetworkDetails model = new VcnDrgAttachmentNetworkDetails(this.id, this.routeTableId, this.vcnRouteType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VcnDrgAttachmentNetworkDetails model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("routeTableId")) {
                this.routeTableId(model.getRouteTableId());
            }
            if (model.wasPropertyExplicitlySet("vcnRouteType")) {
                this.vcnRouteType(model.getVcnRouteType());
            }
            return this;
        }
    }
}

