/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BgpSessionInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="oracleInterfaceIp")
    private final String oracleInterfaceIp;
    @JsonProperty(value="customerInterfaceIp")
    private final String customerInterfaceIp;
    @JsonProperty(value="oracleInterfaceIpv6")
    private final String oracleInterfaceIpv6;
    @JsonProperty(value="customerInterfaceIpv6")
    private final String customerInterfaceIpv6;
    @JsonProperty(value="oracleBgpAsn")
    private final String oracleBgpAsn;
    @JsonProperty(value="customerBgpAsn")
    private final String customerBgpAsn;
    @JsonProperty(value="bgpState")
    private final BgpState bgpState;
    @JsonProperty(value="bgpIpv6State")
    private final BgpIpv6State bgpIpv6State;

    @Deprecated
    @ConstructorProperties(value={"oracleInterfaceIp", "customerInterfaceIp", "oracleInterfaceIpv6", "customerInterfaceIpv6", "oracleBgpAsn", "customerBgpAsn", "bgpState", "bgpIpv6State"})
    public BgpSessionInfo(String oracleInterfaceIp, String customerInterfaceIp, String oracleInterfaceIpv6, String customerInterfaceIpv6, String oracleBgpAsn, String customerBgpAsn, BgpState bgpState, BgpIpv6State bgpIpv6State) {
        this.oracleInterfaceIp = oracleInterfaceIp;
        this.customerInterfaceIp = customerInterfaceIp;
        this.oracleInterfaceIpv6 = oracleInterfaceIpv6;
        this.customerInterfaceIpv6 = customerInterfaceIpv6;
        this.oracleBgpAsn = oracleBgpAsn;
        this.customerBgpAsn = customerBgpAsn;
        this.bgpState = bgpState;
        this.bgpIpv6State = bgpIpv6State;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOracleInterfaceIp() {
        return this.oracleInterfaceIp;
    }

    public String getCustomerInterfaceIp() {
        return this.customerInterfaceIp;
    }

    public String getOracleInterfaceIpv6() {
        return this.oracleInterfaceIpv6;
    }

    public String getCustomerInterfaceIpv6() {
        return this.customerInterfaceIpv6;
    }

    public String getOracleBgpAsn() {
        return this.oracleBgpAsn;
    }

    public String getCustomerBgpAsn() {
        return this.customerBgpAsn;
    }

    public BgpState getBgpState() {
        return this.bgpState;
    }

    public BgpIpv6State getBgpIpv6State() {
        return this.bgpIpv6State;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BgpSessionInfo(");
        sb.append("super=").append(super.toString());
        sb.append("oracleInterfaceIp=").append(String.valueOf(this.oracleInterfaceIp));
        sb.append(", customerInterfaceIp=").append(String.valueOf(this.customerInterfaceIp));
        sb.append(", oracleInterfaceIpv6=").append(String.valueOf(this.oracleInterfaceIpv6));
        sb.append(", customerInterfaceIpv6=").append(String.valueOf(this.customerInterfaceIpv6));
        sb.append(", oracleBgpAsn=").append(String.valueOf(this.oracleBgpAsn));
        sb.append(", customerBgpAsn=").append(String.valueOf(this.customerBgpAsn));
        sb.append(", bgpState=").append(String.valueOf((Object)this.bgpState));
        sb.append(", bgpIpv6State=").append(String.valueOf((Object)this.bgpIpv6State));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BgpSessionInfo)) {
            return false;
        }
        BgpSessionInfo other = (BgpSessionInfo)((Object)o);
        return Objects.equals(this.oracleInterfaceIp, other.oracleInterfaceIp) && Objects.equals(this.customerInterfaceIp, other.customerInterfaceIp) && Objects.equals(this.oracleInterfaceIpv6, other.oracleInterfaceIpv6) && Objects.equals(this.customerInterfaceIpv6, other.customerInterfaceIpv6) && Objects.equals(this.oracleBgpAsn, other.oracleBgpAsn) && Objects.equals(this.customerBgpAsn, other.customerBgpAsn) && Objects.equals((Object)this.bgpState, (Object)other.bgpState) && Objects.equals((Object)this.bgpIpv6State, (Object)other.bgpIpv6State) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.oracleInterfaceIp == null ? 43 : this.oracleInterfaceIp.hashCode());
        result = result * 59 + (this.customerInterfaceIp == null ? 43 : this.customerInterfaceIp.hashCode());
        result = result * 59 + (this.oracleInterfaceIpv6 == null ? 43 : this.oracleInterfaceIpv6.hashCode());
        result = result * 59 + (this.customerInterfaceIpv6 == null ? 43 : this.customerInterfaceIpv6.hashCode());
        result = result * 59 + (this.oracleBgpAsn == null ? 43 : this.oracleBgpAsn.hashCode());
        result = result * 59 + (this.customerBgpAsn == null ? 43 : this.customerBgpAsn.hashCode());
        result = result * 59 + (this.bgpState == null ? 43 : this.bgpState.hashCode());
        result = result * 59 + (this.bgpIpv6State == null ? 43 : this.bgpIpv6State.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BgpIpv6State implements BmcEnum
    {
        Up("UP"),
        Down("DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BgpIpv6State> map;

        private BgpIpv6State(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BgpIpv6State create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BgpIpv6State', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BgpIpv6State.class);
            map = new HashMap<String, BgpIpv6State>();
            for (BgpIpv6State v : BgpIpv6State.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BgpState implements BmcEnum
    {
        Up("UP"),
        Down("DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BgpState> map;

        private BgpState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BgpState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BgpState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BgpState.class);
            map = new HashMap<String, BgpState>();
            for (BgpState v : BgpState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="oracleInterfaceIp")
        private String oracleInterfaceIp;
        @JsonProperty(value="customerInterfaceIp")
        private String customerInterfaceIp;
        @JsonProperty(value="oracleInterfaceIpv6")
        private String oracleInterfaceIpv6;
        @JsonProperty(value="customerInterfaceIpv6")
        private String customerInterfaceIpv6;
        @JsonProperty(value="oracleBgpAsn")
        private String oracleBgpAsn;
        @JsonProperty(value="customerBgpAsn")
        private String customerBgpAsn;
        @JsonProperty(value="bgpState")
        private BgpState bgpState;
        @JsonProperty(value="bgpIpv6State")
        private BgpIpv6State bgpIpv6State;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder oracleInterfaceIp(String oracleInterfaceIp) {
            this.oracleInterfaceIp = oracleInterfaceIp;
            this.__explicitlySet__.add("oracleInterfaceIp");
            return this;
        }

        public Builder customerInterfaceIp(String customerInterfaceIp) {
            this.customerInterfaceIp = customerInterfaceIp;
            this.__explicitlySet__.add("customerInterfaceIp");
            return this;
        }

        public Builder oracleInterfaceIpv6(String oracleInterfaceIpv6) {
            this.oracleInterfaceIpv6 = oracleInterfaceIpv6;
            this.__explicitlySet__.add("oracleInterfaceIpv6");
            return this;
        }

        public Builder customerInterfaceIpv6(String customerInterfaceIpv6) {
            this.customerInterfaceIpv6 = customerInterfaceIpv6;
            this.__explicitlySet__.add("customerInterfaceIpv6");
            return this;
        }

        public Builder oracleBgpAsn(String oracleBgpAsn) {
            this.oracleBgpAsn = oracleBgpAsn;
            this.__explicitlySet__.add("oracleBgpAsn");
            return this;
        }

        public Builder customerBgpAsn(String customerBgpAsn) {
            this.customerBgpAsn = customerBgpAsn;
            this.__explicitlySet__.add("customerBgpAsn");
            return this;
        }

        public Builder bgpState(BgpState bgpState) {
            this.bgpState = bgpState;
            this.__explicitlySet__.add("bgpState");
            return this;
        }

        public Builder bgpIpv6State(BgpIpv6State bgpIpv6State) {
            this.bgpIpv6State = bgpIpv6State;
            this.__explicitlySet__.add("bgpIpv6State");
            return this;
        }

        public BgpSessionInfo build() {
            BgpSessionInfo model = new BgpSessionInfo(this.oracleInterfaceIp, this.customerInterfaceIp, this.oracleInterfaceIpv6, this.customerInterfaceIpv6, this.oracleBgpAsn, this.customerBgpAsn, this.bgpState, this.bgpIpv6State);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BgpSessionInfo model) {
            if (model.wasPropertyExplicitlySet("oracleInterfaceIp")) {
                this.oracleInterfaceIp(model.getOracleInterfaceIp());
            }
            if (model.wasPropertyExplicitlySet("customerInterfaceIp")) {
                this.customerInterfaceIp(model.getCustomerInterfaceIp());
            }
            if (model.wasPropertyExplicitlySet("oracleInterfaceIpv6")) {
                this.oracleInterfaceIpv6(model.getOracleInterfaceIpv6());
            }
            if (model.wasPropertyExplicitlySet("customerInterfaceIpv6")) {
                this.customerInterfaceIpv6(model.getCustomerInterfaceIpv6());
            }
            if (model.wasPropertyExplicitlySet("oracleBgpAsn")) {
                this.oracleBgpAsn(model.getOracleBgpAsn());
            }
            if (model.wasPropertyExplicitlySet("customerBgpAsn")) {
                this.customerBgpAsn(model.getCustomerBgpAsn());
            }
            if (model.wasPropertyExplicitlySet("bgpState")) {
                this.bgpState(model.getBgpState());
            }
            if (model.wasPropertyExplicitlySet("bgpIpv6State")) {
                this.bgpIpv6State(model.getBgpIpv6State());
            }
            return this;
        }
    }
}

