/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.FunctionMapper;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import jakarta.faces.el.CompositeComponentExpressionHolder;
import jakarta.faces.validator.ValueReference;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Locale;

class ValueExpressionAnalyzer {
    private ValueExpression expression;

    public ValueExpressionAnalyzer(ValueExpression expression) {
        this.expression = expression;
    }

    public ValueReference getReference(ELContext elContext) {
        ValueExpression ve;
        Object base;
        InterceptingResolver resolver = new InterceptingResolver(elContext.getELResolver());
        try {
            this.expression.setValue(this.decorateELContext(elContext, resolver), null);
        }
        catch (ELException ele) {
            return null;
        }
        ValueReference reference = resolver.getValueReference();
        if (reference != null && (base = reference.getBase()) instanceof CompositeComponentExpressionHolder && (ve = ((CompositeComponentExpressionHolder)base).getExpression(reference.getProperty())) != null) {
            this.expression = ve;
            reference = this.getReference(elContext);
        }
        return reference;
    }

    private ELContext decorateELContext(final ELContext context, final ELResolver resolver) {
        return new ELContext(){

            @Override
            public ELResolver getELResolver() {
                return resolver;
            }

            public Object getContext(Class key) {
                return context.getContext(key);
            }

            @Override
            public Locale getLocale() {
                return context.getLocale();
            }

            @Override
            public boolean isPropertyResolved() {
                return context.isPropertyResolved();
            }

            public void putContext(Class key, Object contextObject) {
                context.putContext(key, contextObject);
            }

            @Override
            public void setLocale(Locale locale) {
                context.setLocale(locale);
            }

            @Override
            public void setPropertyResolved(boolean resolved) {
                context.setPropertyResolved(resolved);
            }

            @Override
            public FunctionMapper getFunctionMapper() {
                return context.getFunctionMapper();
            }

            @Override
            public VariableMapper getVariableMapper() {
                return context.getVariableMapper();
            }
        };
    }

    private static class InterceptingResolver
    extends ELResolver {
        private ELResolver delegate;
        private ValueReference valueReference;

        public InterceptingResolver(ELResolver delegate) {
            this.delegate = delegate;
        }

        public ValueReference getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (base != null && property != null) {
                context.setPropertyResolved(true);
                this.valueReference = new ValueReference(base, property.toString());
            }
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) {
            return this.delegate.getValue(context, base, property);
        }

        @Override
        public Class<?> getType(ELContext context, Object base, Object property) {
            return this.delegate.getType(context, base, property);
        }

        @Override
        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return this.delegate.isReadOnly(context, base, property);
        }

        @Override
        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return this.delegate.getFeatureDescriptors(context, base);
        }

        @Override
        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return this.delegate.getCommonPropertyType(context, base);
        }
    }
}

