/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.identity.model.Domain;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDomainsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String displayName;
    private String url;
    private String homeRegionUrl;
    private String type;
    private String licenseType;
    private Boolean isHiddenOnLogin;
    private String page;
    private Integer limit;
    private String name;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;
    private Domain.LifecycleState lifecycleState;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHomeRegionUrl() {
        return this.homeRegionUrl;
    }

    public String getType() {
        return this.type;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public Boolean getIsHiddenOnLogin() {
        return this.isHiddenOnLogin;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Domain.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).url(this.url).homeRegionUrl(this.homeRegionUrl).type(this.type).licenseType(this.licenseType).isHiddenOnLogin(this.isHiddenOnLogin).page(this.page).limit(this.limit).name(this.name).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",url=").append(String.valueOf(this.url));
        sb.append(",homeRegionUrl=").append(String.valueOf(this.homeRegionUrl));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",licenseType=").append(String.valueOf(this.licenseType));
        sb.append(",isHiddenOnLogin=").append(String.valueOf(this.isHiddenOnLogin));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.url, other.url) && Objects.equals(this.homeRegionUrl, other.homeRegionUrl) && Objects.equals(this.type, other.type) && Objects.equals(this.licenseType, other.licenseType) && Objects.equals(this.isHiddenOnLogin, other.isHiddenOnLogin) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.homeRegionUrl == null ? 43 : this.homeRegionUrl.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.isHiddenOnLogin == null ? 43 : this.isHiddenOnLogin.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDomainsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String displayName = null;
        private String url = null;
        private String homeRegionUrl = null;
        private String type = null;
        private String licenseType = null;
        private Boolean isHiddenOnLogin = null;
        private String page = null;
        private Integer limit = null;
        private String name = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;
        private Domain.LifecycleState lifecycleState = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder homeRegionUrl(String homeRegionUrl) {
            this.homeRegionUrl = homeRegionUrl;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public Builder isHiddenOnLogin(Boolean isHiddenOnLogin) {
            this.isHiddenOnLogin = isHiddenOnLogin;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lifecycleState(Domain.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDomainsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.url(o.getUrl());
            this.homeRegionUrl(o.getHomeRegionUrl());
            this.type(o.getType());
            this.licenseType(o.getLicenseType());
            this.isHiddenOnLogin(o.getIsHiddenOnLogin());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.name(o.getName());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDomainsRequest build() {
            ListDomainsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDomainsRequest buildWithoutInvocationCallback() {
            ListDomainsRequest request = new ListDomainsRequest();
            request.compartmentId = this.compartmentId;
            request.displayName = this.displayName;
            request.url = this.url;
            request.homeRegionUrl = this.homeRegionUrl;
            request.type = this.type;
            request.licenseType = this.licenseType;
            request.isHiddenOnLogin = this.isHiddenOnLogin;
            request.page = this.page;
            request.limit = this.limit;
            request.name = this.name;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

