/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.BulkMoveResourcesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BulkMoveResourcesRequest
extends BmcRequest<BulkMoveResourcesDetails> {
    private String compartmentId;
    private BulkMoveResourcesDetails bulkMoveResourcesDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public BulkMoveResourcesDetails getBulkMoveResourcesDetails() {
        return this.bulkMoveResourcesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public BulkMoveResourcesDetails getBody$() {
        return this.bulkMoveResourcesDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).bulkMoveResourcesDetails(this.bulkMoveResourcesDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",bulkMoveResourcesDetails=").append(String.valueOf((Object)this.bulkMoveResourcesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkMoveResourcesRequest)) {
            return false;
        }
        BulkMoveResourcesRequest other = (BulkMoveResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.bulkMoveResourcesDetails, (Object)other.bulkMoveResourcesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.bulkMoveResourcesDetails == null ? 43 : this.bulkMoveResourcesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkMoveResourcesRequest, BulkMoveResourcesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private BulkMoveResourcesDetails bulkMoveResourcesDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder bulkMoveResourcesDetails(BulkMoveResourcesDetails bulkMoveResourcesDetails) {
            this.bulkMoveResourcesDetails = bulkMoveResourcesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkMoveResourcesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.bulkMoveResourcesDetails(o.getBulkMoveResourcesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkMoveResourcesRequest build() {
            BulkMoveResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkMoveResourcesDetails body) {
            this.bulkMoveResourcesDetails(body);
            return this;
        }

        public BulkMoveResourcesRequest buildWithoutInvocationCallback() {
            BulkMoveResourcesRequest request = new BulkMoveResourcesRequest();
            request.compartmentId = this.compartmentId;
            request.bulkMoveResourcesDetails = this.bulkMoveResourcesDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

