/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class ListCommitsRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String refName;
    private String excludeRefName;
    private String filePath;
    private Date timestampGreaterThanOrEqualTo;
    private Date timestampLessThanOrEqualTo;
    private String commitMessage;
    private String authorName;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRefName() {
        return this.refName;
    }

    public String getExcludeRefName() {
        return this.excludeRefName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Date getTimestampGreaterThanOrEqualTo() {
        return this.timestampGreaterThanOrEqualTo;
    }

    public Date getTimestampLessThanOrEqualTo() {
        return this.timestampLessThanOrEqualTo;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).refName(this.refName).excludeRefName(this.excludeRefName).filePath(this.filePath).timestampGreaterThanOrEqualTo(this.timestampGreaterThanOrEqualTo).timestampLessThanOrEqualTo(this.timestampLessThanOrEqualTo).commitMessage(this.commitMessage).authorName(this.authorName).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",refName=").append(String.valueOf(this.refName));
        sb.append(",excludeRefName=").append(String.valueOf(this.excludeRefName));
        sb.append(",filePath=").append(String.valueOf(this.filePath));
        sb.append(",timestampGreaterThanOrEqualTo=").append(String.valueOf(this.timestampGreaterThanOrEqualTo));
        sb.append(",timestampLessThanOrEqualTo=").append(String.valueOf(this.timestampLessThanOrEqualTo));
        sb.append(",commitMessage=").append(String.valueOf(this.commitMessage));
        sb.append(",authorName=").append(String.valueOf(this.authorName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListCommitsRequest)) {
            return false;
        }
        ListCommitsRequest other = (ListCommitsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.refName, other.refName) && Objects.equals(this.excludeRefName, other.excludeRefName) && Objects.equals(this.filePath, other.filePath) && Objects.equals(this.timestampGreaterThanOrEqualTo, other.timestampGreaterThanOrEqualTo) && Objects.equals(this.timestampLessThanOrEqualTo, other.timestampLessThanOrEqualTo) && Objects.equals(this.commitMessage, other.commitMessage) && Objects.equals(this.authorName, other.authorName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.refName == null ? 43 : this.refName.hashCode());
        result = result * 59 + (this.excludeRefName == null ? 43 : this.excludeRefName.hashCode());
        result = result * 59 + (this.filePath == null ? 43 : this.filePath.hashCode());
        result = result * 59 + (this.timestampGreaterThanOrEqualTo == null ? 43 : this.timestampGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timestampLessThanOrEqualTo == null ? 43 : this.timestampLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.commitMessage == null ? 43 : this.commitMessage.hashCode());
        result = result * 59 + (this.authorName == null ? 43 : this.authorName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListCommitsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private String refName = null;
        private String excludeRefName = null;
        private String filePath = null;
        private Date timestampGreaterThanOrEqualTo = null;
        private Date timestampLessThanOrEqualTo = null;
        private String commitMessage = null;
        private String authorName = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder refName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder excludeRefName(String excludeRefName) {
            this.excludeRefName = excludeRefName;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder timestampGreaterThanOrEqualTo(Date timestampGreaterThanOrEqualTo) {
            this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder timestampLessThanOrEqualTo(Date timestampLessThanOrEqualTo) {
            this.timestampLessThanOrEqualTo = timestampLessThanOrEqualTo;
            return this;
        }

        public Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListCommitsRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.refName(o.getRefName());
            this.excludeRefName(o.getExcludeRefName());
            this.filePath(o.getFilePath());
            this.timestampGreaterThanOrEqualTo(o.getTimestampGreaterThanOrEqualTo());
            this.timestampLessThanOrEqualTo(o.getTimestampLessThanOrEqualTo());
            this.commitMessage(o.getCommitMessage());
            this.authorName(o.getAuthorName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListCommitsRequest build() {
            ListCommitsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListCommitsRequest buildWithoutInvocationCallback() {
            ListCommitsRequest request = new ListCommitsRequest();
            request.repositoryId = this.repositoryId;
            request.refName = this.refName;
            request.excludeRefName = this.excludeRefName;
            request.filePath = this.filePath;
            request.timestampGreaterThanOrEqualTo = this.timestampGreaterThanOrEqualTo;
            request.timestampLessThanOrEqualTo = this.timestampLessThanOrEqualTo;
            request.commitMessage = this.commitMessage;
            request.authorName = this.authorName;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

