/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DiffSection;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiffChunk
extends ExplicitlySetBmcModel {
    @JsonProperty(value="baseLine")
    private final Integer baseLine;
    @JsonProperty(value="baseSpan")
    private final Integer baseSpan;
    @JsonProperty(value="targetLine")
    private final Integer targetLine;
    @JsonProperty(value="targetSpan")
    private final Integer targetSpan;
    @JsonProperty(value="diffSections")
    private final List<DiffSection> diffSections;

    @Deprecated
    @ConstructorProperties(value={"baseLine", "baseSpan", "targetLine", "targetSpan", "diffSections"})
    public DiffChunk(Integer baseLine, Integer baseSpan, Integer targetLine, Integer targetSpan, List<DiffSection> diffSections) {
        this.baseLine = baseLine;
        this.baseSpan = baseSpan;
        this.targetLine = targetLine;
        this.targetSpan = targetSpan;
        this.diffSections = diffSections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getBaseLine() {
        return this.baseLine;
    }

    public Integer getBaseSpan() {
        return this.baseSpan;
    }

    public Integer getTargetLine() {
        return this.targetLine;
    }

    public Integer getTargetSpan() {
        return this.targetSpan;
    }

    public List<DiffSection> getDiffSections() {
        return this.diffSections;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiffChunk(");
        sb.append("super=").append(super.toString());
        sb.append("baseLine=").append(String.valueOf(this.baseLine));
        sb.append(", baseSpan=").append(String.valueOf(this.baseSpan));
        sb.append(", targetLine=").append(String.valueOf(this.targetLine));
        sb.append(", targetSpan=").append(String.valueOf(this.targetSpan));
        sb.append(", diffSections=").append(String.valueOf(this.diffSections));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffChunk)) {
            return false;
        }
        DiffChunk other = (DiffChunk)((Object)o);
        return Objects.equals(this.baseLine, other.baseLine) && Objects.equals(this.baseSpan, other.baseSpan) && Objects.equals(this.targetLine, other.targetLine) && Objects.equals(this.targetSpan, other.targetSpan) && Objects.equals(this.diffSections, other.diffSections) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.baseLine == null ? 43 : this.baseLine.hashCode());
        result = result * 59 + (this.baseSpan == null ? 43 : this.baseSpan.hashCode());
        result = result * 59 + (this.targetLine == null ? 43 : this.targetLine.hashCode());
        result = result * 59 + (this.targetSpan == null ? 43 : this.targetSpan.hashCode());
        result = result * 59 + (this.diffSections == null ? 43 : this.diffSections.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="baseLine")
        private Integer baseLine;
        @JsonProperty(value="baseSpan")
        private Integer baseSpan;
        @JsonProperty(value="targetLine")
        private Integer targetLine;
        @JsonProperty(value="targetSpan")
        private Integer targetSpan;
        @JsonProperty(value="diffSections")
        private List<DiffSection> diffSections;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder baseLine(Integer baseLine) {
            this.baseLine = baseLine;
            this.__explicitlySet__.add("baseLine");
            return this;
        }

        public Builder baseSpan(Integer baseSpan) {
            this.baseSpan = baseSpan;
            this.__explicitlySet__.add("baseSpan");
            return this;
        }

        public Builder targetLine(Integer targetLine) {
            this.targetLine = targetLine;
            this.__explicitlySet__.add("targetLine");
            return this;
        }

        public Builder targetSpan(Integer targetSpan) {
            this.targetSpan = targetSpan;
            this.__explicitlySet__.add("targetSpan");
            return this;
        }

        public Builder diffSections(List<DiffSection> diffSections) {
            this.diffSections = diffSections;
            this.__explicitlySet__.add("diffSections");
            return this;
        }

        public DiffChunk build() {
            DiffChunk model = new DiffChunk(this.baseLine, this.baseSpan, this.targetLine, this.targetSpan, this.diffSections);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiffChunk model) {
            if (model.wasPropertyExplicitlySet("baseLine")) {
                this.baseLine(model.getBaseLine());
            }
            if (model.wasPropertyExplicitlySet("baseSpan")) {
                this.baseSpan(model.getBaseSpan());
            }
            if (model.wasPropertyExplicitlySet("targetLine")) {
                this.targetLine(model.getTargetLine());
            }
            if (model.wasPropertyExplicitlySet("targetSpan")) {
                this.targetSpan(model.getTargetSpan());
            }
            if (model.wasPropertyExplicitlySet("diffSections")) {
                this.diffSections(model.getDiffSections());
            }
            return this;
        }
    }
}

