/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation2;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class GenericModuleInfoAccessibilityQuery
implements AccessibilityQueryImplementation2 {
    private static final Logger LOG = Logger.getLogger(GenericModuleInfoAccessibilityQuery.class.getName());
    private final Map<ClassPath, Reference<ClassPathListener>> sourcePath2Listener = new WeakHashMap<ClassPath, Reference<ClassPathListener>>();
    private final Map<FileObject, Reference<AccessibilityQueryImplementation2.Result>> path2Result = new HashMap<FileObject, Reference<AccessibilityQueryImplementation2.Result>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityQueryImplementation2.Result isPubliclyAccessible(FileObject folder) {
        AccessibilityQueryImplementation2.Result result;
        GenericModuleInfoAccessibilityQuery genericModuleInfoAccessibilityQuery = this;
        synchronized (genericModuleInfoAccessibilityQuery) {
            Reference<AccessibilityQueryImplementation2.Result> ref = this.path2Result.get(folder);
            AccessibilityQueryImplementation2.Result result2 = result = ref != null ? ref.get() : null;
            if (result != null) {
                return result;
            }
        }
        Project p = FileOwnerQuery.getOwner((FileObject)folder);
        if (p != null && (p.getLookup().lookup(AccessibilityQueryImplementation2.class) != null || p.getLookup().lookup(AccessibilityQueryImplementation.class) != null)) {
            return null;
        }
        ClassPath sourcePath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (sourcePath == null) {
            return null;
        }
        GenericModuleInfoAccessibilityQuery genericModuleInfoAccessibilityQuery2 = this;
        synchronized (genericModuleInfoAccessibilityQuery2) {
            ClassPathListener cpl;
            Reference<AccessibilityQueryImplementation2.Result> ref = this.path2Result.get(folder);
            AccessibilityQueryImplementation2.Result result3 = result = ref != null ? ref.get() : null;
            if (result != null) {
                return result;
            }
            Reference<ClassPathListener> listenerRef = this.sourcePath2Listener.get(sourcePath);
            ClassPathListener classPathListener = cpl = listenerRef != null ? listenerRef.get() : null;
            if (cpl == null) {
                cpl = new ClassPathListener(sourcePath);
            }
            this.sourcePath2Listener.put(sourcePath, new WeakReference<ClassPathListener>(cpl));
            result = new ResultImpl(cpl, sourcePath, folder);
            this.path2Result.put(folder, new CleanPath2Result(result, folder));
            return result;
        }
    }

    private static final class ClassPathListener
    implements PropertyChangeListener {
        private static final RequestProcessor WORKER = new RequestProcessor(ClassPathListener.class.getName(), 1, false, false);
        private static final int DELAY = 100;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final AtomicReference<Set<String>> exportedPackages = new AtomicReference<Object>(null);
        private final Reference<ClassPath> sourcePath;
        private final RequestProcessor.Task parseTask;
        private final RequestProcessor.Task rootsTask;
        private final FileChangeAdapter folderListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                if (fe.getFile().getNameExt().equalsIgnoreCase("module-info.java")) {
                    rootsTask.schedule(100);
                }
            }
        };
        private final FileChangeAdapter moduleInfoListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                parseTask.schedule(100);
            }
        };
        private Set<FileObject> oldRoots = new HashSet<FileObject>();
        private Set<FileObject> oldModuleInfos = new HashSet<FileObject>();

        public ClassPathListener(ClassPath sourcePath) {
            this.sourcePath = new WeakReference<ClassPath>(sourcePath);
            this.parseTask = WORKER.create(() -> this.lambda$new$0(sourcePath));
            this.rootsTask = WORKER.create(() -> {
                ClassPath cp = this.sourcePath.get();
                if (cp == null) {
                    return;
                }
                HashSet<FileObject> removedRoots = new HashSet<FileObject>(this.oldRoots);
                HashSet<FileObject> removedModuleInfos = new HashSet<FileObject>(this.oldModuleInfos);
                for (FileObject root : cp.getRoots()) {
                    FileObject moduleInfo;
                    removedRoots.remove(root);
                    if (this.oldRoots.add(root)) {
                        root.addFileChangeListener((FileChangeListener)this.folderListener);
                    }
                    if ((moduleInfo = root.getFileObject("module-info.java")) == null) continue;
                    removedModuleInfos.remove(moduleInfo);
                    if (!this.oldModuleInfos.add(moduleInfo)) continue;
                    moduleInfo.addFileChangeListener((FileChangeListener)this.moduleInfoListener);
                }
                for (FileObject root : removedRoots) {
                    root.removeFileChangeListener((FileChangeListener)this.folderListener);
                }
                for (FileObject moduleInfo : removedModuleInfos) {
                    moduleInfo.removeFileChangeListener((FileChangeListener)this.moduleInfoListener);
                }
                this.parseTask.schedule(100);
            });
            this.rootsTask.schedule(100);
            sourcePath.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public Set<String> getExportedPackages() {
            return this.exportedPackages.get();
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.rootsTask.schedule(100);
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$new$0(ClassPath sourcePath) {
            moduleInfo = sourcePath.findResource("module-info.java");
            if (moduleInfo != null) {
                exported = new HashSet<String>();
                try {
                    code = moduleInfo.asText();
                    compilerTask = (JavacTask)ToolProvider.getSystemJavaCompiler().getTask(null, null, null, null, null, Collections.singleton(new TextJFO(code, moduleInfo.toURI())));
                    cut = compilerTask.parse().iterator().next();
                    mt = cut.getModule();
                    if (mt == null) ** GOTO lbl20
                    for (DirectiveTree dt : mt.getDirectives()) {
                        if (dt.getKind() != Tree.Kind.EXPORTS || (et = (ExportsTree)dt).getModuleNames() != null && !et.getModuleNames().isEmpty()) continue;
                        exported.add(et.getPackageName().toString());
                    }
                }
                catch (IOException ex) {
                    GenericModuleInfoAccessibilityQuery.LOG.log(Level.FINE, null, ex);
                }
            } else {
                exported = null;
            }
lbl20:
            // 4 sources

            this.exportedPackages.set(exported);
            this.cs.fireChange();
        }
    }

    private static final class ResultImpl
    implements AccessibilityQueryImplementation2.Result,
    ChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final ClassPathListener listener;
        private final Reference<ClassPath> sourcePath;
        private final FileObject folder;

        public ResultImpl(ClassPathListener listener, ClassPath sourcePath, FileObject folder) {
            this.listener = listener;
            this.sourcePath = new WeakReference<ClassPath>(sourcePath);
            this.folder = folder;
            listener.addChangeListener(this);
        }

        public AccessibilityQuery.Accessibility getAccessibility() {
            ClassPath sourcePath = this.sourcePath.get();
            Set<String> exported = this.listener.getExportedPackages();
            if (sourcePath == null || this.folder == null || exported == null) {
                return AccessibilityQuery.Accessibility.UNKNOWN;
            }
            String packageName = sourcePath.getResourceName(this.folder).replace('/', '.');
            return exported.contains(packageName) ? AccessibilityQuery.Accessibility.EXPORTED : AccessibilityQuery.Accessibility.PRIVATE;
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }
    }

    private final class CleanPath2Result
    extends WeakReference<AccessibilityQueryImplementation2.Result>
    implements Runnable {
        private final FileObject key;

        public CleanPath2Result(AccessibilityQueryImplementation2.Result value, FileObject key) {
            super(value, Utilities.activeReferenceQueue());
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GenericModuleInfoAccessibilityQuery genericModuleInfoAccessibilityQuery = GenericModuleInfoAccessibilityQuery.this;
            synchronized (genericModuleInfoAccessibilityQuery) {
                GenericModuleInfoAccessibilityQuery.this.path2Result.remove(this.key);
            }
        }
    }

    private static final class TextJFO
    extends SimpleJavaFileObject {
        private final String code;

        public TextJFO(String code, URI uri) {
            super(uri, JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.code;
        }
    }
}

